/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdb.DefaultDocDbBaseClientBuilder;
import software.amazon.awssdk.services.docdb.DefaultDocDbClient;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.DocDbClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbServiceClientConfiguration;
import software.amazon.awssdk.services.docdb.endpoints.DocDbEndpointProvider;
import software.amazon.awssdk.services.docdb.internal.CopyDbClusterSnapshotPresignInterceptor;
import software.amazon.awssdk.services.docdb.internal.CreateDbClusterPresignInterceptor;
import software.amazon.awssdk.services.docdb.internal.RdsPresignInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
final class DefaultDocDbClientBuilder
extends DefaultDocDbBaseClientBuilder<DocDbClientBuilder, DocDbClient>
implements DocDbClientBuilder {
    DefaultDocDbClientBuilder() {
    }

    @Override
    public DefaultDocDbClientBuilder endpointProvider(DocDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DocDbClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        List interceptors = (List)clientConfiguration.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS);
        List<QueryParametersToBodyInterceptor> queryParamsToBodyInterceptor = Collections.singletonList(new QueryParametersToBodyInterceptor());
        ArrayList<RdsPresignInterceptor> customizationInterceptors = new ArrayList<RdsPresignInterceptor>();
        customizationInterceptors.add(new CopyDbClusterSnapshotPresignInterceptor());
        customizationInterceptors.add(new CreateDbClusterPresignInterceptor());
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, (List)interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, (List)interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
        DefaultDocDbClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DocDbServiceClientConfiguration serviceClientConfiguration = DocDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDocDbClient(serviceClientConfiguration, clientConfiguration);
    }
}

