/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event source type, accompanied by one or more event category names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventCategoriesMap implements SdkPojo, Serializable,
        ToCopyableBuilder<EventCategoriesMap.Builder, EventCategoriesMap> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(EventCategoriesMap::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventCategories")
            .getter(getter(EventCategoriesMap::eventCategories))
            .setter(setter(Builder::eventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            EVENT_CATEGORIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final List<String> eventCategories;

    private EventCategoriesMap(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
    }

    /**
     * <p>
     * The source type that the returned categories belong to.
     * </p>
     * 
     * @return The source type that the returned categories belong to.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * Returns true if the EventCategories property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEventCategories() {
        return eventCategories != null && !(eventCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event categories for the specified source type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event categories for the specified source type.
     */
    public final List<String> eventCategories() {
        return eventCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventCategories() ? eventCategories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap) obj;
        return Objects.equals(sourceType(), other.sourceType()) && hasEventCategories() == other.hasEventCategories()
                && Objects.equals(eventCategories(), other.eventCategories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventCategoriesMap").add("SourceType", sourceType())
                .add("EventCategories", hasEventCategories() ? eventCategories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "EventCategories":
            return Optional.ofNullable(clazz.cast(eventCategories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventCategoriesMap, T> g) {
        return obj -> g.apply((EventCategoriesMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventCategoriesMap> {
        /**
         * <p>
         * The source type that the returned categories belong to.
         * </p>
         * 
         * @param sourceType
         *        The source type that the returned categories belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The event categories for the specified source type.
         * </p>
         * 
         * @param eventCategories
         *        The event categories for the specified source type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(Collection<String> eventCategories);

        /**
         * <p>
         * The event categories for the specified source type.
         * </p>
         * 
         * @param eventCategories
         *        The event categories for the specified source type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(String... eventCategories);
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoriesMap model) {
            sourceType(model.sourceType);
            eventCategories(model.eventCategories);
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            if (eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String... eventCategories) {
            eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @Override
        public EventCategoriesMap build() {
            return new EventCategoriesMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
