/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an instance that is part of a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterMember implements SdkPojo, Serializable, ToCopyableBuilder<DBClusterMember.Builder, DBClusterMember> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBClusterMember::dbInstanceIdentifier)).setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Boolean> IS_CLUSTER_WRITER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DBClusterMember::isClusterWriter)).setter(setter(Builder::isClusterWriter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsClusterWriter").build()).build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DBClusterMember::dbClusterParameterGroupStatus))
            .setter(setter(Builder::dbClusterParameterGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupStatus")
                    .build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DBClusterMember::promotionTier)).setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            IS_CLUSTER_WRITER_FIELD, DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD, PROMOTION_TIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbInstanceIdentifier;

    private final Boolean isClusterWriter;

    private final String dbClusterParameterGroupStatus;

    private final Integer promotionTier;

    private DBClusterMember(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.isClusterWriter = builder.isClusterWriter;
        this.dbClusterParameterGroupStatus = builder.dbClusterParameterGroupStatus;
        this.promotionTier = builder.promotionTier;
    }

    /**
     * <p>
     * Specifies the instance identifier for this member of the cluster.
     * </p>
     * 
     * @return Specifies the instance identifier for this member of the cluster.
     */
    public String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * A value that is <code>true</code> if the cluster member is the primary instance for the cluster and
     * <code>false</code> otherwise.
     * </p>
     * 
     * @return A value that is <code>true</code> if the cluster member is the primary instance for the cluster and
     *         <code>false</code> otherwise.
     */
    public Boolean isClusterWriter() {
        return isClusterWriter;
    }

    /**
     * <p>
     * Specifies the status of the cluster parameter group for this member of the DB cluster.
     * </p>
     * 
     * @return Specifies the status of the cluster parameter group for this member of the DB cluster.
     */
    public String dbClusterParameterGroupStatus() {
        return dbClusterParameterGroupStatus;
    }

    /**
     * <p>
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after
     * a failure of the existing primary instance.
     * </p>
     * 
     * @return A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary
     *         instance after a failure of the existing primary instance.
     */
    public Integer promotionTier() {
        return promotionTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(isClusterWriter());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterMember)) {
            return false;
        }
        DBClusterMember other = (DBClusterMember) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(isClusterWriter(), other.isClusterWriter())
                && Objects.equals(dbClusterParameterGroupStatus(), other.dbClusterParameterGroupStatus())
                && Objects.equals(promotionTier(), other.promotionTier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DBClusterMember").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("IsClusterWriter", isClusterWriter()).add("DBClusterParameterGroupStatus", dbClusterParameterGroupStatus())
                .add("PromotionTier", promotionTier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "IsClusterWriter":
            return Optional.ofNullable(clazz.cast(isClusterWriter()));
        case "DBClusterParameterGroupStatus":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupStatus()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterMember, T> g) {
        return obj -> g.apply((DBClusterMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterMember> {
        /**
         * <p>
         * Specifies the instance identifier for this member of the cluster.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        Specifies the instance identifier for this member of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * A value that is <code>true</code> if the cluster member is the primary instance for the cluster and
         * <code>false</code> otherwise.
         * </p>
         * 
         * @param isClusterWriter
         *        A value that is <code>true</code> if the cluster member is the primary instance for the cluster and
         *        <code>false</code> otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isClusterWriter(Boolean isClusterWriter);

        /**
         * <p>
         * Specifies the status of the cluster parameter group for this member of the DB cluster.
         * </p>
         * 
         * @param dbClusterParameterGroupStatus
         *        Specifies the status of the cluster parameter group for this member of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupStatus(String dbClusterParameterGroupStatus);

        /**
         * <p>
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance
         * after a failure of the existing primary instance.
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary
         *        instance after a failure of the existing primary instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private Boolean isClusterWriter;

        private String dbClusterParameterGroupStatus;

        private Integer promotionTier;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterMember model) {
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            isClusterWriter(model.isClusterWriter);
            dbClusterParameterGroupStatus(model.dbClusterParameterGroupStatus);
            promotionTier(model.promotionTier);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getIsClusterWriter() {
            return isClusterWriter;
        }

        @Override
        public final Builder isClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
            return this;
        }

        public final void setIsClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
        }

        public final String getDbClusterParameterGroupStatus() {
            return dbClusterParameterGroupStatus;
        }

        @Override
        public final Builder dbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
            return this;
        }

        public final void setDbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public DBClusterMember build() {
            return new DBClusterMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
