/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdb.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.docdb.model.CertificateNotFoundException;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.docdb.model.DeleteDBClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDBSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdb.model.DocDbException;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.docdb.model.InvalidRestoreException;
import software.amazon.awssdk.services.docdb.model.InvalidSubnetException;
import software.amazon.awssdk.services.docdb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.docdb.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.docdb.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StartDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StartDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StopDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StopDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.docdb.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsPublisher;
import software.amazon.awssdk.services.docdb.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link DocDbAsyncClient}.
 *
 * @see DocDbAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDocDbAsyncClient implements DocDbAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDocDbAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDocDbAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to
     * track costs that are associated with Amazon DocumentDB resources. or in a <code>Condition</code> statement in an
     * AWS Identity and Access Management (IAM) policy for Amazon DocumentDB.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Represents the input to <a>AddTagsToResource</a>.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        try {

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddTagsToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource")
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(addTagsToResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        Represents the input to <a>ApplyPendingMaintenanceAction</a>.
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        try {

            HttpResponseHandler<ApplyPendingMaintenanceActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ApplyPendingMaintenanceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse>()
                            .withOperationName("ApplyPendingMaintenanceAction")
                            .withMarshaller(new ApplyPendingMaintenanceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(applyPendingMaintenanceActionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        Represents the input to <a>CopyDBClusterParameterGroup</a>.
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException This request would cause you to exceed the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        try {

            HttpResponseHandler<CopyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDbClusterParameterGroupRequest, CopyDbClusterParameterGroupResponse>()
                            .withOperationName("CopyDBClusterParameterGroup")
                            .withMarshaller(new CopyDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(copyDbClusterParameterGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * To cancel the copy operation after it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in the <i>copying</i> status.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        Represents the input to <a>CopyDBClusterSnapshot</a>.
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException You already have a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException The request would cause you to exceed the allowed number of DB
     *         snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred when accessing an AWS KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CopyDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        try {

            HttpResponseHandler<CopyDbClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyDbClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyDbClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDbClusterSnapshotRequest, CopyDbClusterSnapshotResponse>()
                            .withOperationName("CopyDBClusterSnapshot")
                            .withMarshaller(new CopyDbClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(copyDbClusterSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB DB cluster.
     * </p>
     *
     * @param createDbClusterRequest
     *        Represents the input to <a>CreateDBCluster</a>.
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException You already have a DB cluster with the given identifier.</li>
     *         <li>InsufficientStorageClusterCapacityException There is not enough storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException The DB cluster can't be created because you have reached the maximum
     *         allowed quota of DB clusters.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it is
     *         created because of changes that were made.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group can't be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred when accessing an AWS KMS key.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CreateDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        try {

            HttpResponseHandler<CreateDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterRequest, CreateDbClusterResponse>()
                            .withOperationName("CreateDBCluster")
                            .withMarshaller(new CreateDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDbClusterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * you create it. After you create a DB cluster parameter group, you must associate it with your DB cluster. For the
     * new DB cluster parameter group and associated settings to take effect, you must then reboot the DB instances in
     * the DB cluster without failover.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon DocumentDB
     * to fully complete the create action before the DB cluster parameter group is used as the default for a new DB
     * cluster. This step is especially important for parameters that are critical when creating the default database
     * for a DB cluster, such as the character set for the default database defined by the
     * <code>character_set_database</code> parameter.
     * </p>
     * </important>
     *
     * @param createDbClusterParameterGroupRequest
     *        Represents the input of <a>CreateDBClusterParameterGroup</a>.
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException This request would cause you to exceed the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        try {

            HttpResponseHandler<CreateDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterParameterGroupRequest, CreateDbClusterParameterGroupResponse>()
                            .withOperationName("CreateDBClusterParameterGroup")
                            .withMarshaller(new CreateDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDbClusterParameterGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        Represents the input of <a>CreateDBClusterSnapshot</a>.
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException You already have a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException The request would cause you to exceed the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CreateDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        try {

            HttpResponseHandler<CreateDbClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterSnapshotRequest, CreateDbClusterSnapshotResponse>()
                            .withOperationName("CreateDBClusterSnapshot")
                            .withMarshaller(new CreateDbClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDbClusterSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     *
     * @param createDbInstanceRequest
     *        Represents the input to <a>CreateDBInstance</a>.
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException You already have a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would cause you to exceed the allowed number of DB
     *         instances.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it is
     *         created because of changes that were made.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException Storage of the specified <code>StorageType</code> can't be
     *         associated with the DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP or Amazon EC2 security group isn't authorized
     *         for the specified DB security group.</p>
     *         <p>
     *         Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred when accessing an AWS KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CreateDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        try {

            HttpResponseHandler<CreateDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbInstanceRequest, CreateDbInstanceResponse>()
                            .withOperationName("CreateDBInstance")
                            .withMarshaller(new CreateDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDbInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two Availability
     * Zones in the AWS Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        Represents the input to <a>CreateDBSubnetGroup</a>.
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <code>DBSubnetGroupName</code> is already being used by an
     *         existing DB subnet group.</li>
     *         <li>DbSubnetGroupQuotaExceededException The request would cause you to exceed the allowed number of DB
     *         subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException The request would cause you to exceed the allowed number of subnets in
     *         a DB subnet group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.CreateDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        try {

            HttpResponseHandler<CreateDbSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbSubnetGroupRequest, CreateDbSubnetGroupResponse>()
                            .withOperationName("CreateDBSubnetGroup")
                            .withMarshaller(new CreateDbSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDbSubnetGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB
     * cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not
     * deleted.
     * </p>
     * <p/>
     *
     * @param deleteDbClusterRequest
     *        Represents the input to <a>DeleteDBCluster</a>.
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     *         </li> <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li> <li>
     *         DbClusterSnapshotAlreadyExistsException You already have a DB cluster snapshot with the given identifier.
     *         </li> <li>SnapshotQuotaExceededException The request would cause you to exceed the allowed number of DB
     *         snapshots.</li> <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster
     *         snapshot state.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>DocDbException Base
     *         class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DeleteDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        try {

            HttpResponseHandler<DeleteDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterRequest, DeleteDbClusterResponse>()
                            .withOperationName("DeleteDBCluster")
                            .withMarshaller(new DeleteDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDbClusterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        Represents the input to <a>DeleteDBClusterParameterGroup</a>.
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use, or it is in a state that is
     *         not valid. If you are trying to delete the parameter group, you can't delete it when the parameter group
     *         is in this state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDBClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        try {

            HttpResponseHandler<DeleteDBClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDBClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDBClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterParameterGroupRequest, DeleteDBClusterParameterGroupResponse>()
                            .withOperationName("DeleteDBClusterParameterGroup")
                            .withMarshaller(new DeleteDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDbClusterParameterGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbClusterSnapshotRequest
     *        Represents the input to <a>DeleteDBClusterSnapshot</a>.
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        try {

            HttpResponseHandler<DeleteDbClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterSnapshotRequest, DeleteDbClusterSnapshotResponse>()
                            .withOperationName("DeleteDBClusterSnapshot")
                            .withMarshaller(new DeleteDbClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDbClusterSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned DB instance.
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        Represents the input to <a>DeleteDBInstance</a>.
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already being used by an
     *         existing snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request would cause you to exceed the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DeleteDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        try {

            HttpResponseHandler<DeleteDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbInstanceRequest, DeleteDbInstanceResponse>()
                            .withOperationName("DeleteDBInstance")
                            .withMarshaller(new DeleteDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDbInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     *        Represents the input to <a>DeleteDBSubnetGroup</a>.
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group can't be deleted because it's in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet isn't in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DeleteDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDBSubnetGroupResponse> deleteDBSubnetGroup(
            DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        try {

            HttpResponseHandler<DeleteDBSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDBSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDBSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbSubnetGroupRequest, DeleteDBSubnetGroupResponse>()
                            .withOperationName("DeleteDBSubnetGroup")
                            .withMarshaller(new DeleteDbSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDbSubnetGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of certificate authority (CA) certificates provided by Amazon RDS for this AWS account.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            DescribeCertificatesRequest describeCertificatesRequest) {
        try {

            HttpResponseHandler<DescribeCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCertificatesRequest, DescribeCertificatesResponse>()
                            .withOperationName("DescribeCertificates")
                            .withMarshaller(new DescribeCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list contains only the description of the
     * specified DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        Represents the input to <a>DescribeDBClusterParameterGroups</a>.
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        try {

            HttpResponseHandler<DescribeDbClusterParameterGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterParameterGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParameterGroupsRequest, DescribeDbClusterParameterGroupsResponse>()
                            .withOperationName("DescribeDBClusterParameterGroups")
                            .withMarshaller(new DescribeDbClusterParameterGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbClusterParameterGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        Represents the input to <a>DescribeDBClusterParameters</a>.
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        try {

            HttpResponseHandler<DescribeDbClusterParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParametersRequest, DescribeDbClusterParametersResponse>()
                            .withOperationName("DescribeDBClusterParameters")
                            .withMarshaller(new DescribeDbClusterParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbClusterParametersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When you share snapshots with other AWS accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the
     * manual DB cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code>
     * attribute, then the manual DB cluster snapshot is public and can be copied or restored by all AWS accounts.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        Represents the input to <a>DescribeDBClusterSnapshotAttributes</a>.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        try {

            HttpResponseHandler<DescribeDbClusterSnapshotAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotAttributesRequest, DescribeDbClusterSnapshotAttributesResponse>()
                            .withOperationName("DescribeDBClusterSnapshotAttributes")
                            .withMarshaller(new DescribeDbClusterSnapshotAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbClusterSnapshotAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API operation supports pagination.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        Represents the input to <a>DescribeDBClusterSnapshots</a>.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        try {

            HttpResponseHandler<DescribeDbClusterSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>()
                            .withOperationName("DescribeDBClusterSnapshots")
                            .withMarshaller(new DescribeDbClusterSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbClusterSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB DB clusters. This API operation supports pagination.
     * </p>
     *
     * @param describeDbClustersRequest
     *        Represents the input to <a>DescribeDBClusters</a>.
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        try {

            HttpResponseHandler<DescribeDbClustersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClustersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClustersRequest, DescribeDbClustersResponse>()
                            .withOperationName("DescribeDBClusters")
                            .withMarshaller(new DescribeDbClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbClustersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB DB clusters. This API operation supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeDbClustersRequest
     *        Represents the input to <a>DescribeDBClusters</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeDBClustersPublisher describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) {
        return new DescribeDBClustersPublisher(this, applyPaginatorUserAgent(describeDbClustersRequest));
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        Represents the input to <a>DescribeDBEngineVersions</a>.
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        try {

            HttpResponseHandler<DescribeDbEngineVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbEngineVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbEngineVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbEngineVersionsRequest, DescribeDbEngineVersionsResponse>()
                            .withOperationName("DescribeDBEngineVersions")
                            .withMarshaller(new DescribeDbEngineVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbEngineVersionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        Represents the input to <a>DescribeDBEngineVersions</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        return new DescribeDBEngineVersionsPublisher(this, applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     *
     * @param describeDbInstancesRequest
     *        Represents the input to <a>DescribeDBInstances</a>.
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            DescribeDbInstancesRequest describeDbInstancesRequest) {
        try {

            HttpResponseHandler<DescribeDbInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbInstancesRequest, DescribeDbInstancesResponse>()
                            .withOperationName("DescribeDBInstances")
                            .withMarshaller(new DescribeDbInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbInstancesRequest
     *        Represents the input to <a>DescribeDBInstances</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeDBInstancesPublisher describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return new DescribeDBInstancesPublisher(this, applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        Represents the input to <a>DescribeDBSubnetGroups</a>.
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        try {

            HttpResponseHandler<DescribeDbSubnetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbSubnetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbSubnetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSubnetGroupsRequest, DescribeDbSubnetGroupsResponse>()
                            .withOperationName("DescribeDBSubnetGroups")
                            .withMarshaller(new DescribeDbSubnetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDbSubnetGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        Represents the input to <a>DescribeDBSubnetGroups</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        return new DescribeDBSubnetGroupsPublisher(this, applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        Represents the input to <a>DescribeEngineDefaultClusterParameters</a>.
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        try {

            HttpResponseHandler<DescribeEngineDefaultClusterParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEngineDefaultClusterParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultClusterParametersRequest, DescribeEngineDefaultClusterParametersResponse>()
                            .withOperationName("DescribeEngineDefaultClusterParameters")
                            .withMarshaller(new DescribeEngineDefaultClusterParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEngineDefaultClusterParametersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        Represents the input to <a>DescribeEventCategories</a>.
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        try {

            HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventCategoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventCategoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories")
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEventCategoriesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. You can obtain events specific to a particular DB instance, DB security group, DB snapshot, or DB parameter
     * group by providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input to <a>DescribeEvents</a>.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        try {

            HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                            .withOperationName("DescribeEvents")
                            .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEventsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. You can obtain events specific to a particular DB instance, DB security group, DB snapshot, or DB parameter
     * group by providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdb.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdb.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input to <a>DescribeEvents</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, applyPaginatorUserAgent(describeEventsRequest));
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        try {

            HttpResponseHandler<DescribeOrderableDbInstanceOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableDbInstanceOptionsRequest, DescribeOrderableDbInstanceOptionsResponse>()
                            .withOperationName("DescribeOrderableDBInstanceOptions")
                            .withMarshaller(new DescribeOrderableDbInstanceOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrderableDbInstanceOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        return new DescribeOrderableDBInstanceOptionsPublisher(this,
                applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        Represents the input to <a>DescribePendingMaintenanceActions</a>.
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        try {

            HttpResponseHandler<DescribePendingMaintenanceActionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePendingMaintenanceActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse>()
                            .withOperationName("DescribePendingMaintenanceActions")
                            .withMarshaller(new DescribePendingMaintenanceActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePendingMaintenanceActionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * A failover for a DB cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the DB
     * cluster to be the primary instance (the cluster writer).
     * </p>
     * <p>
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one
     * exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     * </p>
     *
     * @param failoverDbClusterRequest
     *        Represents the input to <a>FailoverDBCluster</a>.
     * @return A Java Future containing the result of the FailoverDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.FailoverDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) {
        try {

            HttpResponseHandler<FailoverDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(FailoverDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<FailoverDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FailoverDbClusterRequest, FailoverDbClusterResponse>()
                            .withOperationName("FailoverDBCluster")
                            .withMarshaller(new FailoverDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(failoverDbClusterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags on an Amazon DocumentDB resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        Represents the input to <a>ListTagsForResource</a>.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        try {

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTagsForResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a setting for an Amazon DocumentDB DB cluster. You can change one or more database configuration
     * parameters by specifying these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbClusterRequest
     *        Represents the input to <a>ModifyDBCluster</a>.
     * @return A Java Future containing the result of the ModifyDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it is
     *         created because of changes that were made.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group can't be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>DbClusterAlreadyExistsException You already have a DB cluster with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ModifyDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) {
        try {

            HttpResponseHandler<ModifyDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterRequest, ModifyDbClusterResponse>()
                            .withOperationName("ModifyDBCluster")
                            .withMarshaller(new ModifyDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyDbClusterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or
     * maintenance window before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon DocumentDB
     * to fully complete the create action before the parameter group is used as the default for a new DB cluster. This
     * step is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter.
     * </p>
     * </important>
     *
     * @param modifyDbClusterParameterGroupRequest
     *        Represents the input to <a>ModifyDBClusterParameterGroup</a>.
     * @return A Java Future containing the result of the ModifyDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use, or it is in a state that is
     *         not valid. If you are trying to delete the parameter group, you can't delete it when the parameter group
     *         is in this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ModifyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) {
        try {

            HttpResponseHandler<ModifyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterParameterGroupRequest, ModifyDbClusterParameterGroupResponse>()
                            .withOperationName("ModifyDBClusterParameterGroup")
                            .withMarshaller(new ModifyDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyDbClusterParameterGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other AWS accounts, specify <code>restore</code> as the
     * <code>AttributeName</code>, and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the AWS
     * accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make
     * the manual DB cluster snapshot public, which means that it can be copied or restored by all AWS accounts. Do not
     * add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you
     * don't want available to all AWS accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but
     * only by specifying a list of authorized AWS account IDs for the <code>ValuesToAdd</code> parameter. You can't use
     * <code>all</code> as a value for that parameter in this case.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     *        Represents the input to <a>ModifyDBClusterSnapshotAttribute</a>.
     * @return A Java Future containing the result of the ModifyDBClusterSnapshotAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster snapshot state.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        try {

            HttpResponseHandler<ModifyDbClusterSnapshotAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterSnapshotAttributeRequest, ModifyDbClusterSnapshotAttributeResponse>()
                            .withOperationName("ModifyDBClusterSnapshotAttribute")
                            .withMarshaller(new ModifyDbClusterSnapshotAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyDbClusterSnapshotAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbInstanceRequest
     *        Represents the input to <a>ModifyDBInstance</a>.
     * @return A Java Future containing the result of the ModifyDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>DbInstanceAlreadyExistsException You already have a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it is
     *         created because of changes that were made.</li>
     *         <li>DbUpgradeDependencyFailureException The DB upgrade failed because a resource that the DB depends on
     *         can't be modified.</li>
     *         <li>StorageTypeNotSupportedException Storage of the specified <code>StorageType</code> can't be
     *         associated with the DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP or Amazon EC2 security group isn't authorized
     *         for the specified DB security group.</p>
     *         <p>
     *         Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ModifyDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        try {

            HttpResponseHandler<ModifyDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbInstanceRequest, ModifyDbInstanceResponse>()
                            .withOperationName("ModifyDBInstance")
                            .withMarshaller(new ModifyDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyDbInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two
     * Availability Zones in the AWS Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     *        Represents the input to <a>ModifyDBSubnetGroup</a>.
     * @return A Java Future containing the result of the ModifyDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetQuotaExceededException The request would cause you to exceed the allowed number of subnets in
     *         a DB subnet group.</li>
     *         <li>SubnetAlreadyInUseException The DB subnet is already in use in the Availability Zone.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ModifyDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(
            ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) {
        try {

            HttpResponseHandler<ModifyDbSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbSubnetGroupRequest, ModifyDbSubnetGroupResponse>()
                            .withOperationName("ModifyDBSubnetGroup")
                            .withMarshaller(new ModifyDbSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyDbSubnetGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * changes, or if you change the DB cluster parameter group that is associated with the DB instance, you must reboot
     * the instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to <i>rebooting</i>.
     * </p>
     *
     * @param rebootDbInstanceRequest
     *        Represents the input to <a>RebootDBInstance</a>.
     * @return A Java Future containing the result of the RebootDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.RebootDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) {
        try {

            HttpResponseHandler<RebootDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(RebootDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RebootDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootDbInstanceRequest, RebootDbInstanceResponse>()
                            .withOperationName("RebootDBInstance")
                            .withMarshaller(new RebootDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(rebootDbInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon DocumentDB resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Represents the input to <a>RemoveTagsFromResource</a>.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        try {

            HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveTagsFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveTagsFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource")
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeTagsFromResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters,
     * submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * cluster parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance reboot.
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     *        Represents the input to <a>ResetDBClusterParameterGroup</a>.
     * @return A Java Future containing the result of the ResetDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use, or it is in a state that is
     *         not valid. If you are trying to delete the parameter group, you can't delete it when the parameter group
     *         is in this state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.ResetDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        try {

            HttpResponseHandler<ResetDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResetDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResetDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetDbClusterParameterGroupRequest, ResetDbClusterParameterGroupResponse>()
                            .withOperationName("ResetDBClusterParameterGroup")
                            .withMarshaller(new ResetDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(resetDbClusterParameterGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point
     * with the same configuration as the original source DB cluster, except that the new DB cluster is created with the
     * default security group.
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     *        Represents the input to <a>RestoreDBClusterFromSnapshot</a>.
     * @return A Java Future containing the result of the RestoreDBClusterFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException You already have a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException The DB cluster can't be created because you have reached the maximum
     *         allowed quota of DB clusters.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster doesn't have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is not enough storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster snapshot state.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it is
     *         created because of changes that were made.</li>
     *         <li>InvalidRestoreException You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB
     *         instance.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>KmsKeyNotAccessibleException An error occurred when accessing an AWS KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.RestoreDBClusterFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        try {

            HttpResponseHandler<RestoreDbClusterFromSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbClusterFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterFromSnapshotRequest, RestoreDbClusterFromSnapshotResponse>()
                            .withOperationName("RestoreDBClusterFromSnapshot")
                            .withMarshaller(new RestoreDbClusterFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(restoreDbClusterFromSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     *        Represents the input to <a>RestoreDBClusterToPointInTime</a>.
     * @return A Java Future containing the result of the RestoreDBClusterToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException You already have a DB cluster with the given identifier.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterQuotaExceededException The DB cluster can't be created because you have reached the maximum
     *         allowed quota of DB clusters.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster doesn't have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is not enough storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>InvalidDbClusterSnapshotStateException The provided value isn't a valid DB cluster snapshot state.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>InvalidRestoreException You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB
     *         instance.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or multiple subnets were requested that are
     *         not all in a common virtual private cloud (VPC).</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it is
     *         created because of changes that were made.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred when accessing an AWS KMS key.</li>
     *         <li>StorageQuotaExceededException The request would cause you to exceed the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.RestoreDBClusterToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        try {

            HttpResponseHandler<RestoreDbClusterToPointInTimeResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbClusterToPointInTimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterToPointInTimeRequest, RestoreDbClusterToPointInTimeResponse>()
                            .withOperationName("RestoreDBClusterToPointInTime")
                            .withMarshaller(new RestoreDbClusterToPointInTimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(restoreDbClusterToPointInTimeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts the stopped cluster that is specified by <code>DBClusterIdentifier</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster</a>.
     * </p>
     *
     * @param startDbClusterRequest
     * @return A Java Future containing the result of the StartDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.StartDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartDbClusterResponse> startDBCluster(StartDbClusterRequest startDbClusterRequest) {
        try {

            HttpResponseHandler<StartDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDbClusterRequest, StartDbClusterResponse>()
                            .withOperationName("StartDBCluster")
                            .withMarshaller(new StartDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startDbClusterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the running cluster that is specified by <code>DBClusterIdentifier</code>. The cluster must be in the
     * <i>available</i> state. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster</a>.
     * </p>
     *
     * @param stopDbClusterRequest
     * @return A Java Future containing the result of the StopDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster isn't in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbAsyncClient.StopDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopDbClusterResponse> stopDBCluster(StopDbClusterRequest stopDbClusterRequest) {
        try {

            HttpResponseHandler<StopDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(StopDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StopDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDbClusterRequest, StopDbClusterResponse>()
                            .withOperationName("StopDBCluster")
                            .withMarshaller(new StopDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(stopDbClusterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded")
                                .exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRestoreFault")
                                .exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault")
                                .exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceNotFound")
                                .exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs")
                                .exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists")
                                .exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault")
                                .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure")
                                .exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound")
                                .exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundFault")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity")
                                .exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotNotFound")
                                .exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageTypeNotSupported")
                                .exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists")
                                .exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse")
                                .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBInstanceState")
                                .exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState")
                                .exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageQuotaExceeded")
                                .exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState")
                                .exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(DocDbException::builder).build();
    }

    private <T extends DocDbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
