/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.DlmResponse;
import software.amazon.awssdk.services.dlm.model.LifecyclePolicySummary;
import software.amazon.awssdk.services.dlm.model.LifecyclePolicySummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLifecyclePoliciesResponse
extends DlmResponse
implements ToCopyableBuilder<Builder, GetLifecyclePoliciesResponse> {
    private static final SdkField<List<LifecyclePolicySummary>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLifecyclePoliciesResponse.getter(GetLifecyclePoliciesResponse::policies)).setter(GetLifecyclePoliciesResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD));
    private final List<LifecyclePolicySummary> policies;

    private GetLifecyclePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
    }

    public List<LifecyclePolicySummary> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePoliciesResponse)) {
            return false;
        }
        GetLifecyclePoliciesResponse other = (GetLifecyclePoliciesResponse)((Object)obj);
        return Objects.equals(this.policies(), other.policies());
    }

    public String toString() {
        return ToString.builder((String)"GetLifecyclePoliciesResponse").add("Policies", this.policies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePoliciesResponse, T> g) {
        return obj -> g.apply((GetLifecyclePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmResponse.BuilderImpl
    implements Builder {
        private List<LifecyclePolicySummary> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePoliciesResponse model) {
            super(model);
            this.policies(model.policies);
        }

        public final Collection<LifecyclePolicySummary.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(LifecyclePolicySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<LifecyclePolicySummary> policies) {
            this.policies = LifecyclePolicySummaryListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(LifecyclePolicySummary ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<LifecyclePolicySummary.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (LifecyclePolicySummary)((LifecyclePolicySummary.Builder)LifecyclePolicySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<LifecyclePolicySummary.BuilderImpl> policies) {
            this.policies = LifecyclePolicySummaryListCopier.copyFromBuilder(policies);
        }

        @Override
        public GetLifecyclePoliciesResponse build() {
            return new GetLifecyclePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DlmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLifecyclePoliciesResponse> {
        public Builder policies(Collection<LifecyclePolicySummary> var1);

        public Builder policies(LifecyclePolicySummary ... var1);

        public Builder policies(Consumer<LifecyclePolicySummary.Builder> ... var1);
    }
}

