/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.Parameters;
import software.amazon.awssdk.services.dlm.model.PolicyTypeValues;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValues;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValuesListCopier;
import software.amazon.awssdk.services.dlm.model.Schedule;
import software.amazon.awssdk.services.dlm.model.ScheduleListCopier;
import software.amazon.awssdk.services.dlm.model.Tag;
import software.amazon.awssdk.services.dlm.model.TargetTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyDetails> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyDetails.getter(PolicyDetails::policyTypeAsString)).setter(PolicyDetails.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PolicyDetails.getter(PolicyDetails::resourceTypesAsStrings)).setter(PolicyDetails.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TARGET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PolicyDetails.getter(PolicyDetails::targetTags)).setter(PolicyDetails.setter(Builder::targetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Schedule>> SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PolicyDetails.getter(PolicyDetails::schedules)).setter(PolicyDetails.setter(Builder::schedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PolicyDetails.getter(PolicyDetails::parameters)).setter(PolicyDetails.setter(Builder::parameters)).constructor(Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD, RESOURCE_TYPES_FIELD, TARGET_TAGS_FIELD, SCHEDULES_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyType;
    private final List<String> resourceTypes;
    private final List<Tag> targetTags;
    private final List<Schedule> schedules;
    private final Parameters parameters;

    private PolicyDetails(BuilderImpl builder) {
        this.policyType = builder.policyType;
        this.resourceTypes = builder.resourceTypes;
        this.targetTags = builder.targetTags;
        this.schedules = builder.schedules;
        this.parameters = builder.parameters;
    }

    public PolicyTypeValues policyType() {
        return PolicyTypeValues.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    public List<ResourceTypeValues> resourceTypes() {
        return ResourceTypeValuesListCopier.copyStringToEnum(this.resourceTypes);
    }

    public List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public List<Tag> targetTags() {
        return this.targetTags;
    }

    public List<Schedule> schedules() {
        return this.schedules;
    }

    public Parameters parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedules());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails)obj;
        return Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && Objects.equals(this.targetTags(), other.targetTags()) && Objects.equals(this.schedules(), other.schedules()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"PolicyDetails").add("PolicyType", (Object)this.policyTypeAsString()).add("ResourceTypes", this.resourceTypesAsStrings()).add("TargetTags", this.targetTags()).add("Schedules", this.schedules()).add("Parameters", (Object)this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "TargetTags": {
                return Optional.ofNullable(clazz.cast(this.targetTags()));
            }
            case "Schedules": {
                return Optional.ofNullable(clazz.cast(this.schedules()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDetails, T> g) {
        return obj -> g.apply((PolicyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyType;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> targetTags = DefaultSdkAutoConstructList.getInstance();
        private List<Schedule> schedules = DefaultSdkAutoConstructList.getInstance();
        private Parameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDetails model) {
            this.policyType(model.policyType);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.targetTags(model.targetTags);
            this.schedules(model.schedules);
            this.parameters(model.parameters);
        }

        public final String getPolicyTypeAsString() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyTypeValues policyType) {
            this.policyType(policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final Collection<String> getResourceTypesAsStrings() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeValues ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
        }

        public final Collection<Tag.Builder> getTargetTags() {
            return this.targetTags != null ? (Collection)this.targetTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetTags(Collection<Tag> targetTags) {
            this.targetTags = TargetTagListCopier.copy(targetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(Tag ... targetTags) {
            this.targetTags(Arrays.asList(targetTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(Consumer<Tag.Builder> ... targetTags) {
            this.targetTags(Stream.of(targetTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetTags(Collection<Tag.BuilderImpl> targetTags) {
            this.targetTags = TargetTagListCopier.copyFromBuilder(targetTags);
        }

        public final Collection<Schedule.Builder> getSchedules() {
            return this.schedules != null ? (Collection)this.schedules.stream().map(Schedule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schedules(Collection<Schedule> schedules) {
            this.schedules = ScheduleListCopier.copy(schedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Schedule ... schedules) {
            this.schedules(Arrays.asList(schedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Consumer<Schedule.Builder> ... schedules) {
            this.schedules(Stream.of(schedules).map(c -> (Schedule)((Schedule.Builder)Schedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchedules(Collection<Schedule.BuilderImpl> schedules) {
            this.schedules = ScheduleListCopier.copyFromBuilder(schedules);
        }

        public final Parameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public PolicyDetails build() {
            return new PolicyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyDetails> {
        public Builder policyType(String var1);

        public Builder policyType(PolicyTypeValues var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceTypeValues> var1);

        public Builder resourceTypes(ResourceTypeValues ... var1);

        public Builder targetTags(Collection<Tag> var1);

        public Builder targetTags(Tag ... var1);

        public Builder targetTags(Consumer<Tag.Builder> ... var1);

        public Builder schedules(Collection<Schedule> var1);

        public Builder schedules(Schedule ... var1);

        public Builder schedules(Consumer<Schedule.Builder> ... var1);

        public Builder parameters(Parameters var1);

        default public Builder parameters(Consumer<Parameters.Builder> parameters) {
            return this.parameters((Parameters)((Parameters.Builder)Parameters.builder().applyMutation(parameters)).build());
        }
    }
}

