/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.DlmRequest;
import software.amazon.awssdk.services.dlm.model.PolicyDetails;
import software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLifecyclePolicyRequest
extends DlmRequest
implements ToCopyableBuilder<Builder, UpdateLifecyclePolicyRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::policyId)).setter(UpdateLifecyclePolicyRequest.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyId").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::executionRoleArn)).setter(UpdateLifecyclePolicyRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::stateAsString)).setter(UpdateLifecyclePolicyRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::description)).setter(UpdateLifecyclePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::policyDetails)).setter(UpdateLifecyclePolicyRequest.setter(Builder::policyDetails)).constructor(PolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, EXECUTION_ROLE_ARN_FIELD, STATE_FIELD, DESCRIPTION_FIELD, POLICY_DETAILS_FIELD));
    private final String policyId;
    private final String executionRoleArn;
    private final String state;
    private final String description;
    private final PolicyDetails policyDetails;

    private UpdateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.executionRoleArn = builder.executionRoleArn;
        this.state = builder.state;
        this.description = builder.description;
        this.policyDetails = builder.policyDetails;
    }

    public String policyId() {
        return this.policyId;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public SettablePolicyStateValues state() {
        return SettablePolicyStateValues.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String description() {
        return this.description;
    }

    public PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLifecyclePolicyRequest)) {
            return false;
        }
        UpdateLifecyclePolicyRequest other = (UpdateLifecyclePolicyRequest)((Object)obj);
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.policyDetails(), other.policyDetails());
    }

    public String toString() {
        return ToString.builder((String)"UpdateLifecyclePolicyRequest").add("PolicyId", (Object)this.policyId()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("PolicyDetails", (Object)this.policyDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((UpdateLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmRequest.BuilderImpl
    implements Builder {
        private String policyId;
        private String executionRoleArn;
        private String state;
        private String description;
        private PolicyDetails policyDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLifecyclePolicyRequest model) {
            super(model);
            this.policyId(model.policyId);
            this.executionRoleArn(model.executionRoleArn);
            this.state(model.state);
            this.description(model.description);
            this.policyDetails(model.policyDetails);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SettablePolicyStateValues state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return this.policyDetails != null ? this.policyDetails.toBuilder() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLifecyclePolicyRequest build() {
            return new UpdateLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DlmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLifecyclePolicyRequest> {
        public Builder policyId(String var1);

        public Builder executionRoleArn(String var1);

        public Builder state(String var1);

        public Builder state(SettablePolicyStateValues var1);

        public Builder description(String var1);

        public Builder policyDetails(PolicyDetails var1);

        default public Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return this.policyDetails((PolicyDetails)((PolicyDetails.Builder)PolicyDetails.builder().applyMutation(policyDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

