/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.ArchiveRule;
import software.amazon.awssdk.services.dlm.model.CreateRule;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyRule;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyRulesCopier;
import software.amazon.awssdk.services.dlm.model.DeprecateRule;
import software.amazon.awssdk.services.dlm.model.FastRestoreRule;
import software.amazon.awssdk.services.dlm.model.RetainRule;
import software.amazon.awssdk.services.dlm.model.ShareRule;
import software.amazon.awssdk.services.dlm.model.ShareRulesCopier;
import software.amazon.awssdk.services.dlm.model.Tag;
import software.amazon.awssdk.services.dlm.model.TagsToAddListCopier;
import software.amazon.awssdk.services.dlm.model.VariableTagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schedule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Schedule.getter(Schedule::name)).setter(Schedule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(Schedule.getter(Schedule::copyTags)).setter(Schedule.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<List<Tag>> TAGS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsToAdd").getter(Schedule.getter(Schedule::tagsToAdd)).setter(Schedule.setter(Builder::tagsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> VARIABLE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VariableTags").getter(Schedule.getter(Schedule::variableTags)).setter(Schedule.setter(Builder::variableTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariableTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CreateRule> CREATE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateRule").getter(Schedule.getter(Schedule::createRule)).setter(Schedule.setter(Builder::createRule)).constructor(CreateRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateRule").build()}).build();
    private static final SdkField<RetainRule> RETAIN_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetainRule").getter(Schedule.getter(Schedule::retainRule)).setter(Schedule.setter(Builder::retainRule)).constructor(RetainRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()}).build();
    private static final SdkField<FastRestoreRule> FAST_RESTORE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FastRestoreRule").getter(Schedule.getter(Schedule::fastRestoreRule)).setter(Schedule.setter(Builder::fastRestoreRule)).constructor(FastRestoreRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastRestoreRule").build()}).build();
    private static final SdkField<List<CrossRegionCopyRule>> CROSS_REGION_COPY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossRegionCopyRules").getter(Schedule.getter(Schedule::crossRegionCopyRules)).setter(Schedule.setter(Builder::crossRegionCopyRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopyRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossRegionCopyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ShareRule>> SHARE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShareRules").getter(Schedule.getter(Schedule::shareRules)).setter(Schedule.setter(Builder::shareRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShareRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeprecateRule> DEPRECATE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeprecateRule").getter(Schedule.getter(Schedule::deprecateRule)).setter(Schedule.setter(Builder::deprecateRule)).constructor(DeprecateRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecateRule").build()}).build();
    private static final SdkField<ArchiveRule> ARCHIVE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArchiveRule").getter(Schedule.getter(Schedule::archiveRule)).setter(Schedule.setter(Builder::archiveRule)).constructor(ArchiveRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COPY_TAGS_FIELD, TAGS_TO_ADD_FIELD, VARIABLE_TAGS_FIELD, CREATE_RULE_FIELD, RETAIN_RULE_FIELD, FAST_RESTORE_RULE_FIELD, CROSS_REGION_COPY_RULES_FIELD, SHARE_RULES_FIELD, DEPRECATE_RULE_FIELD, ARCHIVE_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Schedule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Boolean copyTags;
    private final List<Tag> tagsToAdd;
    private final List<Tag> variableTags;
    private final CreateRule createRule;
    private final RetainRule retainRule;
    private final FastRestoreRule fastRestoreRule;
    private final List<CrossRegionCopyRule> crossRegionCopyRules;
    private final List<ShareRule> shareRules;
    private final DeprecateRule deprecateRule;
    private final ArchiveRule archiveRule;

    private Schedule(BuilderImpl builder) {
        this.name = builder.name;
        this.copyTags = builder.copyTags;
        this.tagsToAdd = builder.tagsToAdd;
        this.variableTags = builder.variableTags;
        this.createRule = builder.createRule;
        this.retainRule = builder.retainRule;
        this.fastRestoreRule = builder.fastRestoreRule;
        this.crossRegionCopyRules = builder.crossRegionCopyRules;
        this.shareRules = builder.shareRules;
        this.deprecateRule = builder.deprecateRule;
        this.archiveRule = builder.archiveRule;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final boolean hasTagsToAdd() {
        return this.tagsToAdd != null && !(this.tagsToAdd instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagsToAdd() {
        return this.tagsToAdd;
    }

    public final boolean hasVariableTags() {
        return this.variableTags != null && !(this.variableTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> variableTags() {
        return this.variableTags;
    }

    public final CreateRule createRule() {
        return this.createRule;
    }

    public final RetainRule retainRule() {
        return this.retainRule;
    }

    public final FastRestoreRule fastRestoreRule() {
        return this.fastRestoreRule;
    }

    public final boolean hasCrossRegionCopyRules() {
        return this.crossRegionCopyRules != null && !(this.crossRegionCopyRules instanceof SdkAutoConstructList);
    }

    public final List<CrossRegionCopyRule> crossRegionCopyRules() {
        return this.crossRegionCopyRules;
    }

    public final boolean hasShareRules() {
        return this.shareRules != null && !(this.shareRules instanceof SdkAutoConstructList);
    }

    public final List<ShareRule> shareRules() {
        return this.shareRules;
    }

    public final DeprecateRule deprecateRule() {
        return this.deprecateRule;
    }

    public final ArchiveRule archiveRule() {
        return this.archiveRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsToAdd() ? this.tagsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariableTags() ? this.variableTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.fastRestoreRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionCopyRules() ? this.crossRegionCopyRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShareRules() ? this.shareRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecateRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.copyTags(), other.copyTags()) && this.hasTagsToAdd() == other.hasTagsToAdd() && Objects.equals(this.tagsToAdd(), other.tagsToAdd()) && this.hasVariableTags() == other.hasVariableTags() && Objects.equals(this.variableTags(), other.variableTags()) && Objects.equals(this.createRule(), other.createRule()) && Objects.equals(this.retainRule(), other.retainRule()) && Objects.equals(this.fastRestoreRule(), other.fastRestoreRule()) && this.hasCrossRegionCopyRules() == other.hasCrossRegionCopyRules() && Objects.equals(this.crossRegionCopyRules(), other.crossRegionCopyRules()) && this.hasShareRules() == other.hasShareRules() && Objects.equals(this.shareRules(), other.shareRules()) && Objects.equals(this.deprecateRule(), other.deprecateRule()) && Objects.equals(this.archiveRule(), other.archiveRule());
    }

    public final String toString() {
        return ToString.builder((String)"Schedule").add("Name", (Object)this.name()).add("CopyTags", (Object)this.copyTags()).add("TagsToAdd", this.hasTagsToAdd() ? this.tagsToAdd() : null).add("VariableTags", this.hasVariableTags() ? this.variableTags() : null).add("CreateRule", (Object)this.createRule()).add("RetainRule", (Object)this.retainRule()).add("FastRestoreRule", (Object)this.fastRestoreRule()).add("CrossRegionCopyRules", this.hasCrossRegionCopyRules() ? this.crossRegionCopyRules() : null).add("ShareRules", this.hasShareRules() ? this.shareRules() : null).add("DeprecateRule", (Object)this.deprecateRule()).add("ArchiveRule", (Object)this.archiveRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "TagsToAdd": {
                return Optional.ofNullable(clazz.cast(this.tagsToAdd()));
            }
            case "VariableTags": {
                return Optional.ofNullable(clazz.cast(this.variableTags()));
            }
            case "CreateRule": {
                return Optional.ofNullable(clazz.cast(this.createRule()));
            }
            case "RetainRule": {
                return Optional.ofNullable(clazz.cast(this.retainRule()));
            }
            case "FastRestoreRule": {
                return Optional.ofNullable(clazz.cast(this.fastRestoreRule()));
            }
            case "CrossRegionCopyRules": {
                return Optional.ofNullable(clazz.cast(this.crossRegionCopyRules()));
            }
            case "ShareRules": {
                return Optional.ofNullable(clazz.cast(this.shareRules()));
            }
            case "DeprecateRule": {
                return Optional.ofNullable(clazz.cast(this.deprecateRule()));
            }
            case "ArchiveRule": {
                return Optional.ofNullable(clazz.cast(this.archiveRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("CopyTags", COPY_TAGS_FIELD);
        map.put("TagsToAdd", TAGS_TO_ADD_FIELD);
        map.put("VariableTags", VARIABLE_TAGS_FIELD);
        map.put("CreateRule", CREATE_RULE_FIELD);
        map.put("RetainRule", RETAIN_RULE_FIELD);
        map.put("FastRestoreRule", FAST_RESTORE_RULE_FIELD);
        map.put("CrossRegionCopyRules", CROSS_REGION_COPY_RULES_FIELD);
        map.put("ShareRules", SHARE_RULES_FIELD);
        map.put("DeprecateRule", DEPRECATE_RULE_FIELD);
        map.put("ArchiveRule", ARCHIVE_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean copyTags;
        private List<Tag> tagsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> variableTags = DefaultSdkAutoConstructList.getInstance();
        private CreateRule createRule;
        private RetainRule retainRule;
        private FastRestoreRule fastRestoreRule;
        private List<CrossRegionCopyRule> crossRegionCopyRules = DefaultSdkAutoConstructList.getInstance();
        private List<ShareRule> shareRules = DefaultSdkAutoConstructList.getInstance();
        private DeprecateRule deprecateRule;
        private ArchiveRule archiveRule;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.name(model.name);
            this.copyTags(model.copyTags);
            this.tagsToAdd(model.tagsToAdd);
            this.variableTags(model.variableTags);
            this.createRule(model.createRule);
            this.retainRule(model.retainRule);
            this.fastRestoreRule(model.fastRestoreRule);
            this.crossRegionCopyRules(model.crossRegionCopyRules);
            this.shareRules(model.shareRules);
            this.deprecateRule(model.deprecateRule);
            this.archiveRule(model.archiveRule);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final List<Tag.Builder> getTagsToAdd() {
            List<Tag.Builder> result = TagsToAddListCopier.copyToBuilder(this.tagsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsToAdd(Collection<Tag.BuilderImpl> tagsToAdd) {
            this.tagsToAdd = TagsToAddListCopier.copyFromBuilder(tagsToAdd);
        }

        @Override
        public final Builder tagsToAdd(Collection<Tag> tagsToAdd) {
            this.tagsToAdd = TagsToAddListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Tag ... tagsToAdd) {
            this.tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Consumer<Tag.Builder> ... tagsToAdd) {
            this.tagsToAdd(Stream.of(tagsToAdd).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getVariableTags() {
            List<Tag.Builder> result = VariableTagsListCopier.copyToBuilder(this.variableTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariableTags(Collection<Tag.BuilderImpl> variableTags) {
            this.variableTags = VariableTagsListCopier.copyFromBuilder(variableTags);
        }

        @Override
        public final Builder variableTags(Collection<Tag> variableTags) {
            this.variableTags = VariableTagsListCopier.copy(variableTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableTags(Tag ... variableTags) {
            this.variableTags(Arrays.asList(variableTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableTags(Consumer<Tag.Builder> ... variableTags) {
            this.variableTags(Stream.of(variableTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreateRule.Builder getCreateRule() {
            return this.createRule != null ? this.createRule.toBuilder() : null;
        }

        public final void setCreateRule(CreateRule.BuilderImpl createRule) {
            this.createRule = createRule != null ? createRule.build() : null;
        }

        @Override
        public final Builder createRule(CreateRule createRule) {
            this.createRule = createRule;
            return this;
        }

        public final RetainRule.Builder getRetainRule() {
            return this.retainRule != null ? this.retainRule.toBuilder() : null;
        }

        public final void setRetainRule(RetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        public final Builder retainRule(RetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public final FastRestoreRule.Builder getFastRestoreRule() {
            return this.fastRestoreRule != null ? this.fastRestoreRule.toBuilder() : null;
        }

        public final void setFastRestoreRule(FastRestoreRule.BuilderImpl fastRestoreRule) {
            this.fastRestoreRule = fastRestoreRule != null ? fastRestoreRule.build() : null;
        }

        @Override
        public final Builder fastRestoreRule(FastRestoreRule fastRestoreRule) {
            this.fastRestoreRule = fastRestoreRule;
            return this;
        }

        public final List<CrossRegionCopyRule.Builder> getCrossRegionCopyRules() {
            List<CrossRegionCopyRule.Builder> result = CrossRegionCopyRulesCopier.copyToBuilder(this.crossRegionCopyRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionCopyRules(Collection<CrossRegionCopyRule.BuilderImpl> crossRegionCopyRules) {
            this.crossRegionCopyRules = CrossRegionCopyRulesCopier.copyFromBuilder(crossRegionCopyRules);
        }

        @Override
        public final Builder crossRegionCopyRules(Collection<CrossRegionCopyRule> crossRegionCopyRules) {
            this.crossRegionCopyRules = CrossRegionCopyRulesCopier.copy(crossRegionCopyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyRules(CrossRegionCopyRule ... crossRegionCopyRules) {
            this.crossRegionCopyRules(Arrays.asList(crossRegionCopyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyRules(Consumer<CrossRegionCopyRule.Builder> ... crossRegionCopyRules) {
            this.crossRegionCopyRules(Stream.of(crossRegionCopyRules).map(c -> (CrossRegionCopyRule)((CrossRegionCopyRule.Builder)CrossRegionCopyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ShareRule.Builder> getShareRules() {
            List<ShareRule.Builder> result = ShareRulesCopier.copyToBuilder(this.shareRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareRules(Collection<ShareRule.BuilderImpl> shareRules) {
            this.shareRules = ShareRulesCopier.copyFromBuilder(shareRules);
        }

        @Override
        public final Builder shareRules(Collection<ShareRule> shareRules) {
            this.shareRules = ShareRulesCopier.copy(shareRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRules(ShareRule ... shareRules) {
            this.shareRules(Arrays.asList(shareRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRules(Consumer<ShareRule.Builder> ... shareRules) {
            this.shareRules(Stream.of(shareRules).map(c -> (ShareRule)((ShareRule.Builder)ShareRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeprecateRule.Builder getDeprecateRule() {
            return this.deprecateRule != null ? this.deprecateRule.toBuilder() : null;
        }

        public final void setDeprecateRule(DeprecateRule.BuilderImpl deprecateRule) {
            this.deprecateRule = deprecateRule != null ? deprecateRule.build() : null;
        }

        @Override
        public final Builder deprecateRule(DeprecateRule deprecateRule) {
            this.deprecateRule = deprecateRule;
            return this;
        }

        public final ArchiveRule.Builder getArchiveRule() {
            return this.archiveRule != null ? this.archiveRule.toBuilder() : null;
        }

        public final void setArchiveRule(ArchiveRule.BuilderImpl archiveRule) {
            this.archiveRule = archiveRule != null ? archiveRule.build() : null;
        }

        @Override
        public final Builder archiveRule(ArchiveRule archiveRule) {
            this.archiveRule = archiveRule;
            return this;
        }

        public Schedule build() {
            return new Schedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schedule> {
        public Builder name(String var1);

        public Builder copyTags(Boolean var1);

        public Builder tagsToAdd(Collection<Tag> var1);

        public Builder tagsToAdd(Tag ... var1);

        public Builder tagsToAdd(Consumer<Tag.Builder> ... var1);

        public Builder variableTags(Collection<Tag> var1);

        public Builder variableTags(Tag ... var1);

        public Builder variableTags(Consumer<Tag.Builder> ... var1);

        public Builder createRule(CreateRule var1);

        default public Builder createRule(Consumer<CreateRule.Builder> createRule) {
            return this.createRule((CreateRule)((CreateRule.Builder)CreateRule.builder().applyMutation(createRule)).build());
        }

        public Builder retainRule(RetainRule var1);

        default public Builder retainRule(Consumer<RetainRule.Builder> retainRule) {
            return this.retainRule((RetainRule)((RetainRule.Builder)RetainRule.builder().applyMutation(retainRule)).build());
        }

        public Builder fastRestoreRule(FastRestoreRule var1);

        default public Builder fastRestoreRule(Consumer<FastRestoreRule.Builder> fastRestoreRule) {
            return this.fastRestoreRule((FastRestoreRule)((FastRestoreRule.Builder)FastRestoreRule.builder().applyMutation(fastRestoreRule)).build());
        }

        public Builder crossRegionCopyRules(Collection<CrossRegionCopyRule> var1);

        public Builder crossRegionCopyRules(CrossRegionCopyRule ... var1);

        public Builder crossRegionCopyRules(Consumer<CrossRegionCopyRule.Builder> ... var1);

        public Builder shareRules(Collection<ShareRule> var1);

        public Builder shareRules(ShareRule ... var1);

        public Builder shareRules(Consumer<ShareRule.Builder> ... var1);

        public Builder deprecateRule(DeprecateRule var1);

        default public Builder deprecateRule(Consumer<DeprecateRule.Builder> deprecateRule) {
            return this.deprecateRule((DeprecateRule)((DeprecateRule.Builder)DeprecateRule.builder().applyMutation(deprecateRule)).build());
        }

        public Builder archiveRule(ArchiveRule var1);

        default public Builder archiveRule(Consumer<ArchiveRule.Builder> archiveRule) {
            return this.archiveRule((ArchiveRule)((ArchiveRule.Builder)ArchiveRule.builder().applyMutation(archiveRule)).build());
        }
    }
}

