/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyTargetListCopier;
import software.amazon.awssdk.services.dlm.model.DlmRequest;
import software.amazon.awssdk.services.dlm.model.Exclusions;
import software.amazon.awssdk.services.dlm.model.PolicyDetails;
import software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLifecyclePolicyRequest
extends DlmRequest
implements ToCopyableBuilder<Builder, UpdateLifecyclePolicyRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::policyId)).setter(UpdateLifecyclePolicyRequest.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyId").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::executionRoleArn)).setter(UpdateLifecyclePolicyRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::stateAsString)).setter(UpdateLifecyclePolicyRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::description)).setter(UpdateLifecyclePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyDetails").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::policyDetails)).setter(UpdateLifecyclePolicyRequest.setter(Builder::policyDetails)).constructor(PolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()}).build();
    private static final SdkField<Integer> CREATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CreateInterval").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::createInterval)).setter(UpdateLifecyclePolicyRequest.setter(Builder::createInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateInterval").build()}).build();
    private static final SdkField<Integer> RETAIN_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetainInterval").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::retainInterval)).setter(UpdateLifecyclePolicyRequest.setter(Builder::retainInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainInterval").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::copyTags)).setter(UpdateLifecyclePolicyRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<Boolean> EXTEND_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExtendDeletion").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::extendDeletion)).setter(UpdateLifecyclePolicyRequest.setter(Builder::extendDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendDeletion").build()}).build();
    private static final SdkField<List<CrossRegionCopyTarget>> CROSS_REGION_COPY_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossRegionCopyTargets").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::crossRegionCopyTargets)).setter(UpdateLifecyclePolicyRequest.setter(Builder::crossRegionCopyTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopyTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossRegionCopyTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Exclusions> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclusions").getter(UpdateLifecyclePolicyRequest.getter(UpdateLifecyclePolicyRequest::exclusions)).setter(UpdateLifecyclePolicyRequest.setter(Builder::exclusions)).constructor(Exclusions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, EXECUTION_ROLE_ARN_FIELD, STATE_FIELD, DESCRIPTION_FIELD, POLICY_DETAILS_FIELD, CREATE_INTERVAL_FIELD, RETAIN_INTERVAL_FIELD, COPY_TAGS_FIELD, EXTEND_DELETION_FIELD, CROSS_REGION_COPY_TARGETS_FIELD, EXCLUSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLifecyclePolicyRequest.memberNameToFieldInitializer();
    private final String policyId;
    private final String executionRoleArn;
    private final String state;
    private final String description;
    private final PolicyDetails policyDetails;
    private final Integer createInterval;
    private final Integer retainInterval;
    private final Boolean copyTags;
    private final Boolean extendDeletion;
    private final List<CrossRegionCopyTarget> crossRegionCopyTargets;
    private final Exclusions exclusions;

    private UpdateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.executionRoleArn = builder.executionRoleArn;
        this.state = builder.state;
        this.description = builder.description;
        this.policyDetails = builder.policyDetails;
        this.createInterval = builder.createInterval;
        this.retainInterval = builder.retainInterval;
        this.copyTags = builder.copyTags;
        this.extendDeletion = builder.extendDeletion;
        this.crossRegionCopyTargets = builder.crossRegionCopyTargets;
        this.exclusions = builder.exclusions;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final SettablePolicyStateValues state() {
        return SettablePolicyStateValues.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String description() {
        return this.description;
    }

    public final PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public final Integer createInterval() {
        return this.createInterval;
    }

    public final Integer retainInterval() {
        return this.retainInterval;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final Boolean extendDeletion() {
        return this.extendDeletion;
    }

    public final boolean hasCrossRegionCopyTargets() {
        return this.crossRegionCopyTargets != null && !(this.crossRegionCopyTargets instanceof SdkAutoConstructList);
    }

    public final List<CrossRegionCopyTarget> crossRegionCopyTargets() {
        return this.crossRegionCopyTargets;
    }

    public final Exclusions exclusions() {
        return this.exclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.createInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionCopyTargets() ? this.crossRegionCopyTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLifecyclePolicyRequest)) {
            return false;
        }
        UpdateLifecyclePolicyRequest other = (UpdateLifecyclePolicyRequest)((Object)obj);
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.policyDetails(), other.policyDetails()) && Objects.equals(this.createInterval(), other.createInterval()) && Objects.equals(this.retainInterval(), other.retainInterval()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.extendDeletion(), other.extendDeletion()) && this.hasCrossRegionCopyTargets() == other.hasCrossRegionCopyTargets() && Objects.equals(this.crossRegionCopyTargets(), other.crossRegionCopyTargets()) && Objects.equals(this.exclusions(), other.exclusions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLifecyclePolicyRequest").add("PolicyId", (Object)this.policyId()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("PolicyDetails", (Object)this.policyDetails()).add("CreateInterval", (Object)this.createInterval()).add("RetainInterval", (Object)this.retainInterval()).add("CopyTags", (Object)this.copyTags()).add("ExtendDeletion", (Object)this.extendDeletion()).add("CrossRegionCopyTargets", this.hasCrossRegionCopyTargets() ? this.crossRegionCopyTargets() : null).add("Exclusions", (Object)this.exclusions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "CreateInterval": {
                return Optional.ofNullable(clazz.cast(this.createInterval()));
            }
            case "RetainInterval": {
                return Optional.ofNullable(clazz.cast(this.retainInterval()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "ExtendDeletion": {
                return Optional.ofNullable(clazz.cast(this.extendDeletion()));
            }
            case "CrossRegionCopyTargets": {
                return Optional.ofNullable(clazz.cast(this.crossRegionCopyTargets()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyId", POLICY_ID_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PolicyDetails", POLICY_DETAILS_FIELD);
        map.put("CreateInterval", CREATE_INTERVAL_FIELD);
        map.put("RetainInterval", RETAIN_INTERVAL_FIELD);
        map.put("CopyTags", COPY_TAGS_FIELD);
        map.put("ExtendDeletion", EXTEND_DELETION_FIELD);
        map.put("CrossRegionCopyTargets", CROSS_REGION_COPY_TARGETS_FIELD);
        map.put("Exclusions", EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((UpdateLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmRequest.BuilderImpl
    implements Builder {
        private String policyId;
        private String executionRoleArn;
        private String state;
        private String description;
        private PolicyDetails policyDetails;
        private Integer createInterval;
        private Integer retainInterval;
        private Boolean copyTags;
        private Boolean extendDeletion;
        private List<CrossRegionCopyTarget> crossRegionCopyTargets = DefaultSdkAutoConstructList.getInstance();
        private Exclusions exclusions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLifecyclePolicyRequest model) {
            super(model);
            this.policyId(model.policyId);
            this.executionRoleArn(model.executionRoleArn);
            this.state(model.state);
            this.description(model.description);
            this.policyDetails(model.policyDetails);
            this.createInterval(model.createInterval);
            this.retainInterval(model.retainInterval);
            this.copyTags(model.copyTags);
            this.extendDeletion(model.extendDeletion);
            this.crossRegionCopyTargets(model.crossRegionCopyTargets);
            this.exclusions(model.exclusions);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return this.policyDetails != null ? this.policyDetails.toBuilder() : null;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final Integer getCreateInterval() {
            return this.createInterval;
        }

        public final void setCreateInterval(Integer createInterval) {
            this.createInterval = createInterval;
        }

        @Override
        public final Builder createInterval(Integer createInterval) {
            this.createInterval = createInterval;
            return this;
        }

        public final Integer getRetainInterval() {
            return this.retainInterval;
        }

        public final void setRetainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
        }

        @Override
        public final Builder retainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final Boolean getExtendDeletion() {
            return this.extendDeletion;
        }

        public final void setExtendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
        }

        @Override
        public final Builder extendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
            return this;
        }

        public final List<CrossRegionCopyTarget.Builder> getCrossRegionCopyTargets() {
            List<CrossRegionCopyTarget.Builder> result = CrossRegionCopyTargetListCopier.copyToBuilder(this.crossRegionCopyTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionCopyTargets(Collection<CrossRegionCopyTarget.BuilderImpl> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copyFromBuilder(crossRegionCopyTargets);
        }

        @Override
        public final Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copy(crossRegionCopyTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(CrossRegionCopyTarget ... crossRegionCopyTargets) {
            this.crossRegionCopyTargets(Arrays.asList(crossRegionCopyTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder> ... crossRegionCopyTargets) {
            this.crossRegionCopyTargets(Stream.of(crossRegionCopyTargets).map(c -> (CrossRegionCopyTarget)((CrossRegionCopyTarget.Builder)CrossRegionCopyTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Exclusions.Builder getExclusions() {
            return this.exclusions != null ? this.exclusions.toBuilder() : null;
        }

        public final void setExclusions(Exclusions.BuilderImpl exclusions) {
            this.exclusions = exclusions != null ? exclusions.build() : null;
        }

        @Override
        public final Builder exclusions(Exclusions exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLifecyclePolicyRequest build() {
            return new UpdateLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DlmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLifecyclePolicyRequest> {
        public Builder policyId(String var1);

        public Builder executionRoleArn(String var1);

        public Builder state(String var1);

        public Builder state(SettablePolicyStateValues var1);

        public Builder description(String var1);

        public Builder policyDetails(PolicyDetails var1);

        default public Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return this.policyDetails((PolicyDetails)((PolicyDetails.Builder)PolicyDetails.builder().applyMutation(policyDetails)).build());
        }

        public Builder createInterval(Integer var1);

        public Builder retainInterval(Integer var1);

        public Builder copyTags(Boolean var1);

        public Builder extendDeletion(Boolean var1);

        public Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> var1);

        public Builder crossRegionCopyTargets(CrossRegionCopyTarget ... var1);

        public Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder> ... var1);

        public Builder exclusions(Exclusions var1);

        default public Builder exclusions(Consumer<Exclusions.Builder> exclusions) {
            return this.exclusions((Exclusions)((Exclusions.Builder)Exclusions.builder().applyMutation(exclusions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

