/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.ExcludeDataVolumeTagListCopier;
import software.amazon.awssdk.services.dlm.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameters> {
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeBootVolume").getter(Parameters.getter(Parameters::excludeBootVolume)).setter(Parameters.setter(Builder::excludeBootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolume").build()}).build();
    private static final SdkField<Boolean> NO_REBOOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoReboot").getter(Parameters.getter(Parameters::noReboot)).setter(Parameters.setter(Builder::noReboot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoReboot").build()}).build();
    private static final SdkField<List<Tag>> EXCLUDE_DATA_VOLUME_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeDataVolumeTags").getter(Parameters.getter(Parameters::excludeDataVolumeTags)).setter(Parameters.setter(Builder::excludeDataVolumeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeDataVolumeTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDE_BOOT_VOLUME_FIELD, NO_REBOOT_FIELD, EXCLUDE_DATA_VOLUME_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Parameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean excludeBootVolume;
    private final Boolean noReboot;
    private final List<Tag> excludeDataVolumeTags;

    private Parameters(BuilderImpl builder) {
        this.excludeBootVolume = builder.excludeBootVolume;
        this.noReboot = builder.noReboot;
        this.excludeDataVolumeTags = builder.excludeDataVolumeTags;
    }

    public final Boolean excludeBootVolume() {
        return this.excludeBootVolume;
    }

    public final Boolean noReboot() {
        return this.noReboot;
    }

    public final boolean hasExcludeDataVolumeTags() {
        return this.excludeDataVolumeTags != null && !(this.excludeDataVolumeTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> excludeDataVolumeTags() {
        return this.excludeDataVolumeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeBootVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.noReboot());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeDataVolumeTags() ? this.excludeDataVolumeTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)obj;
        return Objects.equals(this.excludeBootVolume(), other.excludeBootVolume()) && Objects.equals(this.noReboot(), other.noReboot()) && this.hasExcludeDataVolumeTags() == other.hasExcludeDataVolumeTags() && Objects.equals(this.excludeDataVolumeTags(), other.excludeDataVolumeTags());
    }

    public final String toString() {
        return ToString.builder((String)"Parameters").add("ExcludeBootVolume", (Object)this.excludeBootVolume()).add("NoReboot", (Object)this.noReboot()).add("ExcludeDataVolumeTags", this.hasExcludeDataVolumeTags() ? this.excludeDataVolumeTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcludeBootVolume": {
                return Optional.ofNullable(clazz.cast(this.excludeBootVolume()));
            }
            case "NoReboot": {
                return Optional.ofNullable(clazz.cast(this.noReboot()));
            }
            case "ExcludeDataVolumeTags": {
                return Optional.ofNullable(clazz.cast(this.excludeDataVolumeTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExcludeBootVolume", EXCLUDE_BOOT_VOLUME_FIELD);
        map.put("NoReboot", NO_REBOOT_FIELD);
        map.put("ExcludeDataVolumeTags", EXCLUDE_DATA_VOLUME_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean excludeBootVolume;
        private Boolean noReboot;
        private List<Tag> excludeDataVolumeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            this.excludeBootVolume(model.excludeBootVolume);
            this.noReboot(model.noReboot);
            this.excludeDataVolumeTags(model.excludeDataVolumeTags);
        }

        public final Boolean getExcludeBootVolume() {
            return this.excludeBootVolume;
        }

        public final void setExcludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
        }

        @Override
        public final Builder excludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
            return this;
        }

        public final Boolean getNoReboot() {
            return this.noReboot;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final List<Tag.Builder> getExcludeDataVolumeTags() {
            List<Tag.Builder> result = ExcludeDataVolumeTagListCopier.copyToBuilder(this.excludeDataVolumeTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeDataVolumeTags(Collection<Tag.BuilderImpl> excludeDataVolumeTags) {
            this.excludeDataVolumeTags = ExcludeDataVolumeTagListCopier.copyFromBuilder(excludeDataVolumeTags);
        }

        @Override
        public final Builder excludeDataVolumeTags(Collection<Tag> excludeDataVolumeTags) {
            this.excludeDataVolumeTags = ExcludeDataVolumeTagListCopier.copy(excludeDataVolumeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeDataVolumeTags(Tag ... excludeDataVolumeTags) {
            this.excludeDataVolumeTags(Arrays.asList(excludeDataVolumeTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeDataVolumeTags(Consumer<Tag.Builder> ... excludeDataVolumeTags) {
            this.excludeDataVolumeTags(Stream.of(excludeDataVolumeTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Parameters build() {
            return new Parameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameters> {
        public Builder excludeBootVolume(Boolean var1);

        public Builder noReboot(Boolean var1);

        public Builder excludeDataVolumeTags(Collection<Tag> var1);

        public Builder excludeDataVolumeTags(Tag ... var1);

        public Builder excludeDataVolumeTags(Consumer<Tag.Builder> ... var1);
    }
}

