/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.IntervalUnitValues;
import software.amazon.awssdk.services.dlm.model.LocationValues;
import software.amazon.awssdk.services.dlm.model.TimesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateRule> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateRule.getter(CreateRule::locationAsString)).setter(CreateRule.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(CreateRule.getter(CreateRule::interval)).setter(CreateRule.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntervalUnit").getter(CreateRule.getter(CreateRule::intervalUnitAsString)).setter(CreateRule.setter(Builder::intervalUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()}).build();
    private static final SdkField<List<String>> TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Times").getter(CreateRule.getter(CreateRule::times)).setter(CreateRule.setter(Builder::times)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Times").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CronExpression").getter(CreateRule.getter(CreateRule::cronExpression)).setter(CreateRule.setter(Builder::cronExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, INTERVAL_FIELD, INTERVAL_UNIT_FIELD, TIMES_FIELD, CRON_EXPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String location;
    private final Integer interval;
    private final String intervalUnit;
    private final List<String> times;
    private final String cronExpression;

    private CreateRule(BuilderImpl builder) {
        this.location = builder.location;
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
        this.times = builder.times;
        this.cronExpression = builder.cronExpression;
    }

    public final LocationValues location() {
        return LocationValues.fromValue(this.location);
    }

    public final String locationAsString() {
        return this.location;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final IntervalUnitValues intervalUnit() {
        return IntervalUnitValues.fromValue(this.intervalUnit);
    }

    public final String intervalUnitAsString() {
        return this.intervalUnit;
    }

    public final boolean hasTimes() {
        return this.times != null && !(this.times instanceof SdkAutoConstructList);
    }

    public final List<String> times() {
        return this.times;
    }

    public final String cronExpression() {
        return this.cronExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimes() ? this.times() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cronExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRule)) {
            return false;
        }
        CreateRule other = (CreateRule)obj;
        return Objects.equals(this.locationAsString(), other.locationAsString()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.intervalUnitAsString(), other.intervalUnitAsString()) && this.hasTimes() == other.hasTimes() && Objects.equals(this.times(), other.times()) && Objects.equals(this.cronExpression(), other.cronExpression());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRule").add("Location", (Object)this.locationAsString()).add("Interval", (Object)this.interval()).add("IntervalUnit", (Object)this.intervalUnitAsString()).add("Times", this.hasTimes() ? this.times() : null).add("CronExpression", (Object)this.cronExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.locationAsString()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "IntervalUnit": {
                return Optional.ofNullable(clazz.cast(this.intervalUnitAsString()));
            }
            case "Times": {
                return Optional.ofNullable(clazz.cast(this.times()));
            }
            case "CronExpression": {
                return Optional.ofNullable(clazz.cast(this.cronExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRule, T> g) {
        return obj -> g.apply((CreateRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private Integer interval;
        private String intervalUnit;
        private List<String> times = DefaultSdkAutoConstructList.getInstance();
        private String cronExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRule model) {
            this.location(model.location);
            this.interval(model.interval);
            this.intervalUnit(model.intervalUnit);
            this.times(model.times);
            this.cronExpression(model.cronExpression);
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public final Builder location(LocationValues location) {
            this.location(location == null ? null : location.toString());
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final String getIntervalUnit() {
            return this.intervalUnit;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        @Override
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        public final Builder intervalUnit(IntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit == null ? null : intervalUnit.toString());
            return this;
        }

        public final Collection<String> getTimes() {
            if (this.times instanceof SdkAutoConstructList) {
                return null;
            }
            return this.times;
        }

        public final void setTimes(Collection<String> times) {
            this.times = TimesListCopier.copy(times);
        }

        @Override
        public final Builder times(Collection<String> times) {
            this.times = TimesListCopier.copy(times);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder times(String ... times) {
            this.times(Arrays.asList(times));
            return this;
        }

        public final String getCronExpression() {
            return this.cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public CreateRule build() {
            return new CreateRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateRule> {
        public Builder location(String var1);

        public Builder location(LocationValues var1);

        public Builder interval(Integer var1);

        public Builder intervalUnit(String var1);

        public Builder intervalUnit(IntervalUnitValues var1);

        public Builder times(Collection<String> var1);

        public Builder times(String ... var1);

        public Builder cronExpression(String var1);
    }
}

