/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.EventTypeValues;
import software.amazon.awssdk.services.dlm.model.SnapshotOwnerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventParameters> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(EventParameters.getter(EventParameters::eventTypeAsString)).setter(EventParameters.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotOwner").getter(EventParameters.getter(EventParameters::snapshotOwner)).setter(EventParameters.setter(Builder::snapshotOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOwner").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DescriptionRegex").getter(EventParameters.getter(EventParameters::descriptionRegex)).setter(EventParameters.setter(Builder::descriptionRegex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescriptionRegex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, SNAPSHOT_OWNER_FIELD, DESCRIPTION_REGEX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final List<String> snapshotOwner;
    private final String descriptionRegex;

    private EventParameters(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.snapshotOwner = builder.snapshotOwner;
        this.descriptionRegex = builder.descriptionRegex;
    }

    public final EventTypeValues eventType() {
        return EventTypeValues.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final boolean hasSnapshotOwner() {
        return this.snapshotOwner != null && !(this.snapshotOwner instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotOwner() {
        return this.snapshotOwner;
    }

    public final String descriptionRegex() {
        return this.descriptionRegex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotOwner() ? this.snapshotOwner() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptionRegex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventParameters)) {
            return false;
        }
        EventParameters other = (EventParameters)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && this.hasSnapshotOwner() == other.hasSnapshotOwner() && Objects.equals(this.snapshotOwner(), other.snapshotOwner()) && Objects.equals(this.descriptionRegex(), other.descriptionRegex());
    }

    public final String toString() {
        return ToString.builder((String)"EventParameters").add("EventType", (Object)this.eventTypeAsString()).add("SnapshotOwner", this.hasSnapshotOwner() ? this.snapshotOwner() : null).add("DescriptionRegex", (Object)this.descriptionRegex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "SnapshotOwner": {
                return Optional.ofNullable(clazz.cast(this.snapshotOwner()));
            }
            case "DescriptionRegex": {
                return Optional.ofNullable(clazz.cast(this.descriptionRegex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventParameters, T> g) {
        return obj -> g.apply((EventParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private List<String> snapshotOwner = DefaultSdkAutoConstructList.getInstance();
        private String descriptionRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(EventParameters model) {
            this.eventType(model.eventType);
            this.snapshotOwner(model.snapshotOwner);
            this.descriptionRegex(model.descriptionRegex);
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventTypeValues eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Collection<String> getSnapshotOwner() {
            if (this.snapshotOwner instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotOwner;
        }

        @Override
        public final Builder snapshotOwner(Collection<String> snapshotOwner) {
            this.snapshotOwner = SnapshotOwnerListCopier.copy(snapshotOwner);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotOwner(String ... snapshotOwner) {
            this.snapshotOwner(Arrays.asList(snapshotOwner));
            return this;
        }

        public final void setSnapshotOwner(Collection<String> snapshotOwner) {
            this.snapshotOwner = SnapshotOwnerListCopier.copy(snapshotOwner);
        }

        public final String getDescriptionRegex() {
            return this.descriptionRegex;
        }

        @Override
        public final Builder descriptionRegex(String descriptionRegex) {
            this.descriptionRegex = descriptionRegex;
            return this;
        }

        public final void setDescriptionRegex(String descriptionRegex) {
            this.descriptionRegex = descriptionRegex;
        }

        public EventParameters build() {
            return new EventParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventParameters> {
        public Builder eventType(String var1);

        public Builder eventType(EventTypeValues var1);

        public Builder snapshotOwner(Collection<String> var1);

        public Builder snapshotOwner(String ... var1);

        public Builder descriptionRegex(String var1);
    }
}

