/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directoryservicedata.DirectoryServiceDataClient;
import software.amazon.awssdk.services.directoryservicedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.directoryservicedata.model.GroupSummary;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse;

public class ListGroupsIterable
implements SdkIterable<ListGroupsResponse> {
    private final DirectoryServiceDataClient client;
    private final ListGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsIterable(DirectoryServiceDataClient client, ListGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public Iterator<ListGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupSummary> groups() {
        Function<ListGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupsResponseFetcher
    implements SyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupsResponse nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsIterable.this.client.listGroups(ListGroupsIterable.this.firstRequest);
            }
            return ListGroupsIterable.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

