/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directoryservicedata.model.GroupScope;
import software.amazon.awssdk.services.directoryservicedata.model.GroupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupSummary> {
    private static final SdkField<String> GROUP_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupScope").getter(GroupSummary.getter(GroupSummary::groupScopeAsString)).setter(GroupSummary.setter(Builder::groupScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScope").build()}).build();
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupType").getter(GroupSummary.getter(GroupSummary::groupTypeAsString)).setter(GroupSummary.setter(Builder::groupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupType").build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(GroupSummary.getter(GroupSummary::samAccountName)).setter(GroupSummary.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SID").getter(GroupSummary.getter(GroupSummary::sid)).setter(GroupSummary.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_SCOPE_FIELD, GROUP_TYPE_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupScope;
    private final String groupType;
    private final String samAccountName;
    private final String sid;

    private GroupSummary(BuilderImpl builder) {
        this.groupScope = builder.groupScope;
        this.groupType = builder.groupType;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    public final GroupScope groupScope() {
        return GroupScope.fromValue(this.groupScope);
    }

    public final String groupScopeAsString() {
        return this.groupScope;
    }

    public final GroupType groupType() {
        return GroupType.fromValue(this.groupType);
    }

    public final String groupTypeAsString() {
        return this.groupType;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    public final String sid() {
        return this.sid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupSummary)) {
            return false;
        }
        GroupSummary other = (GroupSummary)obj;
        return Objects.equals(this.groupScopeAsString(), other.groupScopeAsString()) && Objects.equals(this.groupTypeAsString(), other.groupTypeAsString()) && Objects.equals(this.samAccountName(), other.samAccountName()) && Objects.equals(this.sid(), other.sid());
    }

    public final String toString() {
        return ToString.builder((String)"GroupSummary").add("GroupScope", (Object)this.groupScopeAsString()).add("GroupType", (Object)this.groupTypeAsString()).add("SAMAccountName", (Object)this.samAccountName()).add("SID", (Object)this.sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupScope": {
                return Optional.ofNullable(clazz.cast(this.groupScopeAsString()));
            }
            case "GroupType": {
                return Optional.ofNullable(clazz.cast(this.groupTypeAsString()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
            case "SID": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GroupScope", GROUP_SCOPE_FIELD);
        map.put("GroupType", GROUP_TYPE_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("SID", SID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupSummary, T> g) {
        return obj -> g.apply((GroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupScope;
        private String groupType;
        private String samAccountName;
        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupSummary model) {
            this.groupScope(model.groupScope);
            this.groupType(model.groupType);
            this.samAccountName(model.samAccountName);
            this.sid(model.sid);
        }

        public final String getGroupScope() {
            return this.groupScope;
        }

        public final void setGroupScope(String groupScope) {
            this.groupScope = groupScope;
        }

        @Override
        public final Builder groupScope(String groupScope) {
            this.groupScope = groupScope;
            return this;
        }

        @Override
        public final Builder groupScope(GroupScope groupScope) {
            this.groupScope(groupScope == null ? null : groupScope.toString());
            return this;
        }

        public final String getGroupType() {
            return this.groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public GroupSummary build() {
            return new GroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupSummary> {
        public Builder groupScope(String var1);

        public Builder groupScope(GroupScope var1);

        public Builder groupType(String var1);

        public Builder groupType(GroupType var1);

        public Builder samAccountName(String var1);

        public Builder sid(String var1);
    }
}

