/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DirectorySize {
    SMALL("Small"),
    LARGE("Large"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DirectorySize> VALUE_MAP;
    private final String value;

    private DirectorySize(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectorySize fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectorySize> knownValues() {
        EnumSet<DirectorySize> knownValues = EnumSet.allOf(DirectorySize.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DirectorySize.class, DirectorySize::toString);
    }
}

