/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.SettingEntriesCopier;
import software.amazon.awssdk.services.directory.model.SettingEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSettingsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeSettingsResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeSettingsResponse.getter(DescribeSettingsResponse::directoryId)).setter(DescribeSettingsResponse.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<SettingEntry>> SETTING_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SettingEntries").getter(DescribeSettingsResponse.getter(DescribeSettingsResponse::settingEntries)).setter(DescribeSettingsResponse.setter(Builder::settingEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SettingEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSettingsResponse.getter(DescribeSettingsResponse::nextToken)).setter(DescribeSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SETTING_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("SettingEntries", SETTING_ENTRIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String directoryId;
    private final List<SettingEntry> settingEntries;
    private final String nextToken;

    private DescribeSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.settingEntries = builder.settingEntries;
        this.nextToken = builder.nextToken;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasSettingEntries() {
        return this.settingEntries != null && !(this.settingEntries instanceof SdkAutoConstructList);
    }

    public final List<SettingEntry> settingEntries() {
        return this.settingEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettingEntries() ? this.settingEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSettingsResponse)) {
            return false;
        }
        DescribeSettingsResponse other = (DescribeSettingsResponse)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasSettingEntries() == other.hasSettingEntries() && Objects.equals(this.settingEntries(), other.settingEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSettingsResponse").add("DirectoryId", (Object)this.directoryId()).add("SettingEntries", this.hasSettingEntries() ? this.settingEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "SettingEntries": {
                return Optional.ofNullable(clazz.cast(this.settingEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<SettingEntry> settingEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSettingsResponse model) {
            super(model);
            this.directoryId(model.directoryId);
            this.settingEntries(model.settingEntries);
            this.nextToken(model.nextToken);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<SettingEntry.Builder> getSettingEntries() {
            List<SettingEntry.Builder> result = SettingEntriesCopier.copyToBuilder(this.settingEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettingEntries(Collection<SettingEntry.BuilderImpl> settingEntries) {
            this.settingEntries = SettingEntriesCopier.copyFromBuilder(settingEntries);
        }

        @Override
        @Transient
        public final Builder settingEntries(Collection<SettingEntry> settingEntries) {
            this.settingEntries = SettingEntriesCopier.copy(settingEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settingEntries(SettingEntry ... settingEntries) {
            this.settingEntries(Arrays.asList(settingEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settingEntries(Consumer<SettingEntry.Builder> ... settingEntries) {
            this.settingEntries(Stream.of(settingEntries).map(c -> (SettingEntry)((SettingEntry.Builder)SettingEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSettingsResponse build() {
            return new DescribeSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSettingsResponse> {
        public Builder directoryId(String var1);

        public Builder settingEntries(Collection<SettingEntry> var1);

        public Builder settingEntries(SettingEntry ... var1);

        public Builder settingEntries(Consumer<SettingEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

