/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.RegionDescription;

public class DescribeRegionsIterable
implements SdkIterable<DescribeRegionsResponse> {
    private final DirectoryClient client;
    private final DescribeRegionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegionsIterable(DirectoryClient client, DescribeRegionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRegionsResponseFetcher();
    }

    public Iterator<DescribeRegionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegionDescription> regionsDescription() {
        Function<DescribeRegionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.regionsDescription() != null) {
                return response.regionsDescription().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegionsResponseFetcher
    implements SyncPageFetcher<DescribeRegionsResponse> {
        private DescribeRegionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegionsResponse nextPage(DescribeRegionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegionsIterable.this.client.describeRegions(DescribeRegionsIterable.this.firstRequest);
            }
            return DescribeRegionsIterable.this.client.describeRegions((DescribeRegionsRequest)((Object)DescribeRegionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

