/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TopicStatus {
    REGISTERED("Registered"),
    TOPIC_NOT_FOUND("Topic not found"),
    FAILED("Failed"),
    DELETED("Deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TopicStatus> VALUE_MAP;
    private final String value;

    private TopicStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TopicStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TopicStatus> knownValues() {
        EnumSet<TopicStatus> knownValues = EnumSet.allOf(TopicStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TopicStatus.class, TopicStatus::toString);
    }
}

