/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.LogSubscription;
import software.amazon.awssdk.services.directory.model.LogSubscriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogSubscriptionsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, ListLogSubscriptionsResponse> {
    private static final SdkField<List<LogSubscription>> LOG_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogSubscriptions").getter(ListLogSubscriptionsResponse.getter(ListLogSubscriptionsResponse::logSubscriptions)).setter(ListLogSubscriptionsResponse.setter(Builder::logSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLogSubscriptionsResponse.getter(ListLogSubscriptionsResponse::nextToken)).setter(ListLogSubscriptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LogSubscription> logSubscriptions;
    private final String nextToken;

    private ListLogSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.logSubscriptions = builder.logSubscriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLogSubscriptions() {
        return this.logSubscriptions != null && !(this.logSubscriptions instanceof SdkAutoConstructList);
    }

    public final List<LogSubscription> logSubscriptions() {
        return this.logSubscriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogSubscriptions() ? this.logSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSubscriptionsResponse)) {
            return false;
        }
        ListLogSubscriptionsResponse other = (ListLogSubscriptionsResponse)((Object)obj);
        return this.hasLogSubscriptions() == other.hasLogSubscriptions() && Objects.equals(this.logSubscriptions(), other.logSubscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogSubscriptionsResponse").add("LogSubscriptions", this.hasLogSubscriptions() ? this.logSubscriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListLogSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<LogSubscription> logSubscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogSubscriptionsResponse model) {
            super(model);
            this.logSubscriptions(model.logSubscriptions);
            this.nextToken(model.nextToken);
        }

        public final List<LogSubscription.Builder> getLogSubscriptions() {
            List<LogSubscription.Builder> result = LogSubscriptionsCopier.copyToBuilder(this.logSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogSubscriptions(Collection<LogSubscription.BuilderImpl> logSubscriptions) {
            this.logSubscriptions = LogSubscriptionsCopier.copyFromBuilder(logSubscriptions);
        }

        @Override
        public final Builder logSubscriptions(Collection<LogSubscription> logSubscriptions) {
            this.logSubscriptions = LogSubscriptionsCopier.copy(logSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSubscriptions(LogSubscription ... logSubscriptions) {
            this.logSubscriptions(Arrays.asList(logSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSubscriptions(Consumer<LogSubscription.Builder> ... logSubscriptions) {
            this.logSubscriptions(Stream.of(logSubscriptions).map(c -> (LogSubscription)((LogSubscription.Builder)LogSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLogSubscriptionsResponse build() {
            return new ListLogSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogSubscriptionsResponse> {
        public Builder logSubscriptions(Collection<LogSubscription> var1);

        public Builder logSubscriptions(LogSubscription ... var1);

        public Builder logSubscriptions(Consumer<LogSubscription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

