/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RadiusAuthenticationProtocol {
    PAP("PAP"),
    CHAP("CHAP"),
    MS_CHAP_V1("MS-CHAPv1"),
    MS_CHAP_V2("MS-CHAPv2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RadiusAuthenticationProtocol> VALUE_MAP;
    private final String value;

    private RadiusAuthenticationProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RadiusAuthenticationProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RadiusAuthenticationProtocol> knownValues() {
        EnumSet<RadiusAuthenticationProtocol> knownValues = EnumSet.allOf(RadiusAuthenticationProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RadiusAuthenticationProtocol.class, RadiusAuthenticationProtocol::toString);
    }
}

