/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrustResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, UpdateTrustResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateTrustResponse.getter(UpdateTrustResponse::requestId)).setter(UpdateTrustResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustId").getter(UpdateTrustResponse.getter(UpdateTrustResponse::trustId)).setter(UpdateTrustResponse.setter(Builder::trustId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, TRUST_ID_FIELD));
    private final String requestId;
    private final String trustId;

    private UpdateTrustResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.trustId = builder.trustId;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String trustId() {
        return this.trustId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustResponse)) {
            return false;
        }
        UpdateTrustResponse other = (UpdateTrustResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.trustId(), other.trustId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrustResponse").add("RequestId", (Object)this.requestId()).add("TrustId", (Object)this.trustId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "TrustId": {
                return Optional.ofNullable(clazz.cast(this.trustId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustResponse, T> g) {
        return obj -> g.apply((UpdateTrustResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private String requestId;
        private String trustId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustResponse model) {
            super(model);
            this.requestId(model.requestId);
            this.trustId(model.trustId);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getTrustId() {
            return this.trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        public UpdateTrustResponse build() {
            return new UpdateTrustResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrustResponse> {
        public Builder requestId(String var1);

        public Builder trustId(String var1);
    }
}

