/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.RadiusAuthenticationProtocol;
import software.amazon.awssdk.services.directory.model.ServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RadiusSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RadiusSettings> {
    private static final SdkField<List<String>> RADIUS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RadiusServers").getter(RadiusSettings.getter(RadiusSettings::radiusServers)).setter(RadiusSettings.setter(Builder::radiusServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RADIUS_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RadiusPort").getter(RadiusSettings.getter(RadiusSettings::radiusPort)).setter(RadiusSettings.setter(Builder::radiusPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusPort").build()}).build();
    private static final SdkField<Integer> RADIUS_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RadiusTimeout").getter(RadiusSettings.getter(RadiusSettings::radiusTimeout)).setter(RadiusSettings.setter(Builder::radiusTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusTimeout").build()}).build();
    private static final SdkField<Integer> RADIUS_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RadiusRetries").getter(RadiusSettings.getter(RadiusSettings::radiusRetries)).setter(RadiusSettings.setter(Builder::radiusRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusRetries").build()}).build();
    private static final SdkField<String> SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedSecret").getter(RadiusSettings.getter(RadiusSettings::sharedSecret)).setter(RadiusSettings.setter(Builder::sharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSecret").build()}).build();
    private static final SdkField<String> AUTHENTICATION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationProtocol").getter(RadiusSettings.getter(RadiusSettings::authenticationProtocolAsString)).setter(RadiusSettings.setter(Builder::authenticationProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProtocol").build()}).build();
    private static final SdkField<String> DISPLAY_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayLabel").getter(RadiusSettings.getter(RadiusSettings::displayLabel)).setter(RadiusSettings.setter(Builder::displayLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayLabel").build()}).build();
    private static final SdkField<Boolean> USE_SAME_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseSameUsername").getter(RadiusSettings.getter(RadiusSettings::useSameUsername)).setter(RadiusSettings.setter(Builder::useSameUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseSameUsername").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RADIUS_SERVERS_FIELD, RADIUS_PORT_FIELD, RADIUS_TIMEOUT_FIELD, RADIUS_RETRIES_FIELD, SHARED_SECRET_FIELD, AUTHENTICATION_PROTOCOL_FIELD, DISPLAY_LABEL_FIELD, USE_SAME_USERNAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> radiusServers;
    private final Integer radiusPort;
    private final Integer radiusTimeout;
    private final Integer radiusRetries;
    private final String sharedSecret;
    private final String authenticationProtocol;
    private final String displayLabel;
    private final Boolean useSameUsername;

    private RadiusSettings(BuilderImpl builder) {
        this.radiusServers = builder.radiusServers;
        this.radiusPort = builder.radiusPort;
        this.radiusTimeout = builder.radiusTimeout;
        this.radiusRetries = builder.radiusRetries;
        this.sharedSecret = builder.sharedSecret;
        this.authenticationProtocol = builder.authenticationProtocol;
        this.displayLabel = builder.displayLabel;
        this.useSameUsername = builder.useSameUsername;
    }

    public final boolean hasRadiusServers() {
        return this.radiusServers != null && !(this.radiusServers instanceof SdkAutoConstructList);
    }

    public final List<String> radiusServers() {
        return this.radiusServers;
    }

    public final Integer radiusPort() {
        return this.radiusPort;
    }

    public final Integer radiusTimeout() {
        return this.radiusTimeout;
    }

    public final Integer radiusRetries() {
        return this.radiusRetries;
    }

    public final String sharedSecret() {
        return this.sharedSecret;
    }

    public final RadiusAuthenticationProtocol authenticationProtocol() {
        return RadiusAuthenticationProtocol.fromValue(this.authenticationProtocol);
    }

    public final String authenticationProtocolAsString() {
        return this.authenticationProtocol;
    }

    public final String displayLabel() {
        return this.displayLabel;
    }

    public final Boolean useSameUsername() {
        return this.useSameUsername;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRadiusServers() ? this.radiusServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.useSameUsername());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadiusSettings)) {
            return false;
        }
        RadiusSettings other = (RadiusSettings)obj;
        return this.hasRadiusServers() == other.hasRadiusServers() && Objects.equals(this.radiusServers(), other.radiusServers()) && Objects.equals(this.radiusPort(), other.radiusPort()) && Objects.equals(this.radiusTimeout(), other.radiusTimeout()) && Objects.equals(this.radiusRetries(), other.radiusRetries()) && Objects.equals(this.sharedSecret(), other.sharedSecret()) && Objects.equals(this.authenticationProtocolAsString(), other.authenticationProtocolAsString()) && Objects.equals(this.displayLabel(), other.displayLabel()) && Objects.equals(this.useSameUsername(), other.useSameUsername());
    }

    public final String toString() {
        return ToString.builder((String)"RadiusSettings").add("RadiusServers", this.hasRadiusServers() ? this.radiusServers() : null).add("RadiusPort", (Object)this.radiusPort()).add("RadiusTimeout", (Object)this.radiusTimeout()).add("RadiusRetries", (Object)this.radiusRetries()).add("SharedSecret", (Object)(this.sharedSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthenticationProtocol", (Object)this.authenticationProtocolAsString()).add("DisplayLabel", (Object)this.displayLabel()).add("UseSameUsername", (Object)this.useSameUsername()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RadiusServers": {
                return Optional.ofNullable(clazz.cast(this.radiusServers()));
            }
            case "RadiusPort": {
                return Optional.ofNullable(clazz.cast(this.radiusPort()));
            }
            case "RadiusTimeout": {
                return Optional.ofNullable(clazz.cast(this.radiusTimeout()));
            }
            case "RadiusRetries": {
                return Optional.ofNullable(clazz.cast(this.radiusRetries()));
            }
            case "SharedSecret": {
                return Optional.ofNullable(clazz.cast(this.sharedSecret()));
            }
            case "AuthenticationProtocol": {
                return Optional.ofNullable(clazz.cast(this.authenticationProtocolAsString()));
            }
            case "DisplayLabel": {
                return Optional.ofNullable(clazz.cast(this.displayLabel()));
            }
            case "UseSameUsername": {
                return Optional.ofNullable(clazz.cast(this.useSameUsername()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RadiusSettings, T> g) {
        return obj -> g.apply((RadiusSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> radiusServers = DefaultSdkAutoConstructList.getInstance();
        private Integer radiusPort;
        private Integer radiusTimeout;
        private Integer radiusRetries;
        private String sharedSecret;
        private String authenticationProtocol;
        private String displayLabel;
        private Boolean useSameUsername;

        private BuilderImpl() {
        }

        private BuilderImpl(RadiusSettings model) {
            this.radiusServers(model.radiusServers);
            this.radiusPort(model.radiusPort);
            this.radiusTimeout(model.radiusTimeout);
            this.radiusRetries(model.radiusRetries);
            this.sharedSecret(model.sharedSecret);
            this.authenticationProtocol(model.authenticationProtocol);
            this.displayLabel(model.displayLabel);
            this.useSameUsername(model.useSameUsername);
        }

        public final Collection<String> getRadiusServers() {
            if (this.radiusServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.radiusServers;
        }

        @Override
        public final Builder radiusServers(Collection<String> radiusServers) {
            this.radiusServers = ServersCopier.copy(radiusServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder radiusServers(String ... radiusServers) {
            this.radiusServers(Arrays.asList(radiusServers));
            return this;
        }

        public final void setRadiusServers(Collection<String> radiusServers) {
            this.radiusServers = ServersCopier.copy(radiusServers);
        }

        public final Integer getRadiusPort() {
            return this.radiusPort;
        }

        @Override
        public final Builder radiusPort(Integer radiusPort) {
            this.radiusPort = radiusPort;
            return this;
        }

        public final void setRadiusPort(Integer radiusPort) {
            this.radiusPort = radiusPort;
        }

        public final Integer getRadiusTimeout() {
            return this.radiusTimeout;
        }

        @Override
        public final Builder radiusTimeout(Integer radiusTimeout) {
            this.radiusTimeout = radiusTimeout;
            return this;
        }

        public final void setRadiusTimeout(Integer radiusTimeout) {
            this.radiusTimeout = radiusTimeout;
        }

        public final Integer getRadiusRetries() {
            return this.radiusRetries;
        }

        @Override
        public final Builder radiusRetries(Integer radiusRetries) {
            this.radiusRetries = radiusRetries;
            return this;
        }

        public final void setRadiusRetries(Integer radiusRetries) {
            this.radiusRetries = radiusRetries;
        }

        public final String getSharedSecret() {
            return this.sharedSecret;
        }

        @Override
        public final Builder sharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public final void setSharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
        }

        public final String getAuthenticationProtocol() {
            return this.authenticationProtocol;
        }

        @Override
        public final Builder authenticationProtocol(String authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
            return this;
        }

        @Override
        public final Builder authenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol) {
            this.authenticationProtocol(authenticationProtocol == null ? null : authenticationProtocol.toString());
            return this;
        }

        public final void setAuthenticationProtocol(String authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
        }

        public final String getDisplayLabel() {
            return this.displayLabel;
        }

        @Override
        public final Builder displayLabel(String displayLabel) {
            this.displayLabel = displayLabel;
            return this;
        }

        public final void setDisplayLabel(String displayLabel) {
            this.displayLabel = displayLabel;
        }

        public final Boolean getUseSameUsername() {
            return this.useSameUsername;
        }

        @Override
        public final Builder useSameUsername(Boolean useSameUsername) {
            this.useSameUsername = useSameUsername;
            return this;
        }

        public final void setUseSameUsername(Boolean useSameUsername) {
            this.useSameUsername = useSameUsername;
        }

        public RadiusSettings build() {
            return new RadiusSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RadiusSettings> {
        public Builder radiusServers(Collection<String> var1);

        public Builder radiusServers(String ... var1);

        public Builder radiusPort(Integer var1);

        public Builder radiusTimeout(Integer var1);

        public Builder radiusRetries(Integer var1);

        public Builder sharedSecret(String var1);

        public Builder authenticationProtocol(String var1);

        public Builder authenticationProtocol(RadiusAuthenticationProtocol var1);

        public Builder displayLabel(String var1);

        public Builder useSameUsername(Boolean var1);
    }
}

