/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.CertificateInfo;
import software.amazon.awssdk.services.directory.model.CertificatesInfoCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificatesResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, ListCertificatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCertificatesResponse.getter(ListCertificatesResponse::nextToken)).setter(ListCertificatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CertificateInfo>> CERTIFICATES_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificatesInfo").getter(ListCertificatesResponse.getter(ListCertificatesResponse::certificatesInfo)).setter(ListCertificatesResponse.setter(Builder::certificatesInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatesInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CERTIFICATES_INFO_FIELD));
    private final String nextToken;
    private final List<CertificateInfo> certificatesInfo;

    private ListCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.certificatesInfo = builder.certificatesInfo;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCertificatesInfo() {
        return this.certificatesInfo != null && !(this.certificatesInfo instanceof SdkAutoConstructList);
    }

    public final List<CertificateInfo> certificatesInfo() {
        return this.certificatesInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificatesInfo() ? this.certificatesInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResponse)) {
            return false;
        }
        ListCertificatesResponse other = (ListCertificatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCertificatesInfo() == other.hasCertificatesInfo() && Objects.equals(this.certificatesInfo(), other.certificatesInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ListCertificatesResponse").add("NextToken", (Object)this.nextToken()).add("CertificatesInfo", this.hasCertificatesInfo() ? this.certificatesInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CertificatesInfo": {
                return Optional.ofNullable(clazz.cast(this.certificatesInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesResponse, T> g) {
        return obj -> g.apply((ListCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CertificateInfo> certificatesInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.certificatesInfo(model.certificatesInfo);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CertificateInfo.Builder> getCertificatesInfo() {
            if (this.certificatesInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificatesInfo != null ? (Collection)this.certificatesInfo.stream().map(CertificateInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificatesInfo(Collection<CertificateInfo> certificatesInfo) {
            this.certificatesInfo = CertificatesInfoCopier.copy(certificatesInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesInfo(CertificateInfo ... certificatesInfo) {
            this.certificatesInfo(Arrays.asList(certificatesInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesInfo(Consumer<CertificateInfo.Builder> ... certificatesInfo) {
            this.certificatesInfo(Stream.of(certificatesInfo).map(c -> (CertificateInfo)((CertificateInfo.Builder)CertificateInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificatesInfo(Collection<CertificateInfo.BuilderImpl> certificatesInfo) {
            this.certificatesInfo = CertificatesInfoCopier.copyFromBuilder(certificatesInfo);
        }

        @Override
        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificatesResponse> {
        public Builder nextToken(String var1);

        public Builder certificatesInfo(Collection<CertificateInfo> var1);

        public Builder certificatesInfo(CertificateInfo ... var1);

        public Builder certificatesInfo(Consumer<CertificateInfo.Builder> ... var1);
    }
}

