/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrustResponse extends DirectoryResponse implements
        ToCopyableBuilder<UpdateTrustResponse.Builder, UpdateTrustResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateTrustResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> TRUST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustId").getter(getter(UpdateTrustResponse::trustId)).setter(setter(Builder::trustId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            TRUST_ID_FIELD));

    private final String requestId;

    private final String trustId;

    private UpdateTrustResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.trustId = builder.trustId;
    }

    /**
     * Returns the value of the RequestId property for this object.
     * 
     * @return The value of the RequestId property for this object.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Identifier of the trust relationship.
     * </p>
     * 
     * @return Identifier of the trust relationship.
     */
    public final String trustId() {
        return trustId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(trustId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustResponse)) {
            return false;
        }
        UpdateTrustResponse other = (UpdateTrustResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(trustId(), other.trustId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrustResponse").add("RequestId", requestId()).add("TrustId", trustId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "TrustId":
            return Optional.ofNullable(clazz.cast(trustId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustResponse, T> g) {
        return obj -> g.apply((UpdateTrustResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrustResponse> {
        /**
         * Sets the value of the RequestId property for this object.
         *
         * @param requestId
         *        The new value for the RequestId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Identifier of the trust relationship.
         * </p>
         * 
         * @param trustId
         *        Identifier of the trust relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustId(String trustId);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String requestId;

        private String trustId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustResponse model) {
            super(model);
            requestId(model.requestId);
            trustId(model.trustId);
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getTrustId() {
            return trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        public UpdateTrustResponse build() {
            return new UpdateTrustResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
