/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePublicVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreatePublicVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePublicVirtualInterfaceRequest.getter(CreatePublicVirtualInterfaceRequest::connectionId)).setter(CreatePublicVirtualInterfaceRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<NewPublicVirtualInterface> NEW_PUBLIC_VIRTUAL_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePublicVirtualInterfaceRequest.getter(CreatePublicVirtualInterfaceRequest::newPublicVirtualInterface)).setter(CreatePublicVirtualInterfaceRequest.setter(Builder::newPublicVirtualInterface)).constructor(NewPublicVirtualInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPublicVirtualInterface").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, NEW_PUBLIC_VIRTUAL_INTERFACE_FIELD));
    private final String connectionId;
    private final NewPublicVirtualInterface newPublicVirtualInterface;

    private CreatePublicVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.newPublicVirtualInterface = builder.newPublicVirtualInterface;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public NewPublicVirtualInterface newPublicVirtualInterface() {
        return this.newPublicVirtualInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPublicVirtualInterface());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicVirtualInterfaceRequest)) {
            return false;
        }
        CreatePublicVirtualInterfaceRequest other = (CreatePublicVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.newPublicVirtualInterface(), other.newPublicVirtualInterface());
    }

    public String toString() {
        return ToString.builder((String)"CreatePublicVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("NewPublicVirtualInterface", (Object)this.newPublicVirtualInterface()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "newPublicVirtualInterface": {
                return Optional.ofNullable(clazz.cast(this.newPublicVirtualInterface()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePublicVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((CreatePublicVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private NewPublicVirtualInterface newPublicVirtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.newPublicVirtualInterface(model.newPublicVirtualInterface);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final NewPublicVirtualInterface.Builder getNewPublicVirtualInterface() {
            return this.newPublicVirtualInterface != null ? this.newPublicVirtualInterface.toBuilder() : null;
        }

        @Override
        public final Builder newPublicVirtualInterface(NewPublicVirtualInterface newPublicVirtualInterface) {
            this.newPublicVirtualInterface = newPublicVirtualInterface;
            return this;
        }

        public final void setNewPublicVirtualInterface(NewPublicVirtualInterface.BuilderImpl newPublicVirtualInterface) {
            this.newPublicVirtualInterface = newPublicVirtualInterface != null ? newPublicVirtualInterface.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePublicVirtualInterfaceRequest build() {
            return new CreatePublicVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePublicVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder newPublicVirtualInterface(NewPublicVirtualInterface var1);

        default public Builder newPublicVirtualInterface(Consumer<NewPublicVirtualInterface.Builder> newPublicVirtualInterface) {
            return this.newPublicVirtualInterface((NewPublicVirtualInterface)((NewPublicVirtualInterface.Builder)NewPublicVirtualInterface.builder().applyMutation(newPublicVirtualInterface)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

