/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVirtualInterfaceAttributesRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, UpdateVirtualInterfaceAttributesRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVirtualInterfaceAttributesRequest.getter(UpdateVirtualInterfaceAttributesRequest::virtualInterfaceId)).setter(UpdateVirtualInterfaceAttributesRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<Integer> MTU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateVirtualInterfaceAttributesRequest.getter(UpdateVirtualInterfaceAttributesRequest::mtu)).setter(UpdateVirtualInterfaceAttributesRequest.setter(Builder::mtu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD, MTU_FIELD));
    private final String virtualInterfaceId;
    private final Integer mtu;

    private UpdateVirtualInterfaceAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.mtu = builder.mtu;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public Integer mtu() {
        return this.mtu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mtu());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualInterfaceAttributesRequest)) {
            return false;
        }
        UpdateVirtualInterfaceAttributesRequest other = (UpdateVirtualInterfaceAttributesRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.mtu(), other.mtu());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVirtualInterfaceAttributesRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("Mtu", (Object)this.mtu()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "mtu": {
                return Optional.ofNullable(clazz.cast(this.mtu()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualInterfaceAttributesRequest, T> g) {
        return obj -> g.apply((UpdateVirtualInterfaceAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private Integer mtu;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualInterfaceAttributesRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.mtu(model.mtu);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final Integer getMtu() {
            return this.mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualInterfaceAttributesRequest build() {
            return new UpdateVirtualInterfaceAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVirtualInterfaceAttributesRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder mtu(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

