/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.BGPPeer;
import software.amazon.awssdk.services.directconnect.model.BGPPeerListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVirtualInterfaceAttributesResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, UpdateVirtualInterfaceAttributesResponse> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::ownerAccount)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::virtualInterfaceId)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::location)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::connectionId)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceType").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::virtualInterfaceType)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::virtualInterfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceType").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceName").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::virtualInterfaceName)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::virtualInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlan").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::vlan)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()}).build();
    private static final SdkField<Integer> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("asn").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::asn)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()}).build();
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("amazonSideAsn").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::amazonSideAsn)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonSideAsn").build()}).build();
    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authKey").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::authKey)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::authKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()}).build();
    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amazonAddress").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::amazonAddress)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::amazonAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()}).build();
    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerAddress").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::customerAddress)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::customerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressFamily").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::addressFamilyAsString)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceState").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::virtualInterfaceStateAsString)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::virtualInterfaceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceState").build()}).build();
    private static final SdkField<String> CUSTOMER_ROUTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerRouterConfig").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::customerRouterConfig)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::customerRouterConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerRouterConfig").build()}).build();
    private static final SdkField<Integer> MTU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mtu").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::mtu)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::mtu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()}).build();
    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("jumboFrameCapable").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::jumboFrameCapable)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::jumboFrameCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayId").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::virtualGatewayId)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::directConnectGatewayId)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> ROUTE_FILTER_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routeFilterPrefixes").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::routeFilterPrefixes)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::routeFilterPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeFilterPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BGPPeer>> BGP_PEERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bgpPeers").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::bgpPeers)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::bgpPeers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BGPPeer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::region)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDeviceV2").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::awsDeviceV2)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsLogicalDeviceId").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::awsLogicalDeviceId)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::awsLogicalDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::tags)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SITE_LINK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("siteLinkEnabled").getter(UpdateVirtualInterfaceAttributesResponse.getter(UpdateVirtualInterfaceAttributesResponse::siteLinkEnabled)).setter(UpdateVirtualInterfaceAttributesResponse.setter(Builder::siteLinkEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteLinkEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD, VIRTUAL_INTERFACE_ID_FIELD, LOCATION_FIELD, CONNECTION_ID_FIELD, VIRTUAL_INTERFACE_TYPE_FIELD, VIRTUAL_INTERFACE_NAME_FIELD, VLAN_FIELD, ASN_FIELD, AMAZON_SIDE_ASN_FIELD, AUTH_KEY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, ADDRESS_FAMILY_FIELD, VIRTUAL_INTERFACE_STATE_FIELD, CUSTOMER_ROUTER_CONFIG_FIELD, MTU_FIELD, JUMBO_FRAME_CAPABLE_FIELD, VIRTUAL_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_ID_FIELD, ROUTE_FILTER_PREFIXES_FIELD, BGP_PEERS_FIELD, REGION_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD, TAGS_FIELD, SITE_LINK_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateVirtualInterfaceAttributesResponse.memberNameToFieldInitializer();
    private final String ownerAccount;
    private final String virtualInterfaceId;
    private final String location;
    private final String connectionId;
    private final String virtualInterfaceType;
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final Long amazonSideAsn;
    private final String authKey;
    private final String amazonAddress;
    private final String customerAddress;
    private final String addressFamily;
    private final String virtualInterfaceState;
    private final String customerRouterConfig;
    private final Integer mtu;
    private final Boolean jumboFrameCapable;
    private final String virtualGatewayId;
    private final String directConnectGatewayId;
    private final List<RouteFilterPrefix> routeFilterPrefixes;
    private final List<BGPPeer> bgpPeers;
    private final String region;
    private final String awsDeviceV2;
    private final String awsLogicalDeviceId;
    private final List<Tag> tags;
    private final Boolean siteLinkEnabled;

    private UpdateVirtualInterfaceAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.location = builder.location;
        this.connectionId = builder.connectionId;
        this.virtualInterfaceType = builder.virtualInterfaceType;
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.virtualInterfaceState = builder.virtualInterfaceState;
        this.customerRouterConfig = builder.customerRouterConfig;
        this.mtu = builder.mtu;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.bgpPeers = builder.bgpPeers;
        this.region = builder.region;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
        this.tags = builder.tags;
        this.siteLinkEnabled = builder.siteLinkEnabled;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final String location() {
        return this.location;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String virtualInterfaceType() {
        return this.virtualInterfaceType;
    }

    public final String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final Integer asn() {
        return this.asn;
    }

    public final Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public final String authKey() {
        return this.authKey;
    }

    public final String amazonAddress() {
        return this.amazonAddress;
    }

    public final String customerAddress() {
        return this.customerAddress;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final VirtualInterfaceState virtualInterfaceState() {
        return VirtualInterfaceState.fromValue(this.virtualInterfaceState);
    }

    public final String virtualInterfaceStateAsString() {
        return this.virtualInterfaceState;
    }

    public final String customerRouterConfig() {
        return this.customerRouterConfig;
    }

    public final Integer mtu() {
        return this.mtu;
    }

    public final Boolean jumboFrameCapable() {
        return this.jumboFrameCapable;
    }

    public final String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public final String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public final boolean hasRouteFilterPrefixes() {
        return this.routeFilterPrefixes != null && !(this.routeFilterPrefixes instanceof SdkAutoConstructList);
    }

    public final List<RouteFilterPrefix> routeFilterPrefixes() {
        return this.routeFilterPrefixes;
    }

    public final boolean hasBgpPeers() {
        return this.bgpPeers != null && !(this.bgpPeers instanceof SdkAutoConstructList);
    }

    public final List<BGPPeer> bgpPeers() {
        return this.bgpPeers;
    }

    public final String region() {
        return this.region;
    }

    public final String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public final String awsLogicalDeviceId() {
        return this.awsLogicalDeviceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean siteLinkEnabled() {
        return this.siteLinkEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerRouterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.mtu());
        hashCode = 31 * hashCode + Objects.hashCode(this.jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteFilterPrefixes() ? this.routeFilterPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBgpPeers() ? this.bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLogicalDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.siteLinkEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualInterfaceAttributesResponse)) {
            return false;
        }
        UpdateVirtualInterfaceAttributesResponse other = (UpdateVirtualInterfaceAttributesResponse)((Object)obj);
        return Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.virtualInterfaceType(), other.virtualInterfaceType()) && Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.virtualInterfaceStateAsString(), other.virtualInterfaceStateAsString()) && Objects.equals(this.customerRouterConfig(), other.customerRouterConfig()) && Objects.equals(this.mtu(), other.mtu()) && Objects.equals(this.jumboFrameCapable(), other.jumboFrameCapable()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId()) && Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && this.hasRouteFilterPrefixes() == other.hasRouteFilterPrefixes() && Objects.equals(this.routeFilterPrefixes(), other.routeFilterPrefixes()) && this.hasBgpPeers() == other.hasBgpPeers() && Objects.equals(this.bgpPeers(), other.bgpPeers()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2()) && Objects.equals(this.awsLogicalDeviceId(), other.awsLogicalDeviceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.siteLinkEnabled(), other.siteLinkEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVirtualInterfaceAttributesResponse").add("OwnerAccount", (Object)this.ownerAccount()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("Location", (Object)this.location()).add("ConnectionId", (Object)this.connectionId()).add("VirtualInterfaceType", (Object)this.virtualInterfaceType()).add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).add("Vlan", (Object)this.vlan()).add("Asn", (Object)this.asn()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("AuthKey", (Object)this.authKey()).add("AmazonAddress", (Object)this.amazonAddress()).add("CustomerAddress", (Object)this.customerAddress()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("VirtualInterfaceState", (Object)this.virtualInterfaceStateAsString()).add("CustomerRouterConfig", (Object)this.customerRouterConfig()).add("Mtu", (Object)this.mtu()).add("JumboFrameCapable", (Object)this.jumboFrameCapable()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("RouteFilterPrefixes", this.hasRouteFilterPrefixes() ? this.routeFilterPrefixes() : null).add("BgpPeers", this.hasBgpPeers() ? this.bgpPeers() : null).add("Region", (Object)this.region()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).add("AwsLogicalDeviceId", (Object)this.awsLogicalDeviceId()).add("Tags", this.hasTags() ? this.tags() : null).add("SiteLinkEnabled", (Object)this.siteLinkEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "virtualInterfaceType": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceType()));
            }
            case "virtualInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceName()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "amazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "authKey": {
                return Optional.ofNullable(clazz.cast(this.authKey()));
            }
            case "amazonAddress": {
                return Optional.ofNullable(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "virtualInterfaceState": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceStateAsString()));
            }
            case "customerRouterConfig": {
                return Optional.ofNullable(clazz.cast(this.customerRouterConfig()));
            }
            case "mtu": {
                return Optional.ofNullable(clazz.cast(this.mtu()));
            }
            case "jumboFrameCapable": {
                return Optional.ofNullable(clazz.cast(this.jumboFrameCapable()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "routeFilterPrefixes": {
                return Optional.ofNullable(clazz.cast(this.routeFilterPrefixes()));
            }
            case "bgpPeers": {
                return Optional.ofNullable(clazz.cast(this.bgpPeers()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
            case "awsLogicalDeviceId": {
                return Optional.ofNullable(clazz.cast(this.awsLogicalDeviceId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "siteLinkEnabled": {
                return Optional.ofNullable(clazz.cast(this.siteLinkEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("virtualInterfaceType", VIRTUAL_INTERFACE_TYPE_FIELD);
        map.put("virtualInterfaceName", VIRTUAL_INTERFACE_NAME_FIELD);
        map.put("vlan", VLAN_FIELD);
        map.put("asn", ASN_FIELD);
        map.put("amazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        map.put("authKey", AUTH_KEY_FIELD);
        map.put("amazonAddress", AMAZON_ADDRESS_FIELD);
        map.put("customerAddress", CUSTOMER_ADDRESS_FIELD);
        map.put("addressFamily", ADDRESS_FAMILY_FIELD);
        map.put("virtualInterfaceState", VIRTUAL_INTERFACE_STATE_FIELD);
        map.put("customerRouterConfig", CUSTOMER_ROUTER_CONFIG_FIELD);
        map.put("mtu", MTU_FIELD);
        map.put("jumboFrameCapable", JUMBO_FRAME_CAPABLE_FIELD);
        map.put("virtualGatewayId", VIRTUAL_GATEWAY_ID_FIELD);
        map.put("directConnectGatewayId", DIRECT_CONNECT_GATEWAY_ID_FIELD);
        map.put("routeFilterPrefixes", ROUTE_FILTER_PREFIXES_FIELD);
        map.put("bgpPeers", BGP_PEERS_FIELD);
        map.put("region", REGION_FIELD);
        map.put("awsDeviceV2", AWS_DEVICE_V2_FIELD);
        map.put("awsLogicalDeviceId", AWS_LOGICAL_DEVICE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("siteLinkEnabled", SITE_LINK_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualInterfaceAttributesResponse, T> g) {
        return obj -> g.apply((UpdateVirtualInterfaceAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String ownerAccount;
        private String virtualInterfaceId;
        private String location;
        private String connectionId;
        private String virtualInterfaceType;
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private Long amazonSideAsn;
        private String authKey;
        private String amazonAddress;
        private String customerAddress;
        private String addressFamily;
        private String virtualInterfaceState;
        private String customerRouterConfig;
        private Integer mtu;
        private Boolean jumboFrameCapable;
        private String virtualGatewayId;
        private String directConnectGatewayId;
        private List<RouteFilterPrefix> routeFilterPrefixes = DefaultSdkAutoConstructList.getInstance();
        private List<BGPPeer> bgpPeers = DefaultSdkAutoConstructList.getInstance();
        private String region;
        private String awsDeviceV2;
        private String awsLogicalDeviceId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean siteLinkEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualInterfaceAttributesResponse model) {
            super(model);
            this.ownerAccount(model.ownerAccount);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.location(model.location);
            this.connectionId(model.connectionId);
            this.virtualInterfaceType(model.virtualInterfaceType);
            this.virtualInterfaceName(model.virtualInterfaceName);
            this.vlan(model.vlan);
            this.asn(model.asn);
            this.amazonSideAsn(model.amazonSideAsn);
            this.authKey(model.authKey);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.addressFamily(model.addressFamily);
            this.virtualInterfaceState(model.virtualInterfaceState);
            this.customerRouterConfig(model.customerRouterConfig);
            this.mtu(model.mtu);
            this.jumboFrameCapable(model.jumboFrameCapable);
            this.virtualGatewayId(model.virtualGatewayId);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.routeFilterPrefixes(model.routeFilterPrefixes);
            this.bgpPeers(model.bgpPeers);
            this.region(model.region);
            this.awsDeviceV2(model.awsDeviceV2);
            this.awsLogicalDeviceId(model.awsLogicalDeviceId);
            this.tags(model.tags);
            this.siteLinkEnabled(model.siteLinkEnabled);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getVirtualInterfaceType() {
            return this.virtualInterfaceType;
        }

        public final void setVirtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
        }

        @Override
        public final Builder virtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
            return this;
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getVirtualInterfaceState() {
            return this.virtualInterfaceState;
        }

        public final void setVirtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
        }

        @Override
        public final Builder virtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
            return this;
        }

        @Override
        public final Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState) {
            this.virtualInterfaceState(virtualInterfaceState == null ? null : virtualInterfaceState.toString());
            return this;
        }

        public final String getCustomerRouterConfig() {
            return this.customerRouterConfig;
        }

        public final void setCustomerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
        }

        @Override
        public final Builder customerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
            return this;
        }

        public final Integer getMtu() {
            return this.mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final Boolean getJumboFrameCapable() {
            return this.jumboFrameCapable;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final List<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            List<RouteFilterPrefix.Builder> result = RouteFilterPrefixListCopier.copyToBuilder(this.routeFilterPrefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder> ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Stream.of(routeFilterPrefixes).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BGPPeer.Builder> getBgpPeers() {
            List<BGPPeer.Builder> result = BGPPeerListCopier.copyToBuilder(this.bgpPeers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBgpPeers(Collection<BGPPeer.BuilderImpl> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copyFromBuilder(bgpPeers);
        }

        @Override
        public final Builder bgpPeers(Collection<BGPPeer> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(BGPPeer ... bgpPeers) {
            this.bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(Consumer<BGPPeer.Builder> ... bgpPeers) {
            this.bgpPeers(Stream.of(bgpPeers).map(c -> (BGPPeer)((BGPPeer.Builder)BGPPeer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final String getAwsLogicalDeviceId() {
            return this.awsLogicalDeviceId;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        @Override
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSiteLinkEnabled() {
            return this.siteLinkEnabled;
        }

        public final void setSiteLinkEnabled(Boolean siteLinkEnabled) {
            this.siteLinkEnabled = siteLinkEnabled;
        }

        @Override
        public final Builder siteLinkEnabled(Boolean siteLinkEnabled) {
            this.siteLinkEnabled = siteLinkEnabled;
            return this;
        }

        @Override
        public UpdateVirtualInterfaceAttributesResponse build() {
            return new UpdateVirtualInterfaceAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVirtualInterfaceAttributesResponse> {
        public Builder ownerAccount(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder location(String var1);

        public Builder connectionId(String var1);

        public Builder virtualInterfaceType(String var1);

        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder amazonSideAsn(Long var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder virtualInterfaceState(String var1);

        public Builder virtualInterfaceState(VirtualInterfaceState var1);

        public Builder customerRouterConfig(String var1);

        public Builder mtu(Integer var1);

        public Builder jumboFrameCapable(Boolean var1);

        public Builder virtualGatewayId(String var1);

        public Builder directConnectGatewayId(String var1);

        public Builder routeFilterPrefixes(Collection<RouteFilterPrefix> var1);

        public Builder routeFilterPrefixes(RouteFilterPrefix ... var1);

        public Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder bgpPeers(Collection<BGPPeer> var1);

        public Builder bgpPeers(BGPPeer ... var1);

        public Builder bgpPeers(Consumer<BGPPeer.Builder> ... var1);

        public Builder region(String var1);

        public Builder awsDeviceV2(String var1);

        public Builder awsLogicalDeviceId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder siteLinkEnabled(Boolean var1);
    }
}

