/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.VirtualInterface;
import software.amazon.awssdk.services.directconnect.model.VirtualInterfaceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVirtualInterfacesResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeVirtualInterfacesResponse> {
    private static final SdkField<List<VirtualInterface>> VIRTUAL_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("virtualInterfaces").getter(DescribeVirtualInterfacesResponse.getter(DescribeVirtualInterfacesResponse::virtualInterfaces)).setter(DescribeVirtualInterfacesResponse.setter(Builder::virtualInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVirtualInterfacesResponse.memberNameToFieldInitializer();
    private final List<VirtualInterface> virtualInterfaces;

    private DescribeVirtualInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaces = builder.virtualInterfaces;
    }

    public final boolean hasVirtualInterfaces() {
        return this.virtualInterfaces != null && !(this.virtualInterfaces instanceof SdkAutoConstructList);
    }

    public final List<VirtualInterface> virtualInterfaces() {
        return this.virtualInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualInterfaces() ? this.virtualInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualInterfacesResponse)) {
            return false;
        }
        DescribeVirtualInterfacesResponse other = (DescribeVirtualInterfacesResponse)((Object)obj);
        return this.hasVirtualInterfaces() == other.hasVirtualInterfaces() && Objects.equals(this.virtualInterfaces(), other.virtualInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVirtualInterfacesResponse").add("VirtualInterfaces", this.hasVirtualInterfaces() ? this.virtualInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaces": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<VirtualInterface>>> map = new HashMap<String, SdkField<List<VirtualInterface>>>();
        map.put("virtualInterfaces", VIRTUAL_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualInterfacesResponse, T> g) {
        return obj -> g.apply((DescribeVirtualInterfacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<VirtualInterface> virtualInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualInterfacesResponse model) {
            super(model);
            this.virtualInterfaces(model.virtualInterfaces);
        }

        public final List<VirtualInterface.Builder> getVirtualInterfaces() {
            List<VirtualInterface.Builder> result = VirtualInterfaceListCopier.copyToBuilder(this.virtualInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualInterfaces(Collection<VirtualInterface.BuilderImpl> virtualInterfaces) {
            this.virtualInterfaces = VirtualInterfaceListCopier.copyFromBuilder(virtualInterfaces);
        }

        @Override
        public final Builder virtualInterfaces(Collection<VirtualInterface> virtualInterfaces) {
            this.virtualInterfaces = VirtualInterfaceListCopier.copy(virtualInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaces(VirtualInterface ... virtualInterfaces) {
            this.virtualInterfaces(Arrays.asList(virtualInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaces(Consumer<VirtualInterface.Builder> ... virtualInterfaces) {
            this.virtualInterfaces(Stream.of(virtualInterfaces).map(c -> (VirtualInterface)((VirtualInterface.Builder)VirtualInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVirtualInterfacesResponse build() {
            return new DescribeVirtualInterfacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVirtualInterfacesResponse> {
        public Builder virtualInterfaces(Collection<VirtualInterface> var1);

        public Builder virtualInterfaces(VirtualInterface ... var1);

        public Builder virtualInterfaces(Consumer<VirtualInterface.Builder> ... var1);
    }
}

