/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewPrivateVirtualInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NewPrivateVirtualInterface> {
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceName").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::virtualInterfaceName)).setter(NewPrivateVirtualInterface.setter(Builder::virtualInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlan").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::vlan)).setter(NewPrivateVirtualInterface.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()}).build();
    private static final SdkField<Integer> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("asn").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::asn)).setter(NewPrivateVirtualInterface.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()}).build();
    private static final SdkField<Integer> MTU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mtu").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::mtu)).setter(NewPrivateVirtualInterface.setter(Builder::mtu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()}).build();
    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authKey").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::authKey)).setter(NewPrivateVirtualInterface.setter(Builder::authKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()}).build();
    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amazonAddress").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::amazonAddress)).setter(NewPrivateVirtualInterface.setter(Builder::amazonAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()}).build();
    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerAddress").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::customerAddress)).setter(NewPrivateVirtualInterface.setter(Builder::customerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressFamily").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::addressFamilyAsString)).setter(NewPrivateVirtualInterface.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayId").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::virtualGatewayId)).setter(NewPrivateVirtualInterface.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::directConnectGatewayId)).setter(NewPrivateVirtualInterface.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::tags)).setter(NewPrivateVirtualInterface.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_SITE_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableSiteLink").getter(NewPrivateVirtualInterface.getter(NewPrivateVirtualInterface::enableSiteLink)).setter(NewPrivateVirtualInterface.setter(Builder::enableSiteLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSiteLink").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_NAME_FIELD, VLAN_FIELD, ASN_FIELD, MTU_FIELD, AUTH_KEY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, ADDRESS_FAMILY_FIELD, VIRTUAL_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_ID_FIELD, TAGS_FIELD, ENABLE_SITE_LINK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NewPrivateVirtualInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final Integer mtu;
    private final String authKey;
    private final String amazonAddress;
    private final String customerAddress;
    private final String addressFamily;
    private final String virtualGatewayId;
    private final String directConnectGatewayId;
    private final List<Tag> tags;
    private final Boolean enableSiteLink;

    private NewPrivateVirtualInterface(BuilderImpl builder) {
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.mtu = builder.mtu;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.tags = builder.tags;
        this.enableSiteLink = builder.enableSiteLink;
    }

    public final String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final Integer asn() {
        return this.asn;
    }

    public final Integer mtu() {
        return this.mtu;
    }

    public final String authKey() {
        return this.authKey;
    }

    public final String amazonAddress() {
        return this.amazonAddress;
    }

    public final String customerAddress() {
        return this.customerAddress;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public final String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean enableSiteLink() {
        return this.enableSiteLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mtu());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSiteLink());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewPrivateVirtualInterface)) {
            return false;
        }
        NewPrivateVirtualInterface other = (NewPrivateVirtualInterface)obj;
        return Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.mtu(), other.mtu()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId()) && Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableSiteLink(), other.enableSiteLink());
    }

    public final String toString() {
        return ToString.builder((String)"NewPrivateVirtualInterface").add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).add("Vlan", (Object)this.vlan()).add("Asn", (Object)this.asn()).add("Mtu", (Object)this.mtu()).add("AuthKey", (Object)this.authKey()).add("AmazonAddress", (Object)this.amazonAddress()).add("CustomerAddress", (Object)this.customerAddress()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("Tags", this.hasTags() ? this.tags() : null).add("EnableSiteLink", (Object)this.enableSiteLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceName()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "mtu": {
                return Optional.ofNullable(clazz.cast(this.mtu()));
            }
            case "authKey": {
                return Optional.ofNullable(clazz.cast(this.authKey()));
            }
            case "amazonAddress": {
                return Optional.ofNullable(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "enableSiteLink": {
                return Optional.ofNullable(clazz.cast(this.enableSiteLink()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("virtualInterfaceName", VIRTUAL_INTERFACE_NAME_FIELD);
        map.put("vlan", VLAN_FIELD);
        map.put("asn", ASN_FIELD);
        map.put("mtu", MTU_FIELD);
        map.put("authKey", AUTH_KEY_FIELD);
        map.put("amazonAddress", AMAZON_ADDRESS_FIELD);
        map.put("customerAddress", CUSTOMER_ADDRESS_FIELD);
        map.put("addressFamily", ADDRESS_FAMILY_FIELD);
        map.put("virtualGatewayId", VIRTUAL_GATEWAY_ID_FIELD);
        map.put("directConnectGatewayId", DIRECT_CONNECT_GATEWAY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("enableSiteLink", ENABLE_SITE_LINK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NewPrivateVirtualInterface, T> g) {
        return obj -> g.apply((NewPrivateVirtualInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private Integer mtu;
        private String authKey;
        private String amazonAddress;
        private String customerAddress;
        private String addressFamily;
        private String virtualGatewayId;
        private String directConnectGatewayId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableSiteLink;

        private BuilderImpl() {
        }

        private BuilderImpl(NewPrivateVirtualInterface model) {
            this.virtualInterfaceName(model.virtualInterfaceName);
            this.vlan(model.vlan);
            this.asn(model.asn);
            this.mtu(model.mtu);
            this.authKey(model.authKey);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.addressFamily(model.addressFamily);
            this.virtualGatewayId(model.virtualGatewayId);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.tags(model.tags);
            this.enableSiteLink(model.enableSiteLink);
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final Integer getMtu() {
            return this.mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableSiteLink() {
            return this.enableSiteLink;
        }

        public final void setEnableSiteLink(Boolean enableSiteLink) {
            this.enableSiteLink = enableSiteLink;
        }

        @Override
        public final Builder enableSiteLink(Boolean enableSiteLink) {
            this.enableSiteLink = enableSiteLink;
            return this;
        }

        public NewPrivateVirtualInterface build() {
            return new NewPrivateVirtualInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NewPrivateVirtualInterface> {
        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder mtu(Integer var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder virtualGatewayId(String var1);

        public Builder directConnectGatewayId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableSiteLink(Boolean var1);
    }
}

