/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectConnectGatewayAssociationsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsResponse> {
    private static final SdkField<List<DirectConnectGatewayAssociation>> DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDirectConnectGatewayAssociationsResponse.getter(DescribeDirectConnectGatewayAssociationsResponse::directConnectGatewayAssociations)).setter(DescribeDirectConnectGatewayAssociationsResponse.setter(Builder::directConnectGatewayAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectConnectGatewayAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDirectConnectGatewayAssociationsResponse.getter(DescribeDirectConnectGatewayAssociationsResponse::nextToken)).setter(DescribeDirectConnectGatewayAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DirectConnectGatewayAssociation> directConnectGatewayAssociations;
    private final String nextToken;

    private DescribeDirectConnectGatewayAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociations = builder.directConnectGatewayAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<DirectConnectGatewayAssociation> directConnectGatewayAssociations() {
        return this.directConnectGatewayAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAssociationsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAssociationsResponse other = (DescribeDirectConnectGatewayAssociationsResponse)((Object)obj);
        return Objects.equals(this.directConnectGatewayAssociations(), other.directConnectGatewayAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDirectConnectGatewayAssociationsResponse").add("DirectConnectGatewayAssociations", this.directConnectGatewayAssociations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayAssociations": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<DirectConnectGatewayAssociation> directConnectGatewayAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAssociationsResponse model) {
            super(model);
            this.directConnectGatewayAssociations(model.directConnectGatewayAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<DirectConnectGatewayAssociation.Builder> getDirectConnectGatewayAssociations() {
            return this.directConnectGatewayAssociations != null ? (Collection)this.directConnectGatewayAssociations.stream().map(DirectConnectGatewayAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation> directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations = DirectConnectGatewayAssociationListCopier.copy(directConnectGatewayAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociations(DirectConnectGatewayAssociation ... directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations(Arrays.asList(directConnectGatewayAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociations(Consumer<DirectConnectGatewayAssociation.Builder> ... directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations(Stream.of(directConnectGatewayAssociations).map(c -> (DirectConnectGatewayAssociation)((DirectConnectGatewayAssociation.Builder)DirectConnectGatewayAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation.BuilderImpl> directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations = DirectConnectGatewayAssociationListCopier.copyFromBuilder(directConnectGatewayAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectConnectGatewayAssociationsResponse build() {
            return new DescribeDirectConnectGatewayAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsResponse> {
        public Builder directConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation> var1);

        public Builder directConnectGatewayAssociations(DirectConnectGatewayAssociation ... var1);

        public Builder directConnectGatewayAssociations(Consumer<DirectConnectGatewayAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

