/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVirtualInterfaceAttributesRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, UpdateVirtualInterfaceAttributesRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(UpdateVirtualInterfaceAttributesRequest.getter(UpdateVirtualInterfaceAttributesRequest::virtualInterfaceId)).setter(UpdateVirtualInterfaceAttributesRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<Integer> MTU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mtu").getter(UpdateVirtualInterfaceAttributesRequest.getter(UpdateVirtualInterfaceAttributesRequest::mtu)).setter(UpdateVirtualInterfaceAttributesRequest.setter(Builder::mtu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()}).build();
    private static final SdkField<Boolean> ENABLE_SITE_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableSiteLink").getter(UpdateVirtualInterfaceAttributesRequest.getter(UpdateVirtualInterfaceAttributesRequest::enableSiteLink)).setter(UpdateVirtualInterfaceAttributesRequest.setter(Builder::enableSiteLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSiteLink").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceName").getter(UpdateVirtualInterfaceAttributesRequest.getter(UpdateVirtualInterfaceAttributesRequest::virtualInterfaceName)).setter(UpdateVirtualInterfaceAttributesRequest.setter(Builder::virtualInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD, MTU_FIELD, ENABLE_SITE_LINK_FIELD, VIRTUAL_INTERFACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
            this.put("mtu", MTU_FIELD);
            this.put("enableSiteLink", ENABLE_SITE_LINK_FIELD);
            this.put("virtualInterfaceName", VIRTUAL_INTERFACE_NAME_FIELD);
        }
    });
    private final String virtualInterfaceId;
    private final Integer mtu;
    private final Boolean enableSiteLink;
    private final String virtualInterfaceName;

    private UpdateVirtualInterfaceAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.mtu = builder.mtu;
        this.enableSiteLink = builder.enableSiteLink;
        this.virtualInterfaceName = builder.virtualInterfaceName;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final Integer mtu() {
        return this.mtu;
    }

    public final Boolean enableSiteLink() {
        return this.enableSiteLink;
    }

    public final String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mtu());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSiteLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualInterfaceAttributesRequest)) {
            return false;
        }
        UpdateVirtualInterfaceAttributesRequest other = (UpdateVirtualInterfaceAttributesRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.mtu(), other.mtu()) && Objects.equals(this.enableSiteLink(), other.enableSiteLink()) && Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVirtualInterfaceAttributesRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("Mtu", (Object)this.mtu()).add("EnableSiteLink", (Object)this.enableSiteLink()).add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "mtu": {
                return Optional.ofNullable(clazz.cast(this.mtu()));
            }
            case "enableSiteLink": {
                return Optional.ofNullable(clazz.cast(this.enableSiteLink()));
            }
            case "virtualInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualInterfaceAttributesRequest, T> g) {
        return obj -> g.apply((UpdateVirtualInterfaceAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private Integer mtu;
        private Boolean enableSiteLink;
        private String virtualInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualInterfaceAttributesRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.mtu(model.mtu);
            this.enableSiteLink(model.enableSiteLink);
            this.virtualInterfaceName(model.virtualInterfaceName);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Integer getMtu() {
            return this.mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final Boolean getEnableSiteLink() {
            return this.enableSiteLink;
        }

        public final void setEnableSiteLink(Boolean enableSiteLink) {
            this.enableSiteLink = enableSiteLink;
        }

        @Override
        public final Builder enableSiteLink(Boolean enableSiteLink) {
            this.enableSiteLink = enableSiteLink;
            return this;
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualInterfaceAttributesRequest build() {
            return new UpdateVirtualInterfaceAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVirtualInterfaceAttributesRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder mtu(Integer var1);

        public Builder enableSiteLink(Boolean var1);

        public Builder virtualInterfaceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

