/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectConnectGatewayAttachmentsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
    private static final SdkField<List<DirectConnectGatewayAttachment>> DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("directConnectGatewayAttachments").getter(DescribeDirectConnectGatewayAttachmentsResponse.getter(DescribeDirectConnectGatewayAttachmentsResponse::directConnectGatewayAttachments)).setter(DescribeDirectConnectGatewayAttachmentsResponse.setter(Builder::directConnectGatewayAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectConnectGatewayAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDirectConnectGatewayAttachmentsResponse.getter(DescribeDirectConnectGatewayAttachmentsResponse::nextToken)).setter(DescribeDirectConnectGatewayAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DirectConnectGatewayAttachment> directConnectGatewayAttachments;
    private final String nextToken;

    private DescribeDirectConnectGatewayAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAttachments = builder.directConnectGatewayAttachments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDirectConnectGatewayAttachments() {
        return this.directConnectGatewayAttachments != null && !(this.directConnectGatewayAttachments instanceof SdkAutoConstructList);
    }

    public final List<DirectConnectGatewayAttachment> directConnectGatewayAttachments() {
        return this.directConnectGatewayAttachments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectConnectGatewayAttachments() ? this.directConnectGatewayAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAttachmentsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAttachmentsResponse other = (DescribeDirectConnectGatewayAttachmentsResponse)((Object)obj);
        return this.hasDirectConnectGatewayAttachments() == other.hasDirectConnectGatewayAttachments() && Objects.equals(this.directConnectGatewayAttachments(), other.directConnectGatewayAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectConnectGatewayAttachmentsResponse").add("DirectConnectGatewayAttachments", this.hasDirectConnectGatewayAttachments() ? this.directConnectGatewayAttachments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayAttachments": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayAttachments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<DirectConnectGatewayAttachment> directConnectGatewayAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAttachmentsResponse model) {
            super(model);
            this.directConnectGatewayAttachments(model.directConnectGatewayAttachments);
            this.nextToken(model.nextToken);
        }

        public final List<DirectConnectGatewayAttachment.Builder> getDirectConnectGatewayAttachments() {
            List<DirectConnectGatewayAttachment.Builder> result = DirectConnectGatewayAttachmentListCopier.copyToBuilder(this.directConnectGatewayAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment.BuilderImpl> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier.copyFromBuilder(directConnectGatewayAttachments);
        }

        @Override
        public final Builder directConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier.copy(directConnectGatewayAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment ... directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments(Arrays.asList(directConnectGatewayAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(Consumer<DirectConnectGatewayAttachment.Builder> ... directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments(Stream.of(directConnectGatewayAttachments).map(c -> (DirectConnectGatewayAttachment)((DirectConnectGatewayAttachment.Builder)DirectConnectGatewayAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectConnectGatewayAttachmentsResponse build() {
            return new DescribeDirectConnectGatewayAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
        public Builder directConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment> var1);

        public Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment ... var1);

        public Builder directConnectGatewayAttachments(Consumer<DirectConnectGatewayAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

