/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy;
import software.amazon.awssdk.services.directconnect.model.InterconnectState;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInterconnectResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, CreateInterconnectResponse> {
    private static final SdkField<String> INTERCONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interconnectId").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::interconnectId)).setter(CreateInterconnectResponse.setter(Builder::interconnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectId").build()}).build();
    private static final SdkField<String> INTERCONNECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interconnectName").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::interconnectName)).setter(CreateInterconnectResponse.setter(Builder::interconnectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectName").build()}).build();
    private static final SdkField<String> INTERCONNECT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interconnectState").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::interconnectStateAsString)).setter(CreateInterconnectResponse.setter(Builder::interconnectState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectState").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::region)).setter(CreateInterconnectResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::location)).setter(CreateInterconnectResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bandwidth").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::bandwidth)).setter(CreateInterconnectResponse.setter(Builder::bandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<Instant> LOA_ISSUE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("loaIssueTime").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::loaIssueTime)).setter(CreateInterconnectResponse.setter(Builder::loaIssueTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaIssueTime").build()}).build();
    private static final SdkField<String> LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagId").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::lagId)).setter(CreateInterconnectResponse.setter(Builder::lagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()}).build();
    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDevice").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::awsDevice)).setter(CreateInterconnectResponse.setter(Builder::awsDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()}).build();
    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("jumboFrameCapable").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::jumboFrameCapable)).setter(CreateInterconnectResponse.setter(Builder::jumboFrameCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDeviceV2").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::awsDeviceV2)).setter(CreateInterconnectResponse.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsLogicalDeviceId").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::awsLogicalDeviceId)).setter(CreateInterconnectResponse.setter(Builder::awsLogicalDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build()}).build();
    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hasLogicalRedundancy").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::hasLogicalRedundancyAsString)).setter(CreateInterconnectResponse.setter(Builder::hasLogicalRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::tags)).setter(CreateInterconnectResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(CreateInterconnectResponse.getter(CreateInterconnectResponse::providerName)).setter(CreateInterconnectResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_ID_FIELD, INTERCONNECT_NAME_FIELD, INTERCONNECT_STATE_FIELD, REGION_FIELD, LOCATION_FIELD, BANDWIDTH_FIELD, LOA_ISSUE_TIME_FIELD, LAG_ID_FIELD, AWS_DEVICE_FIELD, JUMBO_FRAME_CAPABLE_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD, TAGS_FIELD, PROVIDER_NAME_FIELD));
    private final String interconnectId;
    private final String interconnectName;
    private final String interconnectState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;
    private final Boolean jumboFrameCapable;
    private final String awsDeviceV2;
    private final String awsLogicalDeviceId;
    private final String hasLogicalRedundancy;
    private final List<Tag> tags;
    private final String providerName;

    private CreateInterconnectResponse(BuilderImpl builder) {
        super(builder);
        this.interconnectId = builder.interconnectId;
        this.interconnectName = builder.interconnectName;
        this.interconnectState = builder.interconnectState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
    }

    public final String interconnectId() {
        return this.interconnectId;
    }

    public final String interconnectName() {
        return this.interconnectName;
    }

    public final InterconnectState interconnectState() {
        return InterconnectState.fromValue(this.interconnectState);
    }

    public final String interconnectStateAsString() {
        return this.interconnectState;
    }

    public final String region() {
        return this.region;
    }

    public final String location() {
        return this.location;
    }

    public final String bandwidth() {
        return this.bandwidth;
    }

    public final Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public final String lagId() {
        return this.lagId;
    }

    public final String awsDevice() {
        return this.awsDevice;
    }

    public final Boolean jumboFrameCapable() {
        return this.jumboFrameCapable;
    }

    public final String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public final String awsLogicalDeviceId() {
        return this.awsLogicalDeviceId;
    }

    public final HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(this.hasLogicalRedundancy);
    }

    public final String hasLogicalRedundancyAsString() {
        return this.hasLogicalRedundancy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String providerName() {
        return this.providerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLogicalDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInterconnectResponse)) {
            return false;
        }
        CreateInterconnectResponse other = (CreateInterconnectResponse)((Object)obj);
        return Objects.equals(this.interconnectId(), other.interconnectId()) && Objects.equals(this.interconnectName(), other.interconnectName()) && Objects.equals(this.interconnectStateAsString(), other.interconnectStateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.jumboFrameCapable(), other.jumboFrameCapable()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2()) && Objects.equals(this.awsLogicalDeviceId(), other.awsLogicalDeviceId()) && Objects.equals(this.hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.providerName(), other.providerName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInterconnectResponse").add("InterconnectId", (Object)this.interconnectId()).add("InterconnectName", (Object)this.interconnectName()).add("InterconnectState", (Object)this.interconnectStateAsString()).add("Region", (Object)this.region()).add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("LoaIssueTime", (Object)this.loaIssueTime()).add("LagId", (Object)this.lagId()).add("AwsDevice", (Object)this.awsDevice()).add("JumboFrameCapable", (Object)this.jumboFrameCapable()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).add("AwsLogicalDeviceId", (Object)this.awsLogicalDeviceId()).add("HasLogicalRedundancy", (Object)this.hasLogicalRedundancyAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ProviderName", (Object)this.providerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.ofNullable(clazz.cast(this.interconnectId()));
            }
            case "interconnectName": {
                return Optional.ofNullable(clazz.cast(this.interconnectName()));
            }
            case "interconnectState": {
                return Optional.ofNullable(clazz.cast(this.interconnectStateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "loaIssueTime": {
                return Optional.ofNullable(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "jumboFrameCapable": {
                return Optional.ofNullable(clazz.cast(this.jumboFrameCapable()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
            case "awsLogicalDeviceId": {
                return Optional.ofNullable(clazz.cast(this.awsLogicalDeviceId()));
            }
            case "hasLogicalRedundancy": {
                return Optional.ofNullable(clazz.cast(this.hasLogicalRedundancyAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInterconnectResponse, T> g) {
        return obj -> g.apply((CreateInterconnectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String interconnectId;
        private String interconnectName;
        private String interconnectState;
        private String region;
        private String location;
        private String bandwidth;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;
        private Boolean jumboFrameCapable;
        private String awsDeviceV2;
        private String awsLogicalDeviceId;
        private String hasLogicalRedundancy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInterconnectResponse model) {
            super(model);
            this.interconnectId(model.interconnectId);
            this.interconnectName(model.interconnectName);
            this.interconnectState(model.interconnectState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
            this.jumboFrameCapable(model.jumboFrameCapable);
            this.awsDeviceV2(model.awsDeviceV2);
            this.awsLogicalDeviceId(model.awsLogicalDeviceId);
            this.hasLogicalRedundancy(model.hasLogicalRedundancy);
            this.tags(model.tags);
            this.providerName(model.providerName);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getInterconnectName() {
            return this.interconnectName;
        }

        @Override
        public final Builder interconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
            return this;
        }

        public final void setInterconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
        }

        public final String getInterconnectState() {
            return this.interconnectState;
        }

        @Override
        public final Builder interconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
            return this;
        }

        @Override
        public final Builder interconnectState(InterconnectState interconnectState) {
            this.interconnectState(interconnectState == null ? null : interconnectState.toString());
            return this;
        }

        public final void setInterconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final Boolean getJumboFrameCapable() {
            return this.jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        public final String getAwsLogicalDeviceId() {
            return this.awsLogicalDeviceId;
        }

        @Override
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        public final String getHasLogicalRedundancy() {
            return this.hasLogicalRedundancy;
        }

        @Override
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy == null ? null : hasLogicalRedundancy.toString());
            return this;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public CreateInterconnectResponse build() {
            return new CreateInterconnectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInterconnectResponse> {
        public Builder interconnectId(String var1);

        public Builder interconnectName(String var1);

        public Builder interconnectState(String var1);

        public Builder interconnectState(InterconnectState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);

        public Builder jumboFrameCapable(Boolean var1);

        public Builder awsDeviceV2(String var1);

        public Builder awsLogicalDeviceId(String var1);

        public Builder hasLogicalRedundancy(String var1);

        public Builder hasLogicalRedundancy(HasLogicalRedundancy var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder providerName(String var1);
    }
}

