/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.BGPPeerIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualInterfaceTestHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualInterfaceTestHistory> {
    private static final SdkField<String> TEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testId").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::testId)).setter(VirtualInterfaceTestHistory.setter(Builder::testId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testId").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::virtualInterfaceId)).setter(VirtualInterfaceTestHistory.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<List<String>> BGP_PEERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bgpPeers").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::bgpPeers)).setter(VirtualInterfaceTestHistory.setter(Builder::bgpPeers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::status)).setter(VirtualInterfaceTestHistory.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::ownerAccount)).setter(VirtualInterfaceTestHistory.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<Integer> TEST_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testDurationInMinutes").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::testDurationInMinutes)).setter(VirtualInterfaceTestHistory.setter(Builder::testDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testDurationInMinutes").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::startTime)).setter(VirtualInterfaceTestHistory.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(VirtualInterfaceTestHistory.getter(VirtualInterfaceTestHistory::endTime)).setter(VirtualInterfaceTestHistory.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_ID_FIELD, VIRTUAL_INTERFACE_ID_FIELD, BGP_PEERS_FIELD, STATUS_FIELD, OWNER_ACCOUNT_FIELD, TEST_DURATION_IN_MINUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String testId;
    private final String virtualInterfaceId;
    private final List<String> bgpPeers;
    private final String status;
    private final String ownerAccount;
    private final Integer testDurationInMinutes;
    private final Instant startTime;
    private final Instant endTime;

    private VirtualInterfaceTestHistory(BuilderImpl builder) {
        this.testId = builder.testId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.bgpPeers = builder.bgpPeers;
        this.status = builder.status;
        this.ownerAccount = builder.ownerAccount;
        this.testDurationInMinutes = builder.testDurationInMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String testId() {
        return this.testId;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final boolean hasBgpPeers() {
        return this.bgpPeers != null && !(this.bgpPeers instanceof SdkAutoConstructList);
    }

    public final List<String> bgpPeers() {
        return this.bgpPeers;
    }

    public final String status() {
        return this.status;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final Integer testDurationInMinutes() {
        return this.testDurationInMinutes;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBgpPeers() ? this.bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.testDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualInterfaceTestHistory)) {
            return false;
        }
        VirtualInterfaceTestHistory other = (VirtualInterfaceTestHistory)obj;
        return Objects.equals(this.testId(), other.testId()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && this.hasBgpPeers() == other.hasBgpPeers() && Objects.equals(this.bgpPeers(), other.bgpPeers()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.testDurationInMinutes(), other.testDurationInMinutes()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualInterfaceTestHistory").add("TestId", (Object)this.testId()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("BgpPeers", this.hasBgpPeers() ? this.bgpPeers() : null).add("Status", (Object)this.status()).add("OwnerAccount", (Object)this.ownerAccount()).add("TestDurationInMinutes", (Object)this.testDurationInMinutes()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testId": {
                return Optional.ofNullable(clazz.cast(this.testId()));
            }
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "bgpPeers": {
                return Optional.ofNullable(clazz.cast(this.bgpPeers()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "testDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.testDurationInMinutes()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualInterfaceTestHistory, T> g) {
        return obj -> g.apply((VirtualInterfaceTestHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testId;
        private String virtualInterfaceId;
        private List<String> bgpPeers = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String ownerAccount;
        private Integer testDurationInMinutes;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualInterfaceTestHistory model) {
            this.testId(model.testId);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.bgpPeers(model.bgpPeers);
            this.status(model.status);
            this.ownerAccount(model.ownerAccount);
            this.testDurationInMinutes(model.testDurationInMinutes);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getTestId() {
            return this.testId;
        }

        @Override
        public final Builder testId(String testId) {
            this.testId = testId;
            return this;
        }

        public final void setTestId(String testId) {
            this.testId = testId;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final Collection<String> getBgpPeers() {
            if (this.bgpPeers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bgpPeers;
        }

        @Override
        public final Builder bgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(String ... bgpPeers) {
            this.bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final void setBgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final Integer getTestDurationInMinutes() {
            return this.testDurationInMinutes;
        }

        @Override
        public final Builder testDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
            return this;
        }

        public final void setTestDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public VirtualInterfaceTestHistory build() {
            return new VirtualInterfaceTestHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualInterfaceTestHistory> {
        public Builder testId(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder bgpPeers(Collection<String> var1);

        public Builder bgpPeers(String ... var1);

        public Builder status(String var1);

        public Builder ownerAccount(String var1);

        public Builder testDurationInMinutes(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

