/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.MacSecKey;
import software.amazon.awssdk.services.directconnect.model.MacSecKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateMacSecKeyResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DisassociateMacSecKeyResponse> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(DisassociateMacSecKeyResponse.getter(DisassociateMacSecKeyResponse::connectionId)).setter(DisassociateMacSecKeyResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<List<MacSecKey>> MAC_SEC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("macSecKeys").getter(DisassociateMacSecKeyResponse.getter(DisassociateMacSecKeyResponse::macSecKeys)).setter(DisassociateMacSecKeyResponse.setter(Builder::macSecKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MacSecKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, MAC_SEC_KEYS_FIELD));
    private final String connectionId;
    private final List<MacSecKey> macSecKeys;

    private DisassociateMacSecKeyResponse(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.macSecKeys = builder.macSecKeys;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final boolean hasMacSecKeys() {
        return this.macSecKeys != null && !(this.macSecKeys instanceof SdkAutoConstructList);
    }

    public final List<MacSecKey> macSecKeys() {
        return this.macSecKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacSecKeys() ? this.macSecKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateMacSecKeyResponse)) {
            return false;
        }
        DisassociateMacSecKeyResponse other = (DisassociateMacSecKeyResponse)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && this.hasMacSecKeys() == other.hasMacSecKeys() && Objects.equals(this.macSecKeys(), other.macSecKeys());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateMacSecKeyResponse").add("ConnectionId", (Object)this.connectionId()).add("MacSecKeys", this.hasMacSecKeys() ? this.macSecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "macSecKeys": {
                return Optional.ofNullable(clazz.cast(this.macSecKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateMacSecKeyResponse, T> g) {
        return obj -> g.apply((DisassociateMacSecKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String connectionId;
        private List<MacSecKey> macSecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateMacSecKeyResponse model) {
            super(model);
            this.connectionId(model.connectionId);
            this.macSecKeys(model.macSecKeys);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final Collection<MacSecKey.Builder> getMacSecKeys() {
            if (this.macSecKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.macSecKeys != null ? (Collection)this.macSecKeys.stream().map(MacSecKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder macSecKeys(Collection<MacSecKey> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copy(macSecKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(MacSecKey ... macSecKeys) {
            this.macSecKeys(Arrays.asList(macSecKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(Consumer<MacSecKey.Builder> ... macSecKeys) {
            this.macSecKeys(Stream.of(macSecKeys).map(c -> (MacSecKey)((MacSecKey.Builder)MacSecKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMacSecKeys(Collection<MacSecKey.BuilderImpl> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copyFromBuilder(macSecKeys);
        }

        @Override
        public DisassociateMacSecKeyResponse build() {
            return new DisassociateMacSecKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateMacSecKeyResponse> {
        public Builder connectionId(String var1);

        public Builder macSecKeys(Collection<MacSecKey> var1);

        public Builder macSecKeys(MacSecKey ... var1);

        public Builder macSecKeys(Consumer<MacSecKey.Builder> ... var1);
    }
}

