/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectConnectGatewayAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectConnectGatewayAssociation.Builder, DirectConnectGatewayAssociation> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayId").getter(getter(DirectConnectGatewayAssociation::directConnectGatewayId))
            .setter(setter(Builder::directConnectGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build())
            .build();

    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayOwnerAccount")
            .getter(getter(DirectConnectGatewayAssociation::directConnectGatewayOwnerAccount))
            .setter(setter(Builder::directConnectGatewayOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayOwnerAccount")
                    .build()).build();

    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationState").getter(getter(DirectConnectGatewayAssociation::associationStateAsString))
            .setter(setter(Builder::associationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationState").build()).build();

    private static final SdkField<String> STATE_CHANGE_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateChangeError").getter(getter(DirectConnectGatewayAssociation::stateChangeError))
            .setter(setter(Builder::stateChangeError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeError").build()).build();

    private static final SdkField<AssociatedGateway> ASSOCIATED_GATEWAY_FIELD = SdkField
            .<AssociatedGateway> builder(MarshallingType.SDK_POJO).memberName("associatedGateway")
            .getter(getter(DirectConnectGatewayAssociation::associatedGateway)).setter(setter(Builder::associatedGateway))
            .constructor(AssociatedGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGateway").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(DirectConnectGatewayAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()).build();

    private static final SdkField<List<RouteFilterPrefix>> ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("allowedPrefixesToDirectConnectGateway")
            .getter(getter(DirectConnectGatewayAssociation::allowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::allowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayId").getter(getter(DirectConnectGatewayAssociation::virtualGatewayId))
            .setter(setter(Builder::virtualGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayRegion").getter(getter(DirectConnectGatewayAssociation::virtualGatewayRegion))
            .setter(setter(Builder::virtualGatewayRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayRegion").build())
            .build();

    private static final SdkField<String> VIRTUAL_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayOwnerAccount")
            .getter(getter(DirectConnectGatewayAssociation::virtualGatewayOwnerAccount))
            .setter(setter(Builder::virtualGatewayOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayOwnerAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD, ASSOCIATION_STATE_FIELD,
            STATE_CHANGE_ERROR_FIELD, ASSOCIATED_GATEWAY_FIELD, ASSOCIATION_ID_FIELD,
            ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD, VIRTUAL_GATEWAY_ID_FIELD, VIRTUAL_GATEWAY_REGION_FIELD,
            VIRTUAL_GATEWAY_OWNER_ACCOUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directConnectGatewayId;

    private final String directConnectGatewayOwnerAccount;

    private final String associationState;

    private final String stateChangeError;

    private final AssociatedGateway associatedGateway;

    private final String associationId;

    private final List<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway;

    private final String virtualGatewayId;

    private final String virtualGatewayRegion;

    private final String virtualGatewayOwnerAccount;

    private DirectConnectGatewayAssociation(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.directConnectGatewayOwnerAccount = builder.directConnectGatewayOwnerAccount;
        this.associationState = builder.associationState;
        this.stateChangeError = builder.stateChangeError;
        this.associatedGateway = builder.associatedGateway;
        this.associationId = builder.associationId;
        this.allowedPrefixesToDirectConnectGateway = builder.allowedPrefixesToDirectConnectGateway;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.virtualGatewayRegion = builder.virtualGatewayRegion;
        this.virtualGatewayOwnerAccount = builder.virtualGatewayOwnerAccount;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway.
     */
    public final String directConnectGatewayId() {
        return directConnectGatewayId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the associated gateway.
     * </p>
     * 
     * @return The ID of the AWS account that owns the associated gateway.
     */
    public final String directConnectGatewayOwnerAccount() {
        return directConnectGatewayOwnerAccount;
    }

    /**
     * <p>
     * The state of the association. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
     * successfully associated and ready to pass traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct
     * Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway
     * is stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationState}
     * will return {@link DirectConnectGatewayAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationStateAsString}.
     * </p>
     * 
     * @return The state of the association. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
     *         successfully associated and ready to pass traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociating</code>: The initial state after calling
     *         <a>DeleteDirectConnectGatewayAssociation</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the
     *         Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or
     *         transit gateway is stopped.
     *         </p>
     *         </li>
     * @see DirectConnectGatewayAssociationState
     */
    public final DirectConnectGatewayAssociationState associationState() {
        return DirectConnectGatewayAssociationState.fromValue(associationState);
    }

    /**
     * <p>
     * The state of the association. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
     * successfully associated and ready to pass traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct
     * Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway
     * is stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationState}
     * will return {@link DirectConnectGatewayAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationStateAsString}.
     * </p>
     * 
     * @return The state of the association. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
     *         successfully associated and ready to pass traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociating</code>: The initial state after calling
     *         <a>DeleteDirectConnectGatewayAssociation</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the
     *         Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or
     *         transit gateway is stopped.
     *         </p>
     *         </li>
     * @see DirectConnectGatewayAssociationState
     */
    public final String associationStateAsString() {
        return associationState;
    }

    /**
     * <p>
     * The error message if the state of an object failed to advance.
     * </p>
     * 
     * @return The error message if the state of an object failed to advance.
     */
    public final String stateChangeError() {
        return stateChangeError;
    }

    /**
     * <p>
     * Information about the associated gateway.
     * </p>
     * 
     * @return Information about the associated gateway.
     */
    public final AssociatedGateway associatedGateway() {
        return associatedGateway;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway association.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * Returns true if the AllowedPrefixesToDirectConnectGateway property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasAllowedPrefixesToDirectConnectGateway() {
        return allowedPrefixesToDirectConnectGateway != null
                && !(allowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedPrefixesToDirectConnectGateway()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     */
    public final List<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway() {
        return allowedPrefixesToDirectConnectGateway;
    }

    /**
     * <p>
     * The ID of the virtual private gateway. Applies only to private virtual interfaces.
     * </p>
     * 
     * @return The ID of the virtual private gateway. Applies only to private virtual interfaces.
     */
    public final String virtualGatewayId() {
        return virtualGatewayId;
    }

    /**
     * <p>
     * The AWS Region where the virtual private gateway is located.
     * </p>
     * 
     * @return The AWS Region where the virtual private gateway is located.
     */
    public final String virtualGatewayRegion() {
        return virtualGatewayRegion;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the virtual private gateway.
     * </p>
     * 
     * @return The ID of the AWS account that owns the virtual private gateway.
     */
    public final String virtualGatewayOwnerAccount() {
        return virtualGatewayOwnerAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeError());
        hashCode = 31 * hashCode + Objects.hashCode(associatedGateway());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAllowedPrefixesToDirectConnectGateway() ? allowedPrefixesToDirectConnectGateway() : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayOwnerAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAssociation)) {
            return false;
        }
        DirectConnectGatewayAssociation other = (DirectConnectGatewayAssociation) obj;
        return Objects.equals(directConnectGatewayId(), other.directConnectGatewayId())
                && Objects.equals(directConnectGatewayOwnerAccount(), other.directConnectGatewayOwnerAccount())
                && Objects.equals(associationStateAsString(), other.associationStateAsString())
                && Objects.equals(stateChangeError(), other.stateChangeError())
                && Objects.equals(associatedGateway(), other.associatedGateway())
                && Objects.equals(associationId(), other.associationId())
                && hasAllowedPrefixesToDirectConnectGateway() == other.hasAllowedPrefixesToDirectConnectGateway()
                && Objects.equals(allowedPrefixesToDirectConnectGateway(), other.allowedPrefixesToDirectConnectGateway())
                && Objects.equals(virtualGatewayId(), other.virtualGatewayId())
                && Objects.equals(virtualGatewayRegion(), other.virtualGatewayRegion())
                && Objects.equals(virtualGatewayOwnerAccount(), other.virtualGatewayOwnerAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DirectConnectGatewayAssociation")
                .add("DirectConnectGatewayId", directConnectGatewayId())
                .add("DirectConnectGatewayOwnerAccount", directConnectGatewayOwnerAccount())
                .add("AssociationState", associationStateAsString())
                .add("StateChangeError", stateChangeError())
                .add("AssociatedGateway", associatedGateway())
                .add("AssociationId", associationId())
                .add("AllowedPrefixesToDirectConnectGateway",
                        hasAllowedPrefixesToDirectConnectGateway() ? allowedPrefixesToDirectConnectGateway() : null)
                .add("VirtualGatewayId", virtualGatewayId()).add("VirtualGatewayRegion", virtualGatewayRegion())
                .add("VirtualGatewayOwnerAccount", virtualGatewayOwnerAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayId":
            return Optional.ofNullable(clazz.cast(directConnectGatewayId()));
        case "directConnectGatewayOwnerAccount":
            return Optional.ofNullable(clazz.cast(directConnectGatewayOwnerAccount()));
        case "associationState":
            return Optional.ofNullable(clazz.cast(associationStateAsString()));
        case "stateChangeError":
            return Optional.ofNullable(clazz.cast(stateChangeError()));
        case "associatedGateway":
            return Optional.ofNullable(clazz.cast(associatedGateway()));
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "allowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(allowedPrefixesToDirectConnectGateway()));
        case "virtualGatewayId":
            return Optional.ofNullable(clazz.cast(virtualGatewayId()));
        case "virtualGatewayRegion":
            return Optional.ofNullable(clazz.cast(virtualGatewayRegion()));
        case "virtualGatewayOwnerAccount":
            return Optional.ofNullable(clazz.cast(virtualGatewayOwnerAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAssociation, T> g) {
        return obj -> g.apply((DirectConnectGatewayAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectConnectGatewayAssociation> {
        /**
         * <p>
         * The ID of the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayId
         *        The ID of the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayId(String directConnectGatewayId);

        /**
         * <p>
         * The ID of the AWS account that owns the associated gateway.
         * </p>
         * 
         * @param directConnectGatewayOwnerAccount
         *        The ID of the AWS account that owns the associated gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount);

        /**
         * <p>
         * The state of the association. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
         * successfully associated and ready to pass traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct
         * Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit
         * gateway is stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationState
         *        The state of the association. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>associating</code>: The initial state after calling
         *        <a>CreateDirectConnectGatewayAssociation</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
         *        successfully associated and ready to pass traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>disassociating</code>: The initial state after calling
         *        <a>DeleteDirectConnectGatewayAssociation</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the
         *        Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or
         *        transit gateway is stopped.
         *        </p>
         *        </li>
         * @see DirectConnectGatewayAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectConnectGatewayAssociationState
         */
        Builder associationState(String associationState);

        /**
         * <p>
         * The state of the association. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
         * successfully associated and ready to pass traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct
         * Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit
         * gateway is stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationState
         *        The state of the association. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>associating</code>: The initial state after calling
         *        <a>CreateDirectConnectGatewayAssociation</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are
         *        successfully associated and ready to pass traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>disassociating</code>: The initial state after calling
         *        <a>DeleteDirectConnectGatewayAssociation</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the
         *        Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or
         *        transit gateway is stopped.
         *        </p>
         *        </li>
         * @see DirectConnectGatewayAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectConnectGatewayAssociationState
         */
        Builder associationState(DirectConnectGatewayAssociationState associationState);

        /**
         * <p>
         * The error message if the state of an object failed to advance.
         * </p>
         * 
         * @param stateChangeError
         *        The error message if the state of an object failed to advance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeError(String stateChangeError);

        /**
         * <p>
         * Information about the associated gateway.
         * </p>
         * 
         * @param associatedGateway
         *        Information about the associated gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedGateway(AssociatedGateway associatedGateway);

        /**
         * <p>
         * Information about the associated gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link AssociatedGateway.Builder} avoiding the need to
         * create one manually via {@link AssociatedGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociatedGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #associatedGateway(AssociatedGateway)}.
         * 
         * @param associatedGateway
         *        a consumer that will call methods on {@link AssociatedGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedGateway(AssociatedGateway)
         */
        default Builder associatedGateway(Consumer<AssociatedGateway.Builder> associatedGateway) {
            return associatedGateway(AssociatedGateway.builder().applyMutation(associatedGateway).build());
        }

        /**
         * <p>
         * The ID of the Direct Connect gateway association.
         * </p>
         * 
         * @param associationId
         *        The ID of the Direct Connect gateway association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param allowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param allowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPrefixesToDirectConnectGateway(RouteFilterPrefix... allowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #allowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param allowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)
         */
        Builder allowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... allowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The ID of the virtual private gateway. Applies only to private virtual interfaces.
         * </p>
         * 
         * @param virtualGatewayId
         *        The ID of the virtual private gateway. Applies only to private virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayId(String virtualGatewayId);

        /**
         * <p>
         * The AWS Region where the virtual private gateway is located.
         * </p>
         * 
         * @param virtualGatewayRegion
         *        The AWS Region where the virtual private gateway is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayRegion(String virtualGatewayRegion);

        /**
         * <p>
         * The ID of the AWS account that owns the virtual private gateway.
         * </p>
         * 
         * @param virtualGatewayOwnerAccount
         *        The ID of the AWS account that owns the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayOwnerAccount(String virtualGatewayOwnerAccount);
    }

    static final class BuilderImpl implements Builder {
        private String directConnectGatewayId;

        private String directConnectGatewayOwnerAccount;

        private String associationState;

        private String stateChangeError;

        private AssociatedGateway associatedGateway;

        private String associationId;

        private List<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private String virtualGatewayId;

        private String virtualGatewayRegion;

        private String virtualGatewayOwnerAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAssociation model) {
            directConnectGatewayId(model.directConnectGatewayId);
            directConnectGatewayOwnerAccount(model.directConnectGatewayOwnerAccount);
            associationState(model.associationState);
            stateChangeError(model.stateChangeError);
            associatedGateway(model.associatedGateway);
            associationId(model.associationId);
            allowedPrefixesToDirectConnectGateway(model.allowedPrefixesToDirectConnectGateway);
            virtualGatewayId(model.virtualGatewayId);
            virtualGatewayRegion(model.virtualGatewayRegion);
            virtualGatewayOwnerAccount(model.virtualGatewayOwnerAccount);
        }

        public final String getDirectConnectGatewayId() {
            return directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getDirectConnectGatewayOwnerAccount() {
            return directConnectGatewayOwnerAccount;
        }

        @Override
        public final Builder directConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
            return this;
        }

        public final void setDirectConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
        }

        public final String getAssociationState() {
            return associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(DirectConnectGatewayAssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        public final String getStateChangeError() {
            return stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public final AssociatedGateway.Builder getAssociatedGateway() {
            return associatedGateway != null ? associatedGateway.toBuilder() : null;
        }

        @Override
        public final Builder associatedGateway(AssociatedGateway associatedGateway) {
            this.associatedGateway = associatedGateway;
            return this;
        }

        public final void setAssociatedGateway(AssociatedGateway.BuilderImpl associatedGateway) {
            this.associatedGateway = associatedGateway != null ? associatedGateway.build() : null;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Collection<RouteFilterPrefix.Builder> getAllowedPrefixesToDirectConnectGateway() {
            if (allowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedPrefixesToDirectConnectGateway != null ? allowedPrefixesToDirectConnectGateway.stream()
                    .map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder allowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway) {
            this.allowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(allowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedPrefixesToDirectConnectGateway(RouteFilterPrefix... allowedPrefixesToDirectConnectGateway) {
            allowedPrefixesToDirectConnectGateway(Arrays.asList(allowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... allowedPrefixesToDirectConnectGateway) {
            allowedPrefixesToDirectConnectGateway(Stream.of(allowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> allowedPrefixesToDirectConnectGateway) {
            this.allowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(allowedPrefixesToDirectConnectGateway);
        }

        public final String getVirtualGatewayId() {
            return virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public final String getVirtualGatewayRegion() {
            return virtualGatewayRegion;
        }

        @Override
        public final Builder virtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
            return this;
        }

        public final void setVirtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
        }

        public final String getVirtualGatewayOwnerAccount() {
            return virtualGatewayOwnerAccount;
        }

        @Override
        public final Builder virtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
            return this;
        }

        public final void setVirtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
        }

        @Override
        public DirectConnectGatewayAssociation build() {
            return new DirectConnectGatewayAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
