/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLagRequest extends DirectConnectRequest implements
        ToCopyableBuilder<CreateLagRequest.Builder, CreateLagRequest> {
    private static final SdkField<Integer> NUMBER_OF_CONNECTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfConnections").getter(getter(CreateLagRequest::numberOfConnections))
            .setter(setter(Builder::numberOfConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfConnections").build())
            .build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(CreateLagRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> CONNECTIONS_BANDWIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionsBandwidth").getter(getter(CreateLagRequest::connectionsBandwidth))
            .setter(setter(Builder::connectionsBandwidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionsBandwidth").build())
            .build();

    private static final SdkField<String> LAG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagName").getter(getter(CreateLagRequest::lagName)).setter(setter(Builder::lagName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagName").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(CreateLagRequest::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateLagRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> CHILD_CONNECTION_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("childConnectionTags")
            .getter(getter(CreateLagRequest::childConnectionTags))
            .setter(setter(Builder::childConnectionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childConnectionTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(CreateLagRequest::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CONNECTIONS_FIELD,
            LOCATION_FIELD, CONNECTIONS_BANDWIDTH_FIELD, LAG_NAME_FIELD, CONNECTION_ID_FIELD, TAGS_FIELD,
            CHILD_CONNECTION_TAGS_FIELD, PROVIDER_NAME_FIELD));

    private final Integer numberOfConnections;

    private final String location;

    private final String connectionsBandwidth;

    private final String lagName;

    private final String connectionId;

    private final List<Tag> tags;

    private final List<Tag> childConnectionTags;

    private final String providerName;

    private CreateLagRequest(BuilderImpl builder) {
        super(builder);
        this.numberOfConnections = builder.numberOfConnections;
        this.location = builder.location;
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.lagName = builder.lagName;
        this.connectionId = builder.connectionId;
        this.tags = builder.tags;
        this.childConnectionTags = builder.childConnectionTags;
        this.providerName = builder.providerName;
    }

    /**
     * <p>
     * The number of physical dedicated connections initially provisioned and bundled by the LAG.
     * </p>
     * 
     * @return The number of physical dedicated connections initially provisioned and bundled by the LAG.
     */
    public final Integer numberOfConnections() {
        return numberOfConnections;
    }

    /**
     * <p>
     * The location for the LAG.
     * </p>
     * 
     * @return The location for the LAG.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps
     * and 10Gbps.
     * </p>
     * 
     * @return The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values
     *         are 1Gbps and 10Gbps.
     */
    public final String connectionsBandwidth() {
        return connectionsBandwidth;
    }

    /**
     * <p>
     * The name of the LAG.
     * </p>
     * 
     * @return The name of the LAG.
     */
    public final String lagName() {
        return lagName;
    }

    /**
     * <p>
     * The ID of an existing dedicated connection to migrate to the LAG.
     * </p>
     * 
     * @return The ID of an existing dedicated connection to migrate to the LAG.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with the LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to associate with the LAG.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the ChildConnectionTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasChildConnectionTags() {
        return childConnectionTags != null && !(childConnectionTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with the automtically created LAGs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChildConnectionTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to associate with the automtically created LAGs.
     */
    public final List<Tag> childConnectionTags() {
        return childConnectionTags;
    }

    /**
     * <p>
     * The name of the service provider associated with the LAG.
     * </p>
     * 
     * @return The name of the service provider associated with the LAG.
     */
    public final String providerName() {
        return providerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(numberOfConnections());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(connectionsBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(lagName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChildConnectionTags() ? childConnectionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLagRequest)) {
            return false;
        }
        CreateLagRequest other = (CreateLagRequest) obj;
        return Objects.equals(numberOfConnections(), other.numberOfConnections()) && Objects.equals(location(), other.location())
                && Objects.equals(connectionsBandwidth(), other.connectionsBandwidth())
                && Objects.equals(lagName(), other.lagName()) && Objects.equals(connectionId(), other.connectionId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasChildConnectionTags() == other.hasChildConnectionTags()
                && Objects.equals(childConnectionTags(), other.childConnectionTags())
                && Objects.equals(providerName(), other.providerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLagRequest").add("NumberOfConnections", numberOfConnections()).add("Location", location())
                .add("ConnectionsBandwidth", connectionsBandwidth()).add("LagName", lagName())
                .add("ConnectionId", connectionId()).add("Tags", hasTags() ? tags() : null)
                .add("ChildConnectionTags", hasChildConnectionTags() ? childConnectionTags() : null)
                .add("ProviderName", providerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfConnections":
            return Optional.ofNullable(clazz.cast(numberOfConnections()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "connectionsBandwidth":
            return Optional.ofNullable(clazz.cast(connectionsBandwidth()));
        case "lagName":
            return Optional.ofNullable(clazz.cast(lagName()));
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "childConnectionTags":
            return Optional.ofNullable(clazz.cast(childConnectionTags()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLagRequest, T> g) {
        return obj -> g.apply((CreateLagRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLagRequest> {
        /**
         * <p>
         * The number of physical dedicated connections initially provisioned and bundled by the LAG.
         * </p>
         * 
         * @param numberOfConnections
         *        The number of physical dedicated connections initially provisioned and bundled by the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfConnections(Integer numberOfConnections);

        /**
         * <p>
         * The location for the LAG.
         * </p>
         * 
         * @param location
         *        The location for the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are
         * 1Gbps and 10Gbps.
         * </p>
         * 
         * @param connectionsBandwidth
         *        The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values
         *        are 1Gbps and 10Gbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionsBandwidth(String connectionsBandwidth);

        /**
         * <p>
         * The name of the LAG.
         * </p>
         * 
         * @param lagName
         *        The name of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagName(String lagName);

        /**
         * <p>
         * The ID of an existing dedicated connection to migrate to the LAG.
         * </p>
         * 
         * @param connectionId
         *        The ID of an existing dedicated connection to migrate to the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The tags to associate with the LAG.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to associate with the LAG.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to associate with the LAG.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The tags to associate with the automtically created LAGs.
         * </p>
         * 
         * @param childConnectionTags
         *        The tags to associate with the automtically created LAGs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childConnectionTags(Collection<Tag> childConnectionTags);

        /**
         * <p>
         * The tags to associate with the automtically created LAGs.
         * </p>
         * 
         * @param childConnectionTags
         *        The tags to associate with the automtically created LAGs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childConnectionTags(Tag... childConnectionTags);

        /**
         * <p>
         * The tags to associate with the automtically created LAGs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #childConnectionTags(List<Tag>)}.
         * 
         * @param childConnectionTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childConnectionTags(List<Tag>)
         */
        Builder childConnectionTags(Consumer<Tag.Builder>... childConnectionTags);

        /**
         * <p>
         * The name of the service provider associated with the LAG.
         * </p>
         * 
         * @param providerName
         *        The name of the service provider associated with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private Integer numberOfConnections;

        private String location;

        private String connectionsBandwidth;

        private String lagName;

        private String connectionId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> childConnectionTags = DefaultSdkAutoConstructList.getInstance();

        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLagRequest model) {
            super(model);
            numberOfConnections(model.numberOfConnections);
            location(model.location);
            connectionsBandwidth(model.connectionsBandwidth);
            lagName(model.lagName);
            connectionId(model.connectionId);
            tags(model.tags);
            childConnectionTags(model.childConnectionTags);
            providerName(model.providerName);
        }

        public final Integer getNumberOfConnections() {
            return numberOfConnections;
        }

        @Override
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getConnectionsBandwidth() {
            return connectionsBandwidth;
        }

        @Override
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        public final String getLagName() {
            return lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<Tag.Builder> getChildConnectionTags() {
            if (childConnectionTags instanceof SdkAutoConstructList) {
                return null;
            }
            return childConnectionTags != null ? childConnectionTags.stream().map(Tag::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder childConnectionTags(Collection<Tag> childConnectionTags) {
            this.childConnectionTags = TagListCopier.copy(childConnectionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childConnectionTags(Tag... childConnectionTags) {
            childConnectionTags(Arrays.asList(childConnectionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childConnectionTags(Consumer<Tag.Builder>... childConnectionTags) {
            childConnectionTags(Stream.of(childConnectionTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setChildConnectionTags(Collection<Tag.BuilderImpl> childConnectionTags) {
            this.childConnectionTags = TagListCopier.copyFromBuilder(childConnectionTags);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLagRequest build() {
            return new CreateLagRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
