/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInterconnectsRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeInterconnectsRequest> {
    private static final SdkField<String> INTERCONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interconnectId").getter(DescribeInterconnectsRequest.getter(DescribeInterconnectsRequest::interconnectId)).setter(DescribeInterconnectsRequest.setter(Builder::interconnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_ID_FIELD));
    private final String interconnectId;

    private DescribeInterconnectsRequest(BuilderImpl builder) {
        super(builder);
        this.interconnectId = builder.interconnectId;
    }

    public final String interconnectId() {
        return this.interconnectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectsRequest)) {
            return false;
        }
        DescribeInterconnectsRequest other = (DescribeInterconnectsRequest)((Object)obj);
        return Objects.equals(this.interconnectId(), other.interconnectId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInterconnectsRequest").add("InterconnectId", (Object)this.interconnectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.ofNullable(clazz.cast(this.interconnectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInterconnectsRequest, T> g) {
        return obj -> g.apply((DescribeInterconnectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String interconnectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectsRequest model) {
            super(model);
            this.interconnectId(model.interconnectId);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInterconnectsRequest build() {
            return new DescribeInterconnectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInterconnectsRequest> {
        public Builder interconnectId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

