/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewPublicVirtualInterfaceAllocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NewPublicVirtualInterfaceAllocation> {
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceName").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::virtualInterfaceName)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::virtualInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlan").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::vlan)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()}).build();
    private static final SdkField<Integer> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("asn").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::asn)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()}).build();
    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authKey").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::authKey)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::authKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()}).build();
    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amazonAddress").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::amazonAddress)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::amazonAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()}).build();
    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerAddress").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::customerAddress)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::customerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressFamily").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::addressFamilyAsString)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> ROUTE_FILTER_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routeFilterPrefixes").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::routeFilterPrefixes)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::routeFilterPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeFilterPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(NewPublicVirtualInterfaceAllocation.getter(NewPublicVirtualInterfaceAllocation::tags)).setter(NewPublicVirtualInterfaceAllocation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_NAME_FIELD, VLAN_FIELD, ASN_FIELD, AUTH_KEY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, ADDRESS_FAMILY_FIELD, ROUTE_FILTER_PREFIXES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final String authKey;
    private final String amazonAddress;
    private final String customerAddress;
    private final String addressFamily;
    private final List<RouteFilterPrefix> routeFilterPrefixes;
    private final List<Tag> tags;

    private NewPublicVirtualInterfaceAllocation(BuilderImpl builder) {
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.tags = builder.tags;
    }

    public String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyAsString() {
        return this.addressFamily;
    }

    public boolean hasRouteFilterPrefixes() {
        return this.routeFilterPrefixes != null && !(this.routeFilterPrefixes instanceof SdkAutoConstructList);
    }

    public List<RouteFilterPrefix> routeFilterPrefixes() {
        return this.routeFilterPrefixes;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteFilterPrefixes() ? this.routeFilterPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewPublicVirtualInterfaceAllocation)) {
            return false;
        }
        NewPublicVirtualInterfaceAllocation other = (NewPublicVirtualInterfaceAllocation)obj;
        return Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && this.hasRouteFilterPrefixes() == other.hasRouteFilterPrefixes() && Objects.equals(this.routeFilterPrefixes(), other.routeFilterPrefixes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"NewPublicVirtualInterfaceAllocation").add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).add("Vlan", (Object)this.vlan()).add("Asn", (Object)this.asn()).add("AuthKey", (Object)this.authKey()).add("AmazonAddress", (Object)this.amazonAddress()).add("CustomerAddress", (Object)this.customerAddress()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("RouteFilterPrefixes", this.hasRouteFilterPrefixes() ? this.routeFilterPrefixes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceName()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "authKey": {
                return Optional.ofNullable(clazz.cast(this.authKey()));
            }
            case "amazonAddress": {
                return Optional.ofNullable(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "routeFilterPrefixes": {
                return Optional.ofNullable(clazz.cast(this.routeFilterPrefixes()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewPublicVirtualInterfaceAllocation, T> g) {
        return obj -> g.apply((NewPublicVirtualInterfaceAllocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private String authKey;
        private String amazonAddress;
        private String customerAddress;
        private String addressFamily;
        private List<RouteFilterPrefix> routeFilterPrefixes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NewPublicVirtualInterfaceAllocation model) {
            this.virtualInterfaceName(model.virtualInterfaceName);
            this.vlan(model.vlan);
            this.asn(model.asn);
            this.authKey(model.authKey);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.addressFamily(model.addressFamily);
            this.routeFilterPrefixes(model.routeFilterPrefixes);
            this.tags(model.tags);
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final Collection<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            if (this.routeFilterPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routeFilterPrefixes != null ? (Collection)this.routeFilterPrefixes.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder> ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Stream.of(routeFilterPrefixes).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public NewPublicVirtualInterfaceAllocation build() {
            return new NewPublicVirtualInterfaceAllocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NewPublicVirtualInterfaceAllocation> {
        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder routeFilterPrefixes(Collection<RouteFilterPrefix> var1);

        public Builder routeFilterPrefixes(RouteFilterPrefix ... var1);

        public Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

