/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDirectConnectGatewayAssociationRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, UpdateDirectConnectGatewayAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDirectConnectGatewayAssociationRequest.getter(UpdateDirectConnectGatewayAssociationRequest::associationId)).setter(UpdateDirectConnectGatewayAssociationRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDirectConnectGatewayAssociationRequest.getter(UpdateDirectConnectGatewayAssociationRequest::addAllowedPrefixesToDirectConnectGateway)).setter(UpdateDirectConnectGatewayAssociationRequest.setter(Builder::addAllowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addAllowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> REMOVE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDirectConnectGatewayAssociationRequest.getter(UpdateDirectConnectGatewayAssociationRequest::removeAllowedPrefixesToDirectConnectGateway)).setter(UpdateDirectConnectGatewayAssociationRequest.setter(Builder::removeAllowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAllowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD, REMOVE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));
    private final String associationId;
    private final List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway;
    private final List<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway;

    private UpdateDirectConnectGatewayAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.addAllowedPrefixesToDirectConnectGateway = builder.addAllowedPrefixesToDirectConnectGateway;
        this.removeAllowedPrefixesToDirectConnectGateway = builder.removeAllowedPrefixesToDirectConnectGateway;
    }

    public String associationId() {
        return this.associationId;
    }

    public boolean hasAddAllowedPrefixesToDirectConnectGateway() {
        return this.addAllowedPrefixesToDirectConnectGateway != null && !(this.addAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    public List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway() {
        return this.addAllowedPrefixesToDirectConnectGateway;
    }

    public boolean hasRemoveAllowedPrefixesToDirectConnectGateway() {
        return this.removeAllowedPrefixesToDirectConnectGateway != null && !(this.removeAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    public List<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway() {
        return this.removeAllowedPrefixesToDirectConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.addAllowedPrefixesToDirectConnectGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeAllowedPrefixesToDirectConnectGateway());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayAssociationRequest)) {
            return false;
        }
        UpdateDirectConnectGatewayAssociationRequest other = (UpdateDirectConnectGatewayAssociationRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.addAllowedPrefixesToDirectConnectGateway(), other.addAllowedPrefixesToDirectConnectGateway()) && Objects.equals(this.removeAllowedPrefixesToDirectConnectGateway(), other.removeAllowedPrefixesToDirectConnectGateway());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDirectConnectGatewayAssociationRequest").add("AssociationId", (Object)this.associationId()).add("AddAllowedPrefixesToDirectConnectGateway", this.addAllowedPrefixesToDirectConnectGateway()).add("RemoveAllowedPrefixesToDirectConnectGateway", this.removeAllowedPrefixesToDirectConnectGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "addAllowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.addAllowedPrefixesToDirectConnectGateway()));
            }
            case "removeAllowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.removeAllowedPrefixesToDirectConnectGateway()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String associationId;
        private List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();
        private List<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayAssociationRequest model) {
            super(model);
            this.associationId(model.associationId);
            this.addAllowedPrefixesToDirectConnectGateway(model.addAllowedPrefixesToDirectConnectGateway);
            this.removeAllowedPrefixesToDirectConnectGateway(model.removeAllowedPrefixesToDirectConnectGateway);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Collection<RouteFilterPrefix.Builder> getAddAllowedPrefixesToDirectConnectGateway() {
            return this.addAllowedPrefixesToDirectConnectGateway != null ? (Collection)this.addAllowedPrefixesToDirectConnectGateway.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(addAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway(Arrays.asList(addAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway(Stream.of(addAllowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(addAllowedPrefixesToDirectConnectGateway);
        }

        public final Collection<RouteFilterPrefix.Builder> getRemoveAllowedPrefixesToDirectConnectGateway() {
            return this.removeAllowedPrefixesToDirectConnectGateway != null ? (Collection)this.removeAllowedPrefixesToDirectConnectGateway.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder removeAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway) {
            this.removeAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(removeAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... removeAllowedPrefixesToDirectConnectGateway) {
            this.removeAllowedPrefixesToDirectConnectGateway(Arrays.asList(removeAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... removeAllowedPrefixesToDirectConnectGateway) {
            this.removeAllowedPrefixesToDirectConnectGateway(Stream.of(removeAllowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemoveAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> removeAllowedPrefixesToDirectConnectGateway) {
            this.removeAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(removeAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayAssociationRequest build() {
            return new UpdateDirectConnectGatewayAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDirectConnectGatewayAssociationRequest> {
        public Builder associationId(String var1);

        public Builder addAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder addAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder addAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder removeAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder removeAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder removeAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

