/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the integration of DevOps Guru with another Amazon Web Services service, such as Amazon Web
 * Services Systems Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceIntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceIntegrationConfig.Builder, ServiceIntegrationConfig> {
    private static final SdkField<OpsCenterIntegration> OPS_CENTER_FIELD = SdkField
            .<OpsCenterIntegration> builder(MarshallingType.SDK_POJO).memberName("OpsCenter")
            .getter(getter(ServiceIntegrationConfig::opsCenter)).setter(setter(Builder::opsCenter))
            .constructor(OpsCenterIntegration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenter").build()).build();

    private static final SdkField<LogsAnomalyDetectionIntegration> LOGS_ANOMALY_DETECTION_FIELD = SdkField
            .<LogsAnomalyDetectionIntegration> builder(MarshallingType.SDK_POJO).memberName("LogsAnomalyDetection")
            .getter(getter(ServiceIntegrationConfig::logsAnomalyDetection)).setter(setter(Builder::logsAnomalyDetection))
            .constructor(LogsAnomalyDetectionIntegration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsAnomalyDetection").build())
            .build();

    private static final SdkField<KMSServerSideEncryptionIntegration> KMS_SERVER_SIDE_ENCRYPTION_FIELD = SdkField
            .<KMSServerSideEncryptionIntegration> builder(MarshallingType.SDK_POJO).memberName("KMSServerSideEncryption")
            .getter(getter(ServiceIntegrationConfig::kmsServerSideEncryption)).setter(setter(Builder::kmsServerSideEncryption))
            .constructor(KMSServerSideEncryptionIntegration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSServerSideEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_CENTER_FIELD,
            LOGS_ANOMALY_DETECTION_FIELD, KMS_SERVER_SIDE_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpsCenterIntegration opsCenter;

    private final LogsAnomalyDetectionIntegration logsAnomalyDetection;

    private final KMSServerSideEncryptionIntegration kmsServerSideEncryption;

    private ServiceIntegrationConfig(BuilderImpl builder) {
        this.opsCenter = builder.opsCenter;
        this.logsAnomalyDetection = builder.logsAnomalyDetection;
        this.kmsServerSideEncryption = builder.kmsServerSideEncryption;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager
     * OpsCenter for each created insight.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems
     *         Manager OpsCenter for each created insight.
     */
    public final OpsCenterIntegration opsCenter() {
        return opsCenter;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
     * groups.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch
     *         log groups.
     */
    public final LogsAnomalyDetectionIntegration logsAnomalyDetection() {
        return logsAnomalyDetection;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
     */
    public final KMSServerSideEncryptionIntegration kmsServerSideEncryption() {
        return kmsServerSideEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsCenter());
        hashCode = 31 * hashCode + Objects.hashCode(logsAnomalyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(kmsServerSideEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceIntegrationConfig)) {
            return false;
        }
        ServiceIntegrationConfig other = (ServiceIntegrationConfig) obj;
        return Objects.equals(opsCenter(), other.opsCenter())
                && Objects.equals(logsAnomalyDetection(), other.logsAnomalyDetection())
                && Objects.equals(kmsServerSideEncryption(), other.kmsServerSideEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceIntegrationConfig").add("OpsCenter", opsCenter())
                .add("LogsAnomalyDetection", logsAnomalyDetection()).add("KMSServerSideEncryption", kmsServerSideEncryption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsCenter":
            return Optional.ofNullable(clazz.cast(opsCenter()));
        case "LogsAnomalyDetection":
            return Optional.ofNullable(clazz.cast(logsAnomalyDetection()));
        case "KMSServerSideEncryption":
            return Optional.ofNullable(clazz.cast(kmsServerSideEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpsCenter", OPS_CENTER_FIELD);
        map.put("LogsAnomalyDetection", LOGS_ANOMALY_DETECTION_FIELD);
        map.put("KMSServerSideEncryption", KMS_SERVER_SIDE_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceIntegrationConfig, T> g) {
        return obj -> g.apply((ServiceIntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceIntegrationConfig> {
        /**
         * <p>
         * Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems
         * Manager OpsCenter for each created insight.
         * </p>
         * 
         * @param opsCenter
         *        Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services
         *        Systems Manager OpsCenter for each created insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenter(OpsCenterIntegration opsCenter);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems
         * Manager OpsCenter for each created insight.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpsCenterIntegration.Builder} avoiding
         * the need to create one manually via {@link OpsCenterIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpsCenterIntegration.Builder#build()} is called immediately and
         * its result is passed to {@link #opsCenter(OpsCenterIntegration)}.
         * 
         * @param opsCenter
         *        a consumer that will call methods on {@link OpsCenterIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsCenter(OpsCenterIntegration)
         */
        default Builder opsCenter(Consumer<OpsCenterIntegration.Builder> opsCenter) {
            return opsCenter(OpsCenterIntegration.builder().applyMutation(opsCenter).build());
        }

        /**
         * <p>
         * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
         * groups.
         * </p>
         * 
         * @param logsAnomalyDetection
         *        Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon
         *        CloudWatch log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsAnomalyDetection(LogsAnomalyDetectionIntegration logsAnomalyDetection);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
         * groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogsAnomalyDetectionIntegration.Builder}
         * avoiding the need to create one manually via {@link LogsAnomalyDetectionIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsAnomalyDetectionIntegration.Builder#build()} is called
         * immediately and its result is passed to {@link #logsAnomalyDetection(LogsAnomalyDetectionIntegration)}.
         * 
         * @param logsAnomalyDetection
         *        a consumer that will call methods on {@link LogsAnomalyDetectionIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsAnomalyDetection(LogsAnomalyDetectionIntegration)
         */
        default Builder logsAnomalyDetection(Consumer<LogsAnomalyDetectionIntegration.Builder> logsAnomalyDetection) {
            return logsAnomalyDetection(LogsAnomalyDetectionIntegration.builder().applyMutation(logsAnomalyDetection).build());
        }

        /**
         * <p>
         * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
         * </p>
         * 
         * @param kmsServerSideEncryption
         *        Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsServerSideEncryption(KMSServerSideEncryptionIntegration kmsServerSideEncryption);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KMSServerSideEncryptionIntegration.Builder} avoiding the need to create one manually via
         * {@link KMSServerSideEncryptionIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KMSServerSideEncryptionIntegration.Builder#build()} is called
         * immediately and its result is passed to {@link #kmsServerSideEncryption(KMSServerSideEncryptionIntegration)}.
         * 
         * @param kmsServerSideEncryption
         *        a consumer that will call methods on {@link KMSServerSideEncryptionIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsServerSideEncryption(KMSServerSideEncryptionIntegration)
         */
        default Builder kmsServerSideEncryption(Consumer<KMSServerSideEncryptionIntegration.Builder> kmsServerSideEncryption) {
            return kmsServerSideEncryption(KMSServerSideEncryptionIntegration.builder().applyMutation(kmsServerSideEncryption)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpsCenterIntegration opsCenter;

        private LogsAnomalyDetectionIntegration logsAnomalyDetection;

        private KMSServerSideEncryptionIntegration kmsServerSideEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceIntegrationConfig model) {
            opsCenter(model.opsCenter);
            logsAnomalyDetection(model.logsAnomalyDetection);
            kmsServerSideEncryption(model.kmsServerSideEncryption);
        }

        public final OpsCenterIntegration.Builder getOpsCenter() {
            return opsCenter != null ? opsCenter.toBuilder() : null;
        }

        public final void setOpsCenter(OpsCenterIntegration.BuilderImpl opsCenter) {
            this.opsCenter = opsCenter != null ? opsCenter.build() : null;
        }

        @Override
        public final Builder opsCenter(OpsCenterIntegration opsCenter) {
            this.opsCenter = opsCenter;
            return this;
        }

        public final LogsAnomalyDetectionIntegration.Builder getLogsAnomalyDetection() {
            return logsAnomalyDetection != null ? logsAnomalyDetection.toBuilder() : null;
        }

        public final void setLogsAnomalyDetection(LogsAnomalyDetectionIntegration.BuilderImpl logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection != null ? logsAnomalyDetection.build() : null;
        }

        @Override
        public final Builder logsAnomalyDetection(LogsAnomalyDetectionIntegration logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection;
            return this;
        }

        public final KMSServerSideEncryptionIntegration.Builder getKmsServerSideEncryption() {
            return kmsServerSideEncryption != null ? kmsServerSideEncryption.toBuilder() : null;
        }

        public final void setKmsServerSideEncryption(KMSServerSideEncryptionIntegration.BuilderImpl kmsServerSideEncryption) {
            this.kmsServerSideEncryption = kmsServerSideEncryption != null ? kmsServerSideEncryption.build() : null;
        }

        @Override
        public final Builder kmsServerSideEncryption(KMSServerSideEncryptionIntegration kmsServerSideEncryption) {
            this.kmsServerSideEncryption = kmsServerSideEncryption;
            return this;
        }

        @Override
        public ServiceIntegrationConfig build() {
            return new ServiceIntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
