/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies values used to filter responses when searching for insights. You can use a <code>ResourceCollection</code>,
 * <code>ServiceCollection</code>, array of severities, and an array of status values. Each filter type contains one or
 * more values to search for. If you specify multiple filter types, the filter types are joined with an <code>AND</code>
 * , and the request returns only results that match all of the specified filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchInsightsFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchInsightsFilters.Builder, SearchInsightsFilters> {
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Severities")
            .getter(getter(SearchInsightsFilters::severitiesAsStrings))
            .setter(setter(Builder::severitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Statuses")
            .getter(getter(SearchInsightsFilters::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(SearchInsightsFilters::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<ServiceCollection> SERVICE_COLLECTION_FIELD = SdkField
            .<ServiceCollection> builder(MarshallingType.SDK_POJO).memberName("ServiceCollection")
            .getter(getter(SearchInsightsFilters::serviceCollection)).setter(setter(Builder::serviceCollection))
            .constructor(ServiceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCollection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITIES_FIELD,
            STATUSES_FIELD, RESOURCE_COLLECTION_FIELD, SERVICE_COLLECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> severities;

    private final List<String> statuses;

    private final ResourceCollection resourceCollection;

    private final ServiceCollection serviceCollection;

    private SearchInsightsFilters(BuilderImpl builder) {
        this.severities = builder.severities;
        this.statuses = builder.statuses;
        this.resourceCollection = builder.resourceCollection;
        this.serviceCollection = builder.serviceCollection;
    }

    /**
     * <p>
     * An array of severity values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverities} method.
     * </p>
     * 
     * @return An array of severity values used to search for insights.
     */
    public final List<InsightSeverity> severities() {
        return InsightSeveritiesCopier.copyStringToEnum(severities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Severities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSeverities() {
        return severities != null && !(severities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of severity values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverities} method.
     * </p>
     * 
     * @return An array of severity values used to search for insights.
     */
    public final List<String> severitiesAsStrings() {
        return severities;
    }

    /**
     * <p>
     * An array of status values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return An array of status values used to search for insights.
     */
    public final List<InsightStatus> statuses() {
        return InsightStatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of status values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return An array of status values used to search for insights.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * A collection of the names of Amazon Web Services services.
     * </p>
     * 
     * @return A collection of the names of Amazon Web Services services.
     */
    public final ServiceCollection serviceCollection() {
        return serviceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverities() ? severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInsightsFilters)) {
            return false;
        }
        SearchInsightsFilters other = (SearchInsightsFilters) obj;
        return hasSeverities() == other.hasSeverities() && Objects.equals(severitiesAsStrings(), other.severitiesAsStrings())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && Objects.equals(resourceCollection(), other.resourceCollection())
                && Objects.equals(serviceCollection(), other.serviceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchInsightsFilters").add("Severities", hasSeverities() ? severitiesAsStrings() : null)
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).add("ResourceCollection", resourceCollection())
                .add("ServiceCollection", serviceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Severities":
            return Optional.ofNullable(clazz.cast(severitiesAsStrings()));
        case "Statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "ServiceCollection":
            return Optional.ofNullable(clazz.cast(serviceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Severities", SEVERITIES_FIELD);
        map.put("Statuses", STATUSES_FIELD);
        map.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        map.put("ServiceCollection", SERVICE_COLLECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchInsightsFilters, T> g) {
        return obj -> g.apply((SearchInsightsFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchInsightsFilters> {
        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(Collection<String> severities);

        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(String... severities);

        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(Collection<InsightSeverity> severities);

        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(InsightSeverity... severities);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<InsightStatus> statuses);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(InsightStatus... statuses);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceCollection.Builder} avoiding the
         * need to create one manually via {@link ResourceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * A collection of the names of Amazon Web Services services.
         * </p>
         * 
         * @param serviceCollection
         *        A collection of the names of Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCollection(ServiceCollection serviceCollection);

        /**
         * <p>
         * A collection of the names of Amazon Web Services services.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceCollection.Builder} avoiding the
         * need to create one manually via {@link ServiceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceCollection(ServiceCollection)}.
         * 
         * @param serviceCollection
         *        a consumer that will call methods on {@link ServiceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCollection(ServiceCollection)
         */
        default Builder serviceCollection(Consumer<ServiceCollection.Builder> serviceCollection) {
            return serviceCollection(ServiceCollection.builder().applyMutation(serviceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private ResourceCollection resourceCollection;

        private ServiceCollection serviceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInsightsFilters model) {
            severitiesWithStrings(model.severities);
            statusesWithStrings(model.statuses);
            resourceCollection(model.resourceCollection);
            serviceCollection(model.serviceCollection);
        }

        public final Collection<String> getSeverities() {
            if (severities instanceof SdkAutoConstructList) {
                return null;
            }
            return severities;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String... severities) {
            severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<InsightSeverity> severities) {
            this.severities = InsightSeveritiesCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(InsightSeverity... severities) {
            severities(Arrays.asList(severities));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = InsightStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = InsightStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<InsightStatus> statuses) {
            this.statuses = InsightStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(InsightStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final ServiceCollection.Builder getServiceCollection() {
            return serviceCollection != null ? serviceCollection.toBuilder() : null;
        }

        public final void setServiceCollection(ServiceCollection.BuilderImpl serviceCollection) {
            this.serviceCollection = serviceCollection != null ? serviceCollection.build() : null;
        }

        @Override
        public final Builder serviceCollection(ServiceCollection serviceCollection) {
            this.serviceCollection = serviceCollection;
            return this;
        }

        @Override
        public SearchInsightsFilters build() {
            return new SearchInsightsFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
