/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an event that is related to a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationRelatedEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationRelatedEvent.Builder, RecommendationRelatedEvent> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RecommendationRelatedEvent::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<RecommendationRelatedEventResource>> RESOURCES_FIELD = SdkField
            .<List<RecommendationRelatedEventResource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(RecommendationRelatedEvent::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationRelatedEventResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationRelatedEventResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<RecommendationRelatedEventResource> resources;

    private RecommendationRelatedEvent(BuilderImpl builder) {
        this.name = builder.name;
        this.resources = builder.resources;
    }

    /**
     * <p>
     * The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object.
     * </p>
     * 
     * @return The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services CloudFormation
     * stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services
     *         CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public final List<RecommendationRelatedEventResource> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationRelatedEvent)) {
            return false;
        }
        RecommendationRelatedEvent other = (RecommendationRelatedEvent) obj;
        return Objects.equals(name(), other.name()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationRelatedEvent").add("Name", name())
                .add("Resources", hasResources() ? resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationRelatedEvent, T> g) {
        return obj -> g.apply((RecommendationRelatedEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationRelatedEvent> {
        /**
         * <p>
         * The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object.
         * </p>
         * 
         * @param name
         *        The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code>
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services
         * CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * 
         * @param resources
         *        A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services
         *        CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<RecommendationRelatedEventResource> resources);

        /**
         * <p>
         * A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services
         * CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * 
         * @param resources
         *        A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services
         *        CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(RecommendationRelatedEventResource... resources);

        /**
         * <p>
         * A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services
         * CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #resources(List<RecommendationRelatedEventResource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<RecommendationRelatedEventResource>)
         */
        Builder resources(Consumer<RecommendationRelatedEventResource.Builder>... resources);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<RecommendationRelatedEventResource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationRelatedEvent model) {
            name(model.name);
            resources(model.resources);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RecommendationRelatedEventResource.Builder> getResources() {
            List<RecommendationRelatedEventResource.Builder> result = RecommendationRelatedEventResourcesCopier
                    .copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<RecommendationRelatedEventResource.BuilderImpl> resources) {
            this.resources = RecommendationRelatedEventResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<RecommendationRelatedEventResource> resources) {
            this.resources = RecommendationRelatedEventResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(RecommendationRelatedEventResource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<RecommendationRelatedEventResource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> RecommendationRelatedEventResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecommendationRelatedEvent build() {
            return new RecommendationRelatedEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
