/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a proactive insight. This object is returned by <code>DescribeInsight</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProactiveOrganizationInsightSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProactiveOrganizationInsightSummary.Builder, ProactiveOrganizationInsightSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProactiveOrganizationInsightSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ProactiveOrganizationInsightSummary::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitId").getter(getter(ProactiveOrganizationInsightSummary::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProactiveOrganizationInsightSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ProactiveOrganizationInsightSummary::severityAsString))
            .setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProactiveOrganizationInsightSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<InsightTimeRange> INSIGHT_TIME_RANGE_FIELD = SdkField
            .<InsightTimeRange> builder(MarshallingType.SDK_POJO).memberName("InsightTimeRange")
            .getter(getter(ProactiveOrganizationInsightSummary::insightTimeRange)).setter(setter(Builder::insightTimeRange))
            .constructor(InsightTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightTimeRange").build()).build();

    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField
            .<PredictionTimeRange> builder(MarshallingType.SDK_POJO).memberName("PredictionTimeRange")
            .getter(getter(ProactiveOrganizationInsightSummary::predictionTimeRange))
            .setter(setter(Builder::predictionTimeRange)).constructor(PredictionTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionTimeRange").build())
            .build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(ProactiveOrganizationInsightSummary::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<ServiceCollection> SERVICE_COLLECTION_FIELD = SdkField
            .<ServiceCollection> builder(MarshallingType.SDK_POJO).memberName("ServiceCollection")
            .getter(getter(ProactiveOrganizationInsightSummary::serviceCollection)).setter(setter(Builder::serviceCollection))
            .constructor(ServiceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCollection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ACCOUNT_ID_FIELD,
            ORGANIZATIONAL_UNIT_ID_FIELD, NAME_FIELD, SEVERITY_FIELD, STATUS_FIELD, INSIGHT_TIME_RANGE_FIELD,
            PREDICTION_TIME_RANGE_FIELD, RESOURCE_COLLECTION_FIELD, SERVICE_COLLECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String accountId;

    private final String organizationalUnitId;

    private final String name;

    private final String severity;

    private final String status;

    private final InsightTimeRange insightTimeRange;

    private final PredictionTimeRange predictionTimeRange;

    private final ResourceCollection resourceCollection;

    private final ServiceCollection serviceCollection;

    private ProactiveOrganizationInsightSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.accountId = builder.accountId;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.name = builder.name;
        this.severity = builder.severity;
        this.status = builder.status;
        this.insightTimeRange = builder.insightTimeRange;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.resourceCollection = builder.resourceCollection;
        this.serviceCollection = builder.serviceCollection;
    }

    /**
     * <p>
     * The ID of the insight summary.
     * </p>
     * 
     * @return The ID of the insight summary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the organizational unit.
     * </p>
     * 
     * @return The ID of the organizational unit.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    /**
     * <p>
     * The name of the insight summary.
     * </p>
     * 
     * @return The name of the insight summary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An array of severity values used to search for insights. For more information, see <a href=
     * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link InsightSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return An array of severity values used to search for insights. For more information, see <a href=
     *         "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     *         >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * @see InsightSeverity
     */
    public final InsightSeverity severity() {
        return InsightSeverity.fromValue(severity);
    }

    /**
     * <p>
     * An array of severity values used to search for insights. For more information, see <a href=
     * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link InsightSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return An array of severity values used to search for insights. For more information, see <a href=
     *         "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     *         >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * @see InsightSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * An array of status values used to search for insights.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An array of status values used to search for insights.
     * @see InsightStatus
     */
    public final InsightStatus status() {
        return InsightStatus.fromValue(status);
    }

    /**
     * <p>
     * An array of status values used to search for insights.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An array of status values used to search for insights.
     * @see InsightStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the InsightTimeRange property for this object.
     * 
     * @return The value of the InsightTimeRange property for this object.
     */
    public final InsightTimeRange insightTimeRange() {
        return insightTimeRange;
    }

    /**
     * Returns the value of the PredictionTimeRange property for this object.
     * 
     * @return The value of the PredictionTimeRange property for this object.
     */
    public final PredictionTimeRange predictionTimeRange() {
        return predictionTimeRange;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    /**
     * Returns the value of the ServiceCollection property for this object.
     * 
     * @return The value of the ServiceCollection property for this object.
     */
    public final ServiceCollection serviceCollection() {
        return serviceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(insightTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveOrganizationInsightSummary)) {
            return false;
        }
        ProactiveOrganizationInsightSummary other = (ProactiveOrganizationInsightSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId()) && Objects.equals(name(), other.name())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(insightTimeRange(), other.insightTimeRange())
                && Objects.equals(predictionTimeRange(), other.predictionTimeRange())
                && Objects.equals(resourceCollection(), other.resourceCollection())
                && Objects.equals(serviceCollection(), other.serviceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProactiveOrganizationInsightSummary").add("Id", id()).add("AccountId", accountId())
                .add("OrganizationalUnitId", organizationalUnitId()).add("Name", name()).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("InsightTimeRange", insightTimeRange())
                .add("PredictionTimeRange", predictionTimeRange()).add("ResourceCollection", resourceCollection())
                .add("ServiceCollection", serviceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InsightTimeRange":
            return Optional.ofNullable(clazz.cast(insightTimeRange()));
        case "PredictionTimeRange":
            return Optional.ofNullable(clazz.cast(predictionTimeRange()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "ServiceCollection":
            return Optional.ofNullable(clazz.cast(serviceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InsightTimeRange", INSIGHT_TIME_RANGE_FIELD);
        map.put("PredictionTimeRange", PREDICTION_TIME_RANGE_FIELD);
        map.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        map.put("ServiceCollection", SERVICE_COLLECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProactiveOrganizationInsightSummary, T> g) {
        return obj -> g.apply((ProactiveOrganizationInsightSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProactiveOrganizationInsightSummary> {
        /**
         * <p>
         * The ID of the insight summary.
         * </p>
         * 
         * @param id
         *        The ID of the insight summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the organizational unit.
         * </p>
         * 
         * @param organizationalUnitId
         *        The ID of the organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        /**
         * <p>
         * The name of the insight summary.
         * </p>
         * 
         * @param name
         *        The name of the insight summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An array of severity values used to search for insights. For more information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * </p>
         * 
         * @param severity
         *        An array of severity values used to search for insights. For more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * @see InsightSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * An array of severity values used to search for insights. For more information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * </p>
         * 
         * @param severity
         *        An array of severity values used to search for insights. For more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * @see InsightSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightSeverity
         */
        Builder severity(InsightSeverity severity);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param status
         *        An array of status values used to search for insights.
         * @see InsightStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightStatus
         */
        Builder status(String status);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param status
         *        An array of status values used to search for insights.
         * @see InsightStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightStatus
         */
        Builder status(InsightStatus status);

        /**
         * Sets the value of the InsightTimeRange property for this object.
         *
         * @param insightTimeRange
         *        The new value for the InsightTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightTimeRange(InsightTimeRange insightTimeRange);

        /**
         * Sets the value of the InsightTimeRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InsightTimeRange.Builder} avoiding the
         * need to create one manually via {@link InsightTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #insightTimeRange(InsightTimeRange)}.
         * 
         * @param insightTimeRange
         *        a consumer that will call methods on {@link InsightTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightTimeRange(InsightTimeRange)
         */
        default Builder insightTimeRange(Consumer<InsightTimeRange.Builder> insightTimeRange) {
            return insightTimeRange(InsightTimeRange.builder().applyMutation(insightTimeRange).build());
        }

        /**
         * Sets the value of the PredictionTimeRange property for this object.
         *
         * @param predictionTimeRange
         *        The new value for the PredictionTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTimeRange(PredictionTimeRange predictionTimeRange);

        /**
         * Sets the value of the PredictionTimeRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PredictionTimeRange.Builder} avoiding the
         * need to create one manually via {@link PredictionTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictionTimeRange.Builder#build()} is called immediately and
         * its result is passed to {@link #predictionTimeRange(PredictionTimeRange)}.
         * 
         * @param predictionTimeRange
         *        a consumer that will call methods on {@link PredictionTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictionTimeRange(PredictionTimeRange)
         */
        default Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return predictionTimeRange(PredictionTimeRange.builder().applyMutation(predictionTimeRange).build());
        }

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceCollection.Builder} avoiding the
         * need to create one manually via {@link ResourceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }

        /**
         * Sets the value of the ServiceCollection property for this object.
         *
         * @param serviceCollection
         *        The new value for the ServiceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCollection(ServiceCollection serviceCollection);

        /**
         * Sets the value of the ServiceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServiceCollection.Builder} avoiding the
         * need to create one manually via {@link ServiceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceCollection(ServiceCollection)}.
         * 
         * @param serviceCollection
         *        a consumer that will call methods on {@link ServiceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCollection(ServiceCollection)
         */
        default Builder serviceCollection(Consumer<ServiceCollection.Builder> serviceCollection) {
            return serviceCollection(ServiceCollection.builder().applyMutation(serviceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String accountId;

        private String organizationalUnitId;

        private String name;

        private String severity;

        private String status;

        private InsightTimeRange insightTimeRange;

        private PredictionTimeRange predictionTimeRange;

        private ResourceCollection resourceCollection;

        private ServiceCollection serviceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveOrganizationInsightSummary model) {
            id(model.id);
            accountId(model.accountId);
            organizationalUnitId(model.organizationalUnitId);
            name(model.name);
            severity(model.severity);
            status(model.status);
            insightTimeRange(model.insightTimeRange);
            predictionTimeRange(model.predictionTimeRange);
            resourceCollection(model.resourceCollection);
            serviceCollection(model.serviceCollection);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(InsightSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InsightStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InsightTimeRange.Builder getInsightTimeRange() {
            return insightTimeRange != null ? insightTimeRange.toBuilder() : null;
        }

        public final void setInsightTimeRange(InsightTimeRange.BuilderImpl insightTimeRange) {
            this.insightTimeRange = insightTimeRange != null ? insightTimeRange.build() : null;
        }

        @Override
        public final Builder insightTimeRange(InsightTimeRange insightTimeRange) {
            this.insightTimeRange = insightTimeRange;
            return this;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return predictionTimeRange != null ? predictionTimeRange.toBuilder() : null;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final ServiceCollection.Builder getServiceCollection() {
            return serviceCollection != null ? serviceCollection.toBuilder() : null;
        }

        public final void setServiceCollection(ServiceCollection.BuilderImpl serviceCollection) {
            this.serviceCollection = serviceCollection != null ? serviceCollection.build() : null;
        }

        @Override
        public final Builder serviceCollection(ServiceCollection serviceCollection) {
            this.serviceCollection = serviceCollection;
            return this;
        }

        @Override
        public ProactiveOrganizationInsightSummary build() {
            return new ProactiveOrganizationInsightSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
