/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. You can choose to specify
 * which events or message types to receive notifications for. You can also choose to specify which severity levels to
 * receive notifications for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationFilterConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationFilterConfig.Builder, NotificationFilterConfig> {
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Severities")
            .getter(getter(NotificationFilterConfig::severitiesAsStrings))
            .setter(setter(Builder::severitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MESSAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MessageTypes")
            .getter(getter(NotificationFilterConfig::messageTypesAsStrings))
            .setter(setter(Builder::messageTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITIES_FIELD,
            MESSAGE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> severities;

    private final List<String> messageTypes;

    private NotificationFilterConfig(BuilderImpl builder) {
        this.severities = builder.severities;
        this.messageTypes = builder.messageTypes;
    }

    /**
     * <p>
     * The severity levels that you want to receive notifications for. For example, you can choose to receive
     * notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     * >Understanding insight severities</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverities} method.
     * </p>
     * 
     * @return The severity levels that you want to receive notifications for. For example, you can choose to receive
     *         notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     *         >Understanding insight severities</a>.
     */
    public final List<InsightSeverity> severities() {
        return InsightSeveritiesCopier.copyStringToEnum(severities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Severities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSeverities() {
        return severities != null && !(severities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The severity levels that you want to receive notifications for. For example, you can choose to receive
     * notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     * >Understanding insight severities</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverities} method.
     * </p>
     * 
     * @return The severity levels that you want to receive notifications for. For example, you can choose to receive
     *         notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     *         >Understanding insight severities</a>.
     */
    public final List<String> severitiesAsStrings() {
        return severities;
    }

    /**
     * <p>
     * The events that you want to receive notifications for. For example, you can choose to receive notifications only
     * when the severity level is upgraded or a new insight is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageTypes} method.
     * </p>
     * 
     * @return The events that you want to receive notifications for. For example, you can choose to receive
     *         notifications only when the severity level is upgraded or a new insight is created.
     */
    public final List<NotificationMessageType> messageTypes() {
        return NotificationMessageTypesCopier.copyStringToEnum(messageTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageTypes() {
        return messageTypes != null && !(messageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that you want to receive notifications for. For example, you can choose to receive notifications only
     * when the severity level is upgraded or a new insight is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageTypes} method.
     * </p>
     * 
     * @return The events that you want to receive notifications for. For example, you can choose to receive
     *         notifications only when the severity level is upgraded or a new insight is created.
     */
    public final List<String> messageTypesAsStrings() {
        return messageTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverities() ? severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageTypes() ? messageTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationFilterConfig)) {
            return false;
        }
        NotificationFilterConfig other = (NotificationFilterConfig) obj;
        return hasSeverities() == other.hasSeverities() && Objects.equals(severitiesAsStrings(), other.severitiesAsStrings())
                && hasMessageTypes() == other.hasMessageTypes()
                && Objects.equals(messageTypesAsStrings(), other.messageTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationFilterConfig").add("Severities", hasSeverities() ? severitiesAsStrings() : null)
                .add("MessageTypes", hasMessageTypes() ? messageTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Severities":
            return Optional.ofNullable(clazz.cast(severitiesAsStrings()));
        case "MessageTypes":
            return Optional.ofNullable(clazz.cast(messageTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Severities", SEVERITIES_FIELD);
        map.put("MessageTypes", MESSAGE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationFilterConfig, T> g) {
        return obj -> g.apply((NotificationFilterConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationFilterConfig> {
        /**
         * <p>
         * The severity levels that you want to receive notifications for. For example, you can choose to receive
         * notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a>.
         * </p>
         * 
         * @param severities
         *        The severity levels that you want to receive notifications for. For example, you can choose to receive
         *        notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(Collection<String> severities);

        /**
         * <p>
         * The severity levels that you want to receive notifications for. For example, you can choose to receive
         * notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a>.
         * </p>
         * 
         * @param severities
         *        The severity levels that you want to receive notifications for. For example, you can choose to receive
         *        notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(String... severities);

        /**
         * <p>
         * The severity levels that you want to receive notifications for. For example, you can choose to receive
         * notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a>.
         * </p>
         * 
         * @param severities
         *        The severity levels that you want to receive notifications for. For example, you can choose to receive
         *        notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(Collection<InsightSeverity> severities);

        /**
         * <p>
         * The severity levels that you want to receive notifications for. For example, you can choose to receive
         * notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a>.
         * </p>
         * 
         * @param severities
         *        The severity levels that you want to receive notifications for. For example, you can choose to receive
         *        notifications only for insights with <code>HIGH</code> and <code>MEDIUM</code> severity levels. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(InsightSeverity... severities);

        /**
         * <p>
         * The events that you want to receive notifications for. For example, you can choose to receive notifications
         * only when the severity level is upgraded or a new insight is created.
         * </p>
         * 
         * @param messageTypes
         *        The events that you want to receive notifications for. For example, you can choose to receive
         *        notifications only when the severity level is upgraded or a new insight is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypesWithStrings(Collection<String> messageTypes);

        /**
         * <p>
         * The events that you want to receive notifications for. For example, you can choose to receive notifications
         * only when the severity level is upgraded or a new insight is created.
         * </p>
         * 
         * @param messageTypes
         *        The events that you want to receive notifications for. For example, you can choose to receive
         *        notifications only when the severity level is upgraded or a new insight is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypesWithStrings(String... messageTypes);

        /**
         * <p>
         * The events that you want to receive notifications for. For example, you can choose to receive notifications
         * only when the severity level is upgraded or a new insight is created.
         * </p>
         * 
         * @param messageTypes
         *        The events that you want to receive notifications for. For example, you can choose to receive
         *        notifications only when the severity level is upgraded or a new insight is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypes(Collection<NotificationMessageType> messageTypes);

        /**
         * <p>
         * The events that you want to receive notifications for. For example, you can choose to receive notifications
         * only when the severity level is upgraded or a new insight is created.
         * </p>
         * 
         * @param messageTypes
         *        The events that you want to receive notifications for. For example, you can choose to receive
         *        notifications only when the severity level is upgraded or a new insight is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypes(NotificationMessageType... messageTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();

        private List<String> messageTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationFilterConfig model) {
            severitiesWithStrings(model.severities);
            messageTypesWithStrings(model.messageTypes);
        }

        public final Collection<String> getSeverities() {
            if (severities instanceof SdkAutoConstructList) {
                return null;
            }
            return severities;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String... severities) {
            severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<InsightSeverity> severities) {
            this.severities = InsightSeveritiesCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(InsightSeverity... severities) {
            severities(Arrays.asList(severities));
            return this;
        }

        public final Collection<String> getMessageTypes() {
            if (messageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return messageTypes;
        }

        public final void setMessageTypes(Collection<String> messageTypes) {
            this.messageTypes = NotificationMessageTypesCopier.copy(messageTypes);
        }

        @Override
        public final Builder messageTypesWithStrings(Collection<String> messageTypes) {
            this.messageTypes = NotificationMessageTypesCopier.copy(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypesWithStrings(String... messageTypes) {
            messageTypesWithStrings(Arrays.asList(messageTypes));
            return this;
        }

        @Override
        public final Builder messageTypes(Collection<NotificationMessageType> messageTypes) {
            this.messageTypes = NotificationMessageTypesCopier.copyEnumToString(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypes(NotificationMessageType... messageTypes) {
            messageTypes(Arrays.asList(messageTypes));
            return this;
        }

        @Override
        public NotificationFilterConfig build() {
            return new NotificationFilterConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
