/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the integration of DevOps Guru with CloudWatch log groups for log anomaly detection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsAnomalyDetectionIntegration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogsAnomalyDetectionIntegration.Builder, LogsAnomalyDetectionIntegration> {
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptInStatus").getter(getter(LogsAnomalyDetectionIntegration::optInStatusAsString))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String optInStatus;

    private LogsAnomalyDetectionIntegration(BuilderImpl builder) {
        this.optInStatus = builder.optInStatus;
    }

    /**
     * <p>
     * Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link OptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
     * @see OptInStatus
     */
    public final OptInStatus optInStatus() {
        return OptInStatus.fromValue(optInStatus);
    }

    /**
     * <p>
     * Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link OptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
     * @see OptInStatus
     */
    public final String optInStatusAsString() {
        return optInStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optInStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsAnomalyDetectionIntegration)) {
            return false;
        }
        LogsAnomalyDetectionIntegration other = (LogsAnomalyDetectionIntegration) obj;
        return Objects.equals(optInStatusAsString(), other.optInStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsAnomalyDetectionIntegration").add("OptInStatus", optInStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogsAnomalyDetectionIntegration, T> g) {
        return obj -> g.apply((LogsAnomalyDetectionIntegration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsAnomalyDetectionIntegration> {
        /**
         * <p>
         * Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
         * </p>
         * 
         * @param optInStatus
         *        Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
         * @see OptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInStatus
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
         * </p>
         * 
         * @param optInStatus
         *        Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups.
         * @see OptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInStatus
         */
        Builder optInStatus(OptInStatus optInStatus);
    }

    static final class BuilderImpl implements Builder {
        private String optInStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsAnomalyDetectionIntegration model) {
            optInStatus(model.optInStatus);
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(OptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        @Override
        public LogsAnomalyDetectionIntegration build() {
            return new LogsAnomalyDetectionIntegration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
