/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an anomalous log event found within a log group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogAnomalyClass implements SdkPojo, Serializable, ToCopyableBuilder<LogAnomalyClass.Builder, LogAnomalyClass> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStreamName").getter(getter(LogAnomalyClass::logStreamName)).setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamName").build()).build();

    private static final SdkField<String> LOG_ANOMALY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogAnomalyType").getter(getter(LogAnomalyClass::logAnomalyTypeAsString))
            .setter(setter(Builder::logAnomalyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyType").build()).build();

    private static final SdkField<String> LOG_ANOMALY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogAnomalyToken").getter(getter(LogAnomalyClass::logAnomalyToken))
            .setter(setter(Builder::logAnomalyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyToken").build()).build();

    private static final SdkField<String> LOG_EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogEventId").getter(getter(LogAnomalyClass::logEventId)).setter(setter(Builder::logEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEventId").build()).build();

    private static final SdkField<String> EXPLANATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Explanation").getter(getter(LogAnomalyClass::explanation)).setter(setter(Builder::explanation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explanation").build()).build();

    private static final SdkField<Integer> NUMBER_OF_LOG_LINES_OCCURRENCES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfLogLinesOccurrences")
            .getter(getter(LogAnomalyClass::numberOfLogLinesOccurrences))
            .setter(setter(Builder::numberOfLogLinesOccurrences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLogLinesOccurrences")
                    .build()).build();

    private static final SdkField<Instant> LOG_EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LogEventTimestamp").getter(getter(LogAnomalyClass::logEventTimestamp))
            .setter(setter(Builder::logEventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEventTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD,
            LOG_ANOMALY_TYPE_FIELD, LOG_ANOMALY_TOKEN_FIELD, LOG_EVENT_ID_FIELD, EXPLANATION_FIELD,
            NUMBER_OF_LOG_LINES_OCCURRENCES_FIELD, LOG_EVENT_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logStreamName;

    private final String logAnomalyType;

    private final String logAnomalyToken;

    private final String logEventId;

    private final String explanation;

    private final Integer numberOfLogLinesOccurrences;

    private final Instant logEventTimestamp;

    private LogAnomalyClass(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.logAnomalyType = builder.logAnomalyType;
        this.logAnomalyToken = builder.logAnomalyToken;
        this.logEventId = builder.logEventId;
        this.explanation = builder.explanation;
        this.numberOfLogLinesOccurrences = builder.numberOfLogLinesOccurrences;
        this.logEventTimestamp = builder.logEventTimestamp;
    }

    /**
     * <p>
     * The name of the Amazon CloudWatch log stream that the anomalous log event belongs to. A log stream is a sequence
     * of log events that share the same source.
     * </p>
     * 
     * @return The name of the Amazon CloudWatch log stream that the anomalous log event belongs to. A log stream is a
     *         sequence of log events that share the same source.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The type of log anomaly that has been detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logAnomalyType}
     * will return {@link LogAnomalyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logAnomalyTypeAsString}.
     * </p>
     * 
     * @return The type of log anomaly that has been detected.
     * @see LogAnomalyType
     */
    public final LogAnomalyType logAnomalyType() {
        return LogAnomalyType.fromValue(logAnomalyType);
    }

    /**
     * <p>
     * The type of log anomaly that has been detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logAnomalyType}
     * will return {@link LogAnomalyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logAnomalyTypeAsString}.
     * </p>
     * 
     * @return The type of log anomaly that has been detected.
     * @see LogAnomalyType
     */
    public final String logAnomalyTypeAsString() {
        return logAnomalyType;
    }

    /**
     * <p>
     * The token where the anomaly was detected. This may refer to an exception or another location, or it may be blank
     * for log anomalies such as format anomalies.
     * </p>
     * 
     * @return The token where the anomaly was detected. This may refer to an exception or another location, or it may
     *         be blank for log anomalies such as format anomalies.
     */
    public final String logAnomalyToken() {
        return logAnomalyToken;
    }

    /**
     * <p>
     * The ID of the log event.
     * </p>
     * 
     * @return The ID of the log event.
     */
    public final String logEventId() {
        return logEventId;
    }

    /**
     * <p>
     * The explanation for why the log event is considered an anomaly.
     * </p>
     * 
     * @return The explanation for why the log event is considered an anomaly.
     */
    public final String explanation() {
        return explanation;
    }

    /**
     * <p>
     * The number of log lines where this anomalous log event occurs.
     * </p>
     * 
     * @return The number of log lines where this anomalous log event occurs.
     */
    public final Integer numberOfLogLinesOccurrences() {
        return numberOfLogLinesOccurrences;
    }

    /**
     * <p>
     * The time of the first occurrence of the anomalous log event.
     * </p>
     * 
     * @return The time of the first occurrence of the anomalous log event.
     */
    public final Instant logEventTimestamp() {
        return logEventTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(logAnomalyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logAnomalyToken());
        hashCode = 31 * hashCode + Objects.hashCode(logEventId());
        hashCode = 31 * hashCode + Objects.hashCode(explanation());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfLogLinesOccurrences());
        hashCode = 31 * hashCode + Objects.hashCode(logEventTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogAnomalyClass)) {
            return false;
        }
        LogAnomalyClass other = (LogAnomalyClass) obj;
        return Objects.equals(logStreamName(), other.logStreamName())
                && Objects.equals(logAnomalyTypeAsString(), other.logAnomalyTypeAsString())
                && Objects.equals(logAnomalyToken(), other.logAnomalyToken()) && Objects.equals(logEventId(), other.logEventId())
                && Objects.equals(explanation(), other.explanation())
                && Objects.equals(numberOfLogLinesOccurrences(), other.numberOfLogLinesOccurrences())
                && Objects.equals(logEventTimestamp(), other.logEventTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogAnomalyClass").add("LogStreamName", logStreamName())
                .add("LogAnomalyType", logAnomalyTypeAsString()).add("LogAnomalyToken", logAnomalyToken())
                .add("LogEventId", logEventId()).add("Explanation", explanation())
                .add("NumberOfLogLinesOccurrences", numberOfLogLinesOccurrences()).add("LogEventTimestamp", logEventTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "LogAnomalyType":
            return Optional.ofNullable(clazz.cast(logAnomalyTypeAsString()));
        case "LogAnomalyToken":
            return Optional.ofNullable(clazz.cast(logAnomalyToken()));
        case "LogEventId":
            return Optional.ofNullable(clazz.cast(logEventId()));
        case "Explanation":
            return Optional.ofNullable(clazz.cast(explanation()));
        case "NumberOfLogLinesOccurrences":
            return Optional.ofNullable(clazz.cast(numberOfLogLinesOccurrences()));
        case "LogEventTimestamp":
            return Optional.ofNullable(clazz.cast(logEventTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogStreamName", LOG_STREAM_NAME_FIELD);
        map.put("LogAnomalyType", LOG_ANOMALY_TYPE_FIELD);
        map.put("LogAnomalyToken", LOG_ANOMALY_TOKEN_FIELD);
        map.put("LogEventId", LOG_EVENT_ID_FIELD);
        map.put("Explanation", EXPLANATION_FIELD);
        map.put("NumberOfLogLinesOccurrences", NUMBER_OF_LOG_LINES_OCCURRENCES_FIELD);
        map.put("LogEventTimestamp", LOG_EVENT_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogAnomalyClass, T> g) {
        return obj -> g.apply((LogAnomalyClass) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogAnomalyClass> {
        /**
         * <p>
         * The name of the Amazon CloudWatch log stream that the anomalous log event belongs to. A log stream is a
         * sequence of log events that share the same source.
         * </p>
         * 
         * @param logStreamName
         *        The name of the Amazon CloudWatch log stream that the anomalous log event belongs to. A log stream is
         *        a sequence of log events that share the same source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The type of log anomaly that has been detected.
         * </p>
         * 
         * @param logAnomalyType
         *        The type of log anomaly that has been detected.
         * @see LogAnomalyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogAnomalyType
         */
        Builder logAnomalyType(String logAnomalyType);

        /**
         * <p>
         * The type of log anomaly that has been detected.
         * </p>
         * 
         * @param logAnomalyType
         *        The type of log anomaly that has been detected.
         * @see LogAnomalyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogAnomalyType
         */
        Builder logAnomalyType(LogAnomalyType logAnomalyType);

        /**
         * <p>
         * The token where the anomaly was detected. This may refer to an exception or another location, or it may be
         * blank for log anomalies such as format anomalies.
         * </p>
         * 
         * @param logAnomalyToken
         *        The token where the anomaly was detected. This may refer to an exception or another location, or it
         *        may be blank for log anomalies such as format anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logAnomalyToken(String logAnomalyToken);

        /**
         * <p>
         * The ID of the log event.
         * </p>
         * 
         * @param logEventId
         *        The ID of the log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventId(String logEventId);

        /**
         * <p>
         * The explanation for why the log event is considered an anomaly.
         * </p>
         * 
         * @param explanation
         *        The explanation for why the log event is considered an anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explanation(String explanation);

        /**
         * <p>
         * The number of log lines where this anomalous log event occurs.
         * </p>
         * 
         * @param numberOfLogLinesOccurrences
         *        The number of log lines where this anomalous log event occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLogLinesOccurrences(Integer numberOfLogLinesOccurrences);

        /**
         * <p>
         * The time of the first occurrence of the anomalous log event.
         * </p>
         * 
         * @param logEventTimestamp
         *        The time of the first occurrence of the anomalous log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventTimestamp(Instant logEventTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String logStreamName;

        private String logAnomalyType;

        private String logAnomalyToken;

        private String logEventId;

        private String explanation;

        private Integer numberOfLogLinesOccurrences;

        private Instant logEventTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(LogAnomalyClass model) {
            logStreamName(model.logStreamName);
            logAnomalyType(model.logAnomalyType);
            logAnomalyToken(model.logAnomalyToken);
            logEventId(model.logEventId);
            explanation(model.explanation);
            numberOfLogLinesOccurrences(model.numberOfLogLinesOccurrences);
            logEventTimestamp(model.logEventTimestamp);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final String getLogAnomalyType() {
            return logAnomalyType;
        }

        public final void setLogAnomalyType(String logAnomalyType) {
            this.logAnomalyType = logAnomalyType;
        }

        @Override
        public final Builder logAnomalyType(String logAnomalyType) {
            this.logAnomalyType = logAnomalyType;
            return this;
        }

        @Override
        public final Builder logAnomalyType(LogAnomalyType logAnomalyType) {
            this.logAnomalyType(logAnomalyType == null ? null : logAnomalyType.toString());
            return this;
        }

        public final String getLogAnomalyToken() {
            return logAnomalyToken;
        }

        public final void setLogAnomalyToken(String logAnomalyToken) {
            this.logAnomalyToken = logAnomalyToken;
        }

        @Override
        public final Builder logAnomalyToken(String logAnomalyToken) {
            this.logAnomalyToken = logAnomalyToken;
            return this;
        }

        public final String getLogEventId() {
            return logEventId;
        }

        public final void setLogEventId(String logEventId) {
            this.logEventId = logEventId;
        }

        @Override
        public final Builder logEventId(String logEventId) {
            this.logEventId = logEventId;
            return this;
        }

        public final String getExplanation() {
            return explanation;
        }

        public final void setExplanation(String explanation) {
            this.explanation = explanation;
        }

        @Override
        public final Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public final Integer getNumberOfLogLinesOccurrences() {
            return numberOfLogLinesOccurrences;
        }

        public final void setNumberOfLogLinesOccurrences(Integer numberOfLogLinesOccurrences) {
            this.numberOfLogLinesOccurrences = numberOfLogLinesOccurrences;
        }

        @Override
        public final Builder numberOfLogLinesOccurrences(Integer numberOfLogLinesOccurrences) {
            this.numberOfLogLinesOccurrences = numberOfLogLinesOccurrences;
            return this;
        }

        public final Instant getLogEventTimestamp() {
            return logEventTimestamp;
        }

        public final void setLogEventTimestamp(Instant logEventTimestamp) {
            this.logEventTimestamp = logEventTimestamp;
        }

        @Override
        public final Builder logEventTimestamp(Instant logEventTimestamp) {
            this.logEventTimestamp = logEventTimestamp;
            return this;
        }

        @Override
        public LogAnomalyClass build() {
            return new LogAnomalyClass(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
