/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationChannelsResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<ListNotificationChannelsResponse.Builder, ListNotificationChannelsResponse> {
    private static final SdkField<List<NotificationChannel>> CHANNELS_FIELD = SdkField
            .<List<NotificationChannel>> builder(MarshallingType.LIST)
            .memberName("Channels")
            .getter(getter(ListNotificationChannelsResponse::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNotificationChannelsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<NotificationChannel> channels;

    private final String nextToken;

    private ListNotificationChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the requested notification channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return An array that contains the requested notification channels.
     */
    public final List<NotificationChannel> channels() {
        return channels;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationChannelsResponse)) {
            return false;
        }
        ListNotificationChannelsResponse other = (ListNotificationChannelsResponse) obj;
        return hasChannels() == other.hasChannels() && Objects.equals(channels(), other.channels())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationChannelsResponse").add("Channels", hasChannels() ? channels() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Channels", CHANNELS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationChannelsResponse, T> g) {
        return obj -> g.apply((ListNotificationChannelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationChannelsResponse> {
        /**
         * <p>
         * An array that contains the requested notification channels.
         * </p>
         * 
         * @param channels
         *        An array that contains the requested notification channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<NotificationChannel> channels);

        /**
         * <p>
         * An array that contains the requested notification channels.
         * </p>
         * 
         * @param channels
         *        An array that contains the requested notification channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(NotificationChannel... channels);

        /**
         * <p>
         * An array that contains the requested notification channels.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.NotificationChannel.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.NotificationChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.NotificationChannel.Builder#build()} is called
         * immediately and its result is passed to {@link #channels(List<NotificationChannel>)}.
         * 
         * @param channels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.NotificationChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channels(java.util.Collection<NotificationChannel>)
         */
        Builder channels(Consumer<NotificationChannel.Builder>... channels);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private List<NotificationChannel> channels = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationChannelsResponse model) {
            super(model);
            channels(model.channels);
            nextToken(model.nextToken);
        }

        public final List<NotificationChannel.Builder> getChannels() {
            List<NotificationChannel.Builder> result = ChannelsCopier.copyToBuilder(this.channels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannels(Collection<NotificationChannel.BuilderImpl> channels) {
            this.channels = ChannelsCopier.copyFromBuilder(channels);
        }

        @Override
        public final Builder channels(Collection<NotificationChannel> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(NotificationChannel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<NotificationChannel.Builder>... channels) {
            channels(Stream.of(channels).map(c -> NotificationChannel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNotificationChannelsResponse build() {
            return new ListNotificationChannelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
