/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters to determine which monitored resources you want to retrieve. You can filter by resource type or resource
 * permission status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoredResourcesFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListMonitoredResourcesFilters.Builder, ListMonitoredResourcesFilters> {
    private static final SdkField<String> RESOURCE_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePermission").getter(getter(ListMonitoredResourcesFilters::resourcePermissionAsString))
            .setter(setter(Builder::resourcePermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePermission").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_TYPE_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypeFilters")
            .getter(getter(ListMonitoredResourcesFilters::resourceTypeFiltersAsStrings))
            .setter(setter(Builder::resourceTypeFiltersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_PERMISSION_FIELD,
            RESOURCE_TYPE_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourcePermission;

    private final List<String> resourceTypeFilters;

    private ListMonitoredResourcesFilters(BuilderImpl builder) {
        this.resourcePermission = builder.resourcePermission;
        this.resourceTypeFilters = builder.resourceTypeFilters;
    }

    /**
     * <p>
     * The permission status of a resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourcePermission} will return {@link ResourcePermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resourcePermissionAsString}.
     * </p>
     * 
     * @return The permission status of a resource.
     * @see ResourcePermission
     */
    public final ResourcePermission resourcePermission() {
        return ResourcePermission.fromValue(resourcePermission);
    }

    /**
     * <p>
     * The permission status of a resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourcePermission} will return {@link ResourcePermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resourcePermissionAsString}.
     * </p>
     * 
     * @return The permission status of a resource.
     * @see ResourcePermission
     */
    public final String resourcePermissionAsString() {
        return resourcePermission;
    }

    /**
     * <p>
     * The type of resource that you wish to retrieve, such as log groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeFilters} method.
     * </p>
     * 
     * @return The type of resource that you wish to retrieve, such as log groups.
     */
    public final List<ResourceTypeFilter> resourceTypeFilters() {
        return ResourceTypeFiltersCopier.copyStringToEnum(resourceTypeFilters);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypeFilters() {
        return resourceTypeFilters != null && !(resourceTypeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of resource that you wish to retrieve, such as log groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeFilters} method.
     * </p>
     * 
     * @return The type of resource that you wish to retrieve, such as log groups.
     */
    public final List<String> resourceTypeFiltersAsStrings() {
        return resourceTypeFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourcePermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypeFilters() ? resourceTypeFiltersAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoredResourcesFilters)) {
            return false;
        }
        ListMonitoredResourcesFilters other = (ListMonitoredResourcesFilters) obj;
        return Objects.equals(resourcePermissionAsString(), other.resourcePermissionAsString())
                && hasResourceTypeFilters() == other.hasResourceTypeFilters()
                && Objects.equals(resourceTypeFiltersAsStrings(), other.resourceTypeFiltersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitoredResourcesFilters").add("ResourcePermission", resourcePermissionAsString())
                .add("ResourceTypeFilters", hasResourceTypeFilters() ? resourceTypeFiltersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourcePermission":
            return Optional.ofNullable(clazz.cast(resourcePermissionAsString()));
        case "ResourceTypeFilters":
            return Optional.ofNullable(clazz.cast(resourceTypeFiltersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourcePermission", RESOURCE_PERMISSION_FIELD);
        map.put("ResourceTypeFilters", RESOURCE_TYPE_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoredResourcesFilters, T> g) {
        return obj -> g.apply((ListMonitoredResourcesFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListMonitoredResourcesFilters> {
        /**
         * <p>
         * The permission status of a resource.
         * </p>
         * 
         * @param resourcePermission
         *        The permission status of a resource.
         * @see ResourcePermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcePermission
         */
        Builder resourcePermission(String resourcePermission);

        /**
         * <p>
         * The permission status of a resource.
         * </p>
         * 
         * @param resourcePermission
         *        The permission status of a resource.
         * @see ResourcePermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcePermission
         */
        Builder resourcePermission(ResourcePermission resourcePermission);

        /**
         * <p>
         * The type of resource that you wish to retrieve, such as log groups.
         * </p>
         * 
         * @param resourceTypeFilters
         *        The type of resource that you wish to retrieve, such as log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFiltersWithStrings(Collection<String> resourceTypeFilters);

        /**
         * <p>
         * The type of resource that you wish to retrieve, such as log groups.
         * </p>
         * 
         * @param resourceTypeFilters
         *        The type of resource that you wish to retrieve, such as log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFiltersWithStrings(String... resourceTypeFilters);

        /**
         * <p>
         * The type of resource that you wish to retrieve, such as log groups.
         * </p>
         * 
         * @param resourceTypeFilters
         *        The type of resource that you wish to retrieve, such as log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFilters(Collection<ResourceTypeFilter> resourceTypeFilters);

        /**
         * <p>
         * The type of resource that you wish to retrieve, such as log groups.
         * </p>
         * 
         * @param resourceTypeFilters
         *        The type of resource that you wish to retrieve, such as log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFilters(ResourceTypeFilter... resourceTypeFilters);
    }

    static final class BuilderImpl implements Builder {
        private String resourcePermission;

        private List<String> resourceTypeFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoredResourcesFilters model) {
            resourcePermission(model.resourcePermission);
            resourceTypeFiltersWithStrings(model.resourceTypeFilters);
        }

        public final String getResourcePermission() {
            return resourcePermission;
        }

        public final void setResourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
        }

        @Override
        public final Builder resourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
            return this;
        }

        @Override
        public final Builder resourcePermission(ResourcePermission resourcePermission) {
            this.resourcePermission(resourcePermission == null ? null : resourcePermission.toString());
            return this;
        }

        public final Collection<String> getResourceTypeFilters() {
            if (resourceTypeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypeFilters;
        }

        public final void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFiltersCopier.copy(resourceTypeFilters);
        }

        @Override
        public final Builder resourceTypeFiltersWithStrings(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFiltersCopier.copy(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFiltersWithStrings(String... resourceTypeFilters) {
            resourceTypeFiltersWithStrings(Arrays.asList(resourceTypeFilters));
            return this;
        }

        @Override
        public final Builder resourceTypeFilters(Collection<ResourceTypeFilter> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFiltersCopier.copyEnumToString(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFilters(ResourceTypeFilter... resourceTypeFilters) {
            resourceTypeFilters(Arrays.asList(resourceTypeFilters));
            return this;
        }

        @Override
        public ListMonitoredResourcesFilters build() {
            return new ListMonitoredResourcesFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
