/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostEstimationResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<GetCostEstimationResponse.Builder, GetCostEstimationResponse> {
    private static final SdkField<CostEstimationResourceCollectionFilter> RESOURCE_COLLECTION_FIELD = SdkField
            .<CostEstimationResourceCollectionFilter> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(GetCostEstimationResponse::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(CostEstimationResourceCollectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetCostEstimationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<ServiceResourceCost>> COSTS_FIELD = SdkField
            .<List<ServiceResourceCost>> builder(MarshallingType.LIST)
            .memberName("Costs")
            .getter(getter(GetCostEstimationResponse::costs))
            .setter(setter(Builder::costs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Costs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceResourceCost> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceResourceCost::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CostEstimationTimeRange> TIME_RANGE_FIELD = SdkField
            .<CostEstimationTimeRange> builder(MarshallingType.SDK_POJO).memberName("TimeRange")
            .getter(getter(GetCostEstimationResponse::timeRange)).setter(setter(Builder::timeRange))
            .constructor(CostEstimationTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()).build();

    private static final SdkField<Double> TOTAL_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalCost").getter(getter(GetCostEstimationResponse::totalCost)).setter(setter(Builder::totalCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCost").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCostEstimationResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COLLECTION_FIELD,
            STATUS_FIELD, COSTS_FIELD, TIME_RANGE_FIELD, TOTAL_COST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CostEstimationResourceCollectionFilter resourceCollection;

    private final String status;

    private final List<ServiceResourceCost> costs;

    private final CostEstimationTimeRange timeRange;

    private final Double totalCost;

    private final String nextToken;

    private GetCostEstimationResponse(BuilderImpl builder) {
        super(builder);
        this.resourceCollection = builder.resourceCollection;
        this.status = builder.status;
        this.costs = builder.costs;
        this.timeRange = builder.timeRange;
        this.totalCost = builder.totalCost;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost estimate.
     * </p>
     * 
     * @return The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost
     *         estimate.
     */
    public final CostEstimationResourceCollectionFilter resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is
     * returned. If it is finished, the status <code>COMPLETED</code> is returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostEstimationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is
     *         returned. If it is finished, the status <code>COMPLETED</code> is returned.
     * @see CostEstimationStatus
     */
    public final CostEstimationStatus status() {
        return CostEstimationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is
     * returned. If it is finished, the status <code>COMPLETED</code> is returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostEstimationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is
     *         returned. If it is finished, the status <code>COMPLETED</code> is returned.
     * @see CostEstimationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Costs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCosts() {
        return costs != null && !(costs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to
     * analyze one of your Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCosts} method.
     * </p>
     * 
     * @return An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate
     *         to analyze one of your Amazon Web Services resources.
     */
    public final List<ServiceResourceCost> costs() {
        return costs;
    }

    /**
     * <p>
     * The start and end time of the cost estimation.
     * </p>
     * 
     * @return The start and end time of the cost estimation.
     */
    public final CostEstimationTimeRange timeRange() {
        return timeRange;
    }

    /**
     * <p>
     * The estimated monthly cost to analyze the Amazon Web Services resources. This value is the sum of the estimated
     * costs to analyze each resource in the <code>Costs</code> object in this response.
     * </p>
     * 
     * @return The estimated monthly cost to analyze the Amazon Web Services resources. This value is the sum of the
     *         estimated costs to analyze each resource in the <code>Costs</code> object in this response.
     */
    public final Double totalCost() {
        return totalCost;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCosts() ? costs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(totalCost());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostEstimationResponse)) {
            return false;
        }
        GetCostEstimationResponse other = (GetCostEstimationResponse) obj;
        return Objects.equals(resourceCollection(), other.resourceCollection())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasCosts() == other.hasCosts()
                && Objects.equals(costs(), other.costs()) && Objects.equals(timeRange(), other.timeRange())
                && Objects.equals(totalCost(), other.totalCost()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostEstimationResponse").add("ResourceCollection", resourceCollection())
                .add("Status", statusAsString()).add("Costs", hasCosts() ? costs() : null).add("TimeRange", timeRange())
                .add("TotalCost", totalCost()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Costs":
            return Optional.ofNullable(clazz.cast(costs()));
        case "TimeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        case "TotalCost":
            return Optional.ofNullable(clazz.cast(totalCost()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Costs", COSTS_FIELD);
        map.put("TimeRange", TIME_RANGE_FIELD);
        map.put("TotalCost", TOTAL_COST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostEstimationResponse, T> g) {
        return obj -> g.apply((GetCostEstimationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCostEstimationResponse> {
        /**
         * <p>
         * The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost estimate.
         * </p>
         * 
         * @param resourceCollection
         *        The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost
         *        estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(CostEstimationResourceCollectionFilter resourceCollection);

        /**
         * <p>
         * The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost estimate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CostEstimationResourceCollectionFilter.Builder} avoiding the need to create one manually via
         * {@link CostEstimationResourceCollectionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostEstimationResourceCollectionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceCollection(CostEstimationResourceCollectionFilter)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link CostEstimationResourceCollectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(CostEstimationResourceCollectionFilter)
         */
        default Builder resourceCollection(Consumer<CostEstimationResourceCollectionFilter.Builder> resourceCollection) {
            return resourceCollection(CostEstimationResourceCollectionFilter.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is
         * returned. If it is finished, the status <code>COMPLETED</code> is returned.
         * </p>
         * 
         * @param status
         *        The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code>
         *        is returned. If it is finished, the status <code>COMPLETED</code> is returned.
         * @see CostEstimationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostEstimationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is
         * returned. If it is finished, the status <code>COMPLETED</code> is returned.
         * </p>
         * 
         * @param status
         *        The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code>
         *        is returned. If it is finished, the status <code>COMPLETED</code> is returned.
         * @see CostEstimationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostEstimationStatus
         */
        Builder status(CostEstimationStatus status);

        /**
         * <p>
         * An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to
         * analyze one of your Amazon Web Services resources.
         * </p>
         * 
         * @param costs
         *        An array of <code>ResourceCost</code> objects that each contains details about the monthly cost
         *        estimate to analyze one of your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costs(Collection<ServiceResourceCost> costs);

        /**
         * <p>
         * An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to
         * analyze one of your Amazon Web Services resources.
         * </p>
         * 
         * @param costs
         *        An array of <code>ResourceCost</code> objects that each contains details about the monthly cost
         *        estimate to analyze one of your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costs(ServiceResourceCost... costs);

        /**
         * <p>
         * An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to
         * analyze one of your Amazon Web Services resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost.Builder#build()} is called
         * immediately and its result is passed to {@link #costs(List<ServiceResourceCost>)}.
         * 
         * @param costs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costs(java.util.Collection<ServiceResourceCost>)
         */
        Builder costs(Consumer<ServiceResourceCost.Builder>... costs);

        /**
         * <p>
         * The start and end time of the cost estimation.
         * </p>
         * 
         * @param timeRange
         *        The start and end time of the cost estimation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(CostEstimationTimeRange timeRange);

        /**
         * <p>
         * The start and end time of the cost estimation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostEstimationTimeRange.Builder} avoiding
         * the need to create one manually via {@link CostEstimationTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostEstimationTimeRange.Builder#build()} is called immediately
         * and its result is passed to {@link #timeRange(CostEstimationTimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link CostEstimationTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(CostEstimationTimeRange)
         */
        default Builder timeRange(Consumer<CostEstimationTimeRange.Builder> timeRange) {
            return timeRange(CostEstimationTimeRange.builder().applyMutation(timeRange).build());
        }

        /**
         * <p>
         * The estimated monthly cost to analyze the Amazon Web Services resources. This value is the sum of the
         * estimated costs to analyze each resource in the <code>Costs</code> object in this response.
         * </p>
         * 
         * @param totalCost
         *        The estimated monthly cost to analyze the Amazon Web Services resources. This value is the sum of the
         *        estimated costs to analyze each resource in the <code>Costs</code> object in this response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCost(Double totalCost);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private CostEstimationResourceCollectionFilter resourceCollection;

        private String status;

        private List<ServiceResourceCost> costs = DefaultSdkAutoConstructList.getInstance();

        private CostEstimationTimeRange timeRange;

        private Double totalCost;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostEstimationResponse model) {
            super(model);
            resourceCollection(model.resourceCollection);
            status(model.status);
            costs(model.costs);
            timeRange(model.timeRange);
            totalCost(model.totalCost);
            nextToken(model.nextToken);
        }

        public final CostEstimationResourceCollectionFilter.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(CostEstimationResourceCollectionFilter.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(CostEstimationResourceCollectionFilter resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CostEstimationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ServiceResourceCost.Builder> getCosts() {
            List<ServiceResourceCost.Builder> result = ServiceResourceCostsCopier.copyToBuilder(this.costs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCosts(Collection<ServiceResourceCost.BuilderImpl> costs) {
            this.costs = ServiceResourceCostsCopier.copyFromBuilder(costs);
        }

        @Override
        public final Builder costs(Collection<ServiceResourceCost> costs) {
            this.costs = ServiceResourceCostsCopier.copy(costs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costs(ServiceResourceCost... costs) {
            costs(Arrays.asList(costs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costs(Consumer<ServiceResourceCost.Builder>... costs) {
            costs(Stream.of(costs).map(c -> ServiceResourceCost.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CostEstimationTimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(CostEstimationTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(CostEstimationTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final Double getTotalCost() {
            return totalCost;
        }

        public final void setTotalCost(Double totalCost) {
            this.totalCost = totalCost;
        }

        @Override
        public final Builder totalCost(Double totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCostEstimationResponse build() {
            return new GetCostEstimationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
